/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;

public class OPSHandler
implements XMLHandler {
    XMLParser parser;
    String path;
    HashSet idMap;
    XRefChecker xrefChecker;
    static HashSet regURISchemes = OPSHandler.fillRegURISchemes();

    private static HashSet fillRegURISchemes() {
        try {
            HashSet<String> set = new HashSet<String>();
            InputStream schemaStream = OPSHandler.class.getResourceAsStream("registeredSchemas.txt");
            BufferedReader schemaReader = new BufferedReader(new InputStreamReader(schemaStream));
            String schema = schemaReader.readLine();
            while (schema != null) {
                set.add(schema);
                schema = schemaReader.readLine();
            }
            schemaReader.close();
            schemaStream.close();
            return set;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    OPSHandler(XMLParser parser, String path, XRefChecker xrefChecker) {
        this.parser = parser;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.idMap = new HashSet();
    }

    private void checkPaint(XMLElement e, String attr) {
        String paint = e.getAttribute(attr);
        if (paint != null && paint.startsWith("url(") && paint.endsWith(")")) {
            String href = paint.substring(4, paint.length() - 1);
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), href, 16);
        }
    }

    private void checkClip(XMLElement e, String attr) {
    }

    private void checkImage(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), href, 2);
        }
    }

    private void checkObject(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), href, 3);
        }
    }

    private void checkSymbol(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), href, 18);
        }
    }

    private void checkHRef(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href != null) {
            if (OPSHandler.isRegisteredSchemaType(href)) {
                return;
            }
            if (href.indexOf(58) > 0) {
                this.parser.getReport().warning(this.path, this.parser.getLineNumber(), "use of non-registered URI schema type in href: " + href);
                return;
            }
            try {
                href = PathUtil.resolveRelativeReference(this.path, href);
            }
            catch (IllegalArgumentException err) {
                this.parser.getReport().error(this.path, this.parser.getLineNumber(), err.getMessage());
                return;
            }
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), href, 1);
        }
    }

    public static boolean isRegisteredSchemaType(String href) {
        int colonIndex = href.indexOf(58);
        if (colonIndex < 0) {
            return false;
        }
        if (regURISchemes.contains(href.substring(0, colonIndex + 1))) {
            return true;
        }
        if (href.length() > colonIndex + 2) {
            return href.substring(colonIndex + 1, colonIndex + 3).equals("//") && regURISchemes.contains(href.substring(0, colonIndex + 3));
        }
        return false;
    }

    public void startElement() {
        XMLElement e = this.parser.getCurrentElement();
        String id = e.getAttribute("id");
        String ns = e.getNamespace();
        String name = e.getName();
        int resourceType = 0;
        if (ns != null) {
            if (ns.equals("http://www.w3.org/2000/svg")) {
                if (name.equals("linearGradient") || name.equals("radialGradient") || name.equals("pattern")) {
                    resourceType = 16;
                } else if (name.equals("clipPath")) {
                    resourceType = 17;
                } else if (name.equals("symbol")) {
                    resourceType = 18;
                } else if (name.equals("a")) {
                    this.checkHRef(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("use")) {
                    this.checkSymbol(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("image")) {
                    this.checkImage(e, "http://www.w3.org/1999/xlink", "href");
                }
                this.checkPaint(e, "fill");
                this.checkPaint(e, "stroke");
                this.checkClip(e, "clip");
            } else if (ns.equals("http://www.w3.org/1999/xhtml")) {
                if (name.equals("a")) {
                    this.checkHRef(e, null, "href");
                } else if (name.equals("img")) {
                    this.checkImage(e, null, "src");
                } else if (name.equals("object")) {
                    this.checkObject(e, null, "data");
                }
                resourceType = 1;
            }
        }
        if (id != null) {
            this.xrefChecker.registerAnchor(this.path, this.parser.getLineNumber(), id, resourceType);
        }
    }

    public void endElement() {
    }

    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    public void characters(char[] chars, int arg1, int arg2) {
    }

    public void processingInstruction(String arg0, String arg1) {
    }
}

