/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public class TransportGetUserPrivilegesAction
extends HandledTransportAction<GetUserPrivilegesRequest, GetUserPrivilegesResponse> {
    private final ThreadPool threadPool;
    private final AuthorizationService authorizationService;

    @Inject
    public TransportGetUserPrivilegesAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AuthorizationService authorizationService) {
        super(settings, "cluster:admin/xpack/security/user/list_privileges", threadPool, transportService, actionFilters, GetUserPrivilegesRequest::new, indexNameExpressionResolver);
        this.threadPool = threadPool;
        this.authorizationService = authorizationService;
    }

    protected void doExecute(GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        String username = request.username();
        Authentication authentication = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext());
        User user = authentication.getUser();
        if (!user.principal().equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only list the privileges of their own account"));
            return;
        }
        this.authorizationService.retrieveUserPrivileges(authentication, request, listener);
    }
}

