/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ConcatFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ConcatFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Concat
extends BinaryScalarFunction {
    public Concat(Source source, Expression source1, Expression source2) {
        super(source, source1, source2);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact(this.left(), this.functionName(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isStringAndExact(this.right(), this.functionName(), Expressions.ParamOrdinal.SECOND);
    }

    @Override
    protected Pipe makePipe() {
        return new ConcatFunctionPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()));
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public boolean foldable() {
        return this.left().foldable() && this.right().foldable();
    }

    @Override
    public Object fold() {
        return ConcatFunctionProcessor.process(this.left().fold(), this.right().fold());
    }

    @Override
    protected Concat replaceChildren(Expression newLeft, Expression newRight) {
        return new Concat(this.source(), newLeft, newRight);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Concat::new, this.left(), this.right());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }
}

