/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncWaitStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class SegmentCountStep
extends AsyncWaitStep {
    public static final String NAME = "segment-count";
    private final int maxNumSegments;

    public SegmentCountStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int maxNumSegments) {
        super(key, nextStepKey, client);
        this.maxNumSegments = maxNumSegments;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public void evaluateCondition(IndexMetaData indexMetaData, AsyncWaitStep.Listener listener) {
        this.getClient().admin().indices().segments(new IndicesSegmentsRequest(new String[]{indexMetaData.getIndex().getName()}), ActionListener.wrap(response -> {
            long numberShardsLeftToMerge = StreamSupport.stream(((IndexSegments)response.getIndices().get(indexMetaData.getIndex().getName())).spliterator(), false).filter(iss -> Arrays.stream(iss.getShards()).anyMatch(p -> p.getSegments().size() > this.maxNumSegments)).count();
            listener.onResponse(numberShardsLeftToMerge == 0L, new Info(numberShardsLeftToMerge));
        }, listener::onFailure));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxNumSegments);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentCountStep other = (SegmentCountStep)obj;
        return super.equals(obj) && Objects.equals(this.maxNumSegments, other.maxNumSegments);
    }

    public static class Info
    implements ToXContentObject {
        private final long numberShardsLeftToMerge;
        static final ParseField SHARDS_TO_MERGE = new ParseField("shards_left_to_merge", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("segment_count_step_info", a -> new Info((Long)a[0]));

        public Info(long numberShardsLeftToMerge) {
            this.numberShardsLeftToMerge = numberShardsLeftToMerge;
        }

        public long getNumberShardsLeftToMerge() {
            return this.numberShardsLeftToMerge;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), "Waiting for [" + this.numberShardsLeftToMerge + "] shards to forcemerge");
            builder.field(SHARDS_TO_MERGE.getPreferredName(), this.numberShardsLeftToMerge);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.numberShardsLeftToMerge);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.numberShardsLeftToMerge, other.numberShardsLeftToMerge);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SHARDS_TO_MERGE);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

