/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.indexing.AsyncTwoPhaseIndexer;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.indexing.IterationResult;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.job.DateHistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.GroupConfig;
import org.elasticsearch.xpack.core.rollup.job.HistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;
import org.elasticsearch.xpack.core.rollup.job.RollupIndexerJobStats;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;
import org.elasticsearch.xpack.core.rollup.job.TermsGroupConfig;
import org.elasticsearch.xpack.rollup.job.IndexerUtils;
import org.joda.time.DateTimeZone;

public abstract class RollupIndexer
extends AsyncTwoPhaseIndexer<Map<String, Object>, RollupIndexerJobStats> {
    static final String AGGREGATION_NAME = "rollup";
    private final RollupJob job;
    protected final AtomicBoolean upgradedDocumentID;
    private final CompositeAggregationBuilder compositeBuilder;
    private long maxBoundary;

    RollupIndexer(Executor executor, RollupJob job, AtomicReference<IndexerState> initialState, Map<String, Object> initialPosition, AtomicBoolean upgradedDocumentID) {
        super(executor, initialState, initialPosition, (IndexerJobStats)new RollupIndexerJobStats());
        this.job = job;
        this.compositeBuilder = this.createCompositeBuilder(job.getConfig());
        this.upgradedDocumentID = upgradedDocumentID;
    }

    public boolean isUpgradedDocumentID() {
        return this.upgradedDocumentID.get();
    }

    protected String getJobId() {
        return this.job.getConfig().getId();
    }

    protected void onStartJob(long now) {
        DateHistogramGroupConfig dateHisto = this.job.getConfig().getGroupConfig().getDateHistogram();
        long delay = dateHisto.getDelay() != null ? TimeValue.parseTimeValue((String)dateHisto.getDelay().toString(), (String)"").millis() : 0L;
        this.maxBoundary = dateHisto.createRounding().round(now - delay);
    }

    protected SearchRequest buildSearchRequest() {
        Map position = (Map)this.getPosition();
        SearchSourceBuilder searchSource = new SearchSourceBuilder().size(0).trackTotalHits(false).query(this.createBoundaryQuery(position)).aggregation((AggregationBuilder)this.compositeBuilder.aggregateAfter(position));
        return new SearchRequest(new String[]{this.job.getConfig().getIndexPattern()}).source(searchSource);
    }

    protected IterationResult<Map<String, Object>> doProcess(SearchResponse searchResponse) {
        CompositeAggregation response = (CompositeAggregation)searchResponse.getAggregations().get(AGGREGATION_NAME);
        return new IterationResult(IndexerUtils.processBuckets(response, this.job.getConfig().getRollupIndex(), (RollupIndexerJobStats)this.getStats(), this.job.getConfig().getGroupConfig(), this.job.getConfig().getId(), this.upgradedDocumentID.get()), (Object)response.afterKey(), response.getBuckets().isEmpty());
    }

    private CompositeAggregationBuilder createCompositeBuilder(RollupJobConfig config) {
        GroupConfig groupConfig = config.getGroupConfig();
        List<CompositeValuesSourceBuilder<?>> builders = RollupIndexer.createValueSourceBuilders(groupConfig);
        CompositeAggregationBuilder composite = new CompositeAggregationBuilder(AGGREGATION_NAME, builders);
        List<AggregationBuilder> aggregations = RollupIndexer.createAggregationBuilders(config.getMetricsConfig());
        aggregations.forEach(arg_0 -> ((CompositeAggregationBuilder)composite).subAggregation(arg_0));
        Map<String, Object> metadata = RollupIndexer.createMetadata(groupConfig);
        if (!metadata.isEmpty()) {
            composite.setMetaData(metadata);
        }
        composite.size(config.getPageSize());
        return composite;
    }

    private QueryBuilder createBoundaryQuery(Map<String, Object> position) {
        assert (this.maxBoundary < Long.MAX_VALUE);
        DateHistogramGroupConfig dateHisto = this.job.getConfig().getGroupConfig().getDateHistogram();
        String fieldName = dateHisto.getField();
        String rollupFieldName = fieldName + "." + "date_histogram";
        long lowerBound = 0L;
        if (position != null) {
            Number value = (Number)position.get(rollupFieldName);
            lowerBound = value.longValue();
        }
        assert (lowerBound <= this.maxBoundary);
        RangeQueryBuilder query = new RangeQueryBuilder(fieldName).gte((Object)lowerBound).lt((Object)this.maxBoundary).format("epoch_millis");
        return query;
    }

    static Map<String, Object> createMetadata(GroupConfig groupConfig) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (groupConfig != null) {
            DateHistogramGroupConfig dateHistogram = groupConfig.getDateHistogram();
            metadata.put(RollupField.formatMetaField((String)"interval"), dateHistogram.getInterval().toString());
            HistogramGroupConfig histogram = groupConfig.getHistogram();
            if (histogram != null) {
                metadata.put(RollupField.formatMetaField((String)"interval"), histogram.getInterval());
            }
        }
        return metadata;
    }

    public static List<CompositeValuesSourceBuilder<?>> createValueSourceBuilders(GroupConfig groupConfig) {
        ArrayList builders = new ArrayList();
        if (groupConfig != null) {
            DateHistogramGroupConfig dateHistogram = groupConfig.getDateHistogram();
            builders.addAll(RollupIndexer.createValueSourceBuilders(dateHistogram));
            HistogramGroupConfig histogram = groupConfig.getHistogram();
            builders.addAll(RollupIndexer.createValueSourceBuilders(histogram));
            TermsGroupConfig terms = groupConfig.getTerms();
            builders.addAll(RollupIndexer.createValueSourceBuilders(terms));
        }
        return Collections.unmodifiableList(builders);
    }

    public static List<CompositeValuesSourceBuilder<?>> createValueSourceBuilders(DateHistogramGroupConfig dateHistogram) {
        String dateHistogramField = dateHistogram.getField();
        String dateHistogramName = RollupField.formatIndexerAggName((String)dateHistogramField, (String)"date_histogram");
        DateHistogramValuesSourceBuilder dateHistogramBuilder = new DateHistogramValuesSourceBuilder(dateHistogramName);
        dateHistogramBuilder.dateHistogramInterval(dateHistogram.getInterval());
        dateHistogramBuilder.field(dateHistogramField);
        dateHistogramBuilder.timeZone(RollupIndexer.toDateTimeZone(dateHistogram.getTimeZone()));
        return Collections.singletonList(dateHistogramBuilder);
    }

    public static List<CompositeValuesSourceBuilder<?>> createValueSourceBuilders(HistogramGroupConfig histogram) {
        ArrayList<HistogramValuesSourceBuilder> builders = new ArrayList<HistogramValuesSourceBuilder>();
        if (histogram != null) {
            for (String field : histogram.getFields()) {
                String histogramName = RollupField.formatIndexerAggName((String)field, (String)"histogram");
                HistogramValuesSourceBuilder histogramBuilder = new HistogramValuesSourceBuilder(histogramName);
                histogramBuilder.interval((double)histogram.getInterval());
                histogramBuilder.field(field);
                histogramBuilder.missingBucket(true);
                builders.add(histogramBuilder);
            }
        }
        return Collections.unmodifiableList(builders);
    }

    public static List<CompositeValuesSourceBuilder<?>> createValueSourceBuilders(TermsGroupConfig terms) {
        ArrayList<TermsValuesSourceBuilder> builders = new ArrayList<TermsValuesSourceBuilder>();
        if (terms != null) {
            for (String field : terms.getFields()) {
                String termsName = RollupField.formatIndexerAggName((String)field, (String)"terms");
                TermsValuesSourceBuilder termsBuilder = new TermsValuesSourceBuilder(termsName);
                termsBuilder.field(field);
                termsBuilder.missingBucket(true);
                builders.add(termsBuilder);
            }
        }
        return Collections.unmodifiableList(builders);
    }

    static List<AggregationBuilder> createAggregationBuilders(List<MetricConfig> metricsConfigs) {
        ArrayList<Object> builders = new ArrayList<Object>();
        if (metricsConfigs != null) {
            for (MetricConfig metricConfig : metricsConfigs) {
                List metrics = metricConfig.getMetrics();
                if (metrics.isEmpty()) continue;
                String field = metricConfig.getField();
                for (String metric : metrics) {
                    MinAggregationBuilder newBuilder;
                    if (metric.equals(MetricConfig.MIN.getPreferredName())) {
                        newBuilder = new MinAggregationBuilder(RollupField.formatFieldName((String)field, (String)"min", (String)"value"));
                    } else if (metric.equals(MetricConfig.MAX.getPreferredName())) {
                        newBuilder = new MaxAggregationBuilder(RollupField.formatFieldName((String)field, (String)"max", (String)"value"));
                    } else if (metric.equals(MetricConfig.AVG.getPreferredName())) {
                        newBuilder = new SumAggregationBuilder(RollupField.formatFieldName((String)field, (String)"avg", (String)"value"));
                        ValueCountAggregationBuilder countBuilder = new ValueCountAggregationBuilder(RollupField.formatFieldName((String)field, (String)"avg", (String)"_count"), ValueType.NUMERIC);
                        countBuilder.field(field);
                        builders.add(countBuilder);
                    } else if (metric.equals(MetricConfig.SUM.getPreferredName())) {
                        newBuilder = new SumAggregationBuilder(RollupField.formatFieldName((String)field, (String)"sum", (String)"value"));
                    } else if (metric.equals(MetricConfig.VALUE_COUNT.getPreferredName())) {
                        newBuilder = new ValueCountAggregationBuilder(RollupField.formatFieldName((String)field, (String)"value_count", (String)"value"), ValueType.NUMERIC);
                    } else {
                        throw new IllegalArgumentException("Unsupported metric type [" + metric + "]");
                    }
                    newBuilder.field(field);
                    builders.add(newBuilder);
                }
            }
        }
        return Collections.unmodifiableList(builders);
    }

    private static DateTimeZone toDateTimeZone(String timezone) {
        try {
            return DateTimeZone.forOffsetHours((int)Integer.parseInt(timezone));
        }
        catch (NumberFormatException e) {
            return DateTimeZone.forID((String)timezone);
        }
    }
}

