/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.ClasspathTextLayoutPeer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;

public final class TextLayout
implements Cloneable {
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();
    ClasspathTextLayoutPeer peer;

    protected final Object clone() {
        try {
            TextLayout textLayout = (TextLayout)super.clone();
            textLayout.peer = (ClasspathTextLayoutPeer)this.peer.clone();
            return textLayout;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final void draw(Graphics2D graphics2D, float f, float f2) {
        this.peer.draw(graphics2D, f, f2);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof TextLayout)) {
            return false;
        }
        return this.equals((TextLayout)object);
    }

    public final boolean equals(TextLayout textLayout) {
        return this.peer.equals(textLayout.peer);
    }

    public final float getAdvance() {
        return this.peer.getAdvance();
    }

    public final float getAscent() {
        return this.peer.getAscent();
    }

    public final byte getBaseline() {
        return this.peer.getBaseline();
    }

    public final float[] getBaselineOffsets() {
        return this.peer.getBaselineOffsets();
    }

    public final Shape getBlackBoxBounds(int n, int n2) {
        return this.peer.getBlackBoxBounds(n, n2);
    }

    public final Rectangle2D getBounds() {
        return this.peer.getBounds();
    }

    public final float[] getCaretInfo(TextHitInfo textHitInfo) {
        return this.getCaretInfo(textHitInfo, this.getBounds());
    }

    public final float[] getCaretInfo(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        return this.peer.getCaretInfo(textHitInfo, rectangle2D);
    }

    public final Shape getCaretShape(TextHitInfo textHitInfo) {
        return this.getCaretShape(textHitInfo, this.getBounds());
    }

    public final Shape getCaretShape(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        return this.peer.getCaretShape(textHitInfo, rectangle2D);
    }

    public final Shape[] getCaretShapes(int n) {
        return this.getCaretShapes(n, this.getBounds());
    }

    public final Shape[] getCaretShapes(int n, Rectangle2D rectangle2D) {
        return this.getCaretShapes(n, this.getBounds(), DEFAULT_CARET_POLICY);
    }

    public final Shape[] getCaretShapes(int n, Rectangle2D rectangle2D, CaretPolicy caretPolicy) {
        return this.peer.getCaretShapes(n, rectangle2D, caretPolicy);
    }

    public final int getCharacterCount() {
        return this.peer.getCharacterCount();
    }

    public final byte getCharacterLevel(int n) {
        return this.peer.getCharacterLevel(n);
    }

    public final float getDescent() {
        return this.peer.getDescent();
    }

    public final TextLayout getJustifiedLayout(float f) {
        return this.peer.getJustifiedLayout(f);
    }

    public final float getLeading() {
        return this.peer.getLeading();
    }

    public final Shape getLogicalHighlightShape(int n, int n2) {
        return this.getLogicalHighlightShape(n, n2, this.getBounds());
    }

    public final Shape getLogicalHighlightShape(int n, int n2, Rectangle2D rectangle2D) {
        return this.peer.getLogicalHighlightShape(n, n2, rectangle2D);
    }

    public final int[] getLogicalRangesForVisualSelection(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return this.peer.getLogicalRangesForVisualSelection(textHitInfo, textHitInfo2);
    }

    public final TextHitInfo getNextLeftHit(int n) {
        return this.getNextLeftHit(n, DEFAULT_CARET_POLICY);
    }

    public final TextHitInfo getNextLeftHit(int n, CaretPolicy caretPolicy) {
        return this.peer.getNextLeftHit(n, caretPolicy);
    }

    public final TextHitInfo getNextLeftHit(TextHitInfo textHitInfo) {
        return this.getNextLeftHit(textHitInfo.getCharIndex());
    }

    public final TextHitInfo getNextRightHit(int n) {
        return this.getNextRightHit(n, DEFAULT_CARET_POLICY);
    }

    public final TextHitInfo getNextRightHit(int n, CaretPolicy caretPolicy) {
        return this.peer.getNextRightHit(n, caretPolicy);
    }

    public final TextHitInfo getNextRightHit(TextHitInfo textHitInfo) {
        return this.getNextRightHit(textHitInfo.getCharIndex());
    }

    public final Shape getOutline(AffineTransform affineTransform) {
        return this.peer.getOutline(affineTransform);
    }

    public final float getVisibleAdvance() {
        return this.peer.getVisibleAdvance();
    }

    public final Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return this.getVisualHighlightShape(textHitInfo, textHitInfo2, this.getBounds());
    }

    public final Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, Rectangle2D rectangle2D) {
        return this.peer.getVisualHighlightShape(textHitInfo, textHitInfo2, rectangle2D);
    }

    public final TextHitInfo getVisualOtherHit(TextHitInfo textHitInfo) {
        return this.peer.getVisualOtherHit(textHitInfo);
    }

    protected final void handleJustify(float f) {
        this.peer.handleJustify(f);
    }

    public final int hashCode() {
        return this.peer.hashCode();
    }

    public final TextHitInfo hitTestChar(float f, float f2) {
        return this.hitTestChar(f, f2, this.getBounds());
    }

    public final TextHitInfo hitTestChar(float f, float f2, Rectangle2D rectangle2D) {
        return this.peer.hitTestChar(f, f2, rectangle2D);
    }

    public final boolean isLeftToRight() {
        return this.peer.isLeftToRight();
    }

    public final boolean isVertical() {
        return this.peer.isVertical();
    }

    public final String toString() {
        return this.peer.toString();
    }

    public TextLayout(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        AttributedString attributedString = new AttributedString(attributedCharacterIterator);
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = classpathToolkit.getClasspathTextLayoutPeer(attributedString, fontRenderContext);
    }

    public TextLayout(String string, Font font, FontRenderContext fontRenderContext) {
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font);
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = classpathToolkit.getClasspathTextLayoutPeer(attributedString, fontRenderContext);
    }

    public TextLayout(String string, Map map, FontRenderContext fontRenderContext) {
        AttributedString attributedString = new AttributedString(string, map);
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        this.peer = classpathToolkit.getClasspathTextLayoutPeer(attributedString, fontRenderContext);
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, TextLayout textLayout) {
            return textLayout.peer.getStrongCaret(textHitInfo, textHitInfo2);
        }
    }
}

