/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.xbill.DNS.Name;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.base16;
import org.xbill.DNS.utils.base64;

public class Tokenizer {
    private static String delim = " \t\n;()\"";
    private static String quotes = "\"";
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int WHITESPACE = 2;
    public static final int IDENTIFIER = 3;
    public static final int QUOTED_STRING = 4;
    public static final int COMMENT = 5;
    private PushbackInputStream is;
    private boolean ungottenToken;
    private int multiline;
    private boolean quoting;
    private String delimiters;
    private Token current;
    private StringBuffer sb;
    private boolean wantClose;
    private String filename;
    private int line;

    private final int getChar() throws IOException {
        int n = this.is.read();
        if (n == 13) {
            int n2 = this.is.read();
            if (n2 != 10) {
                this.is.unread(n2);
            }
            n = 10;
        }
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    private final void ungetChar(int n) throws IOException {
        if (n == -1) {
            return;
        }
        this.is.unread(n);
        if (n == 10) {
            --this.line;
        }
    }

    private final int skipWhitespace() throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.getChar()) != 32 && n2 != 9 && (n2 != 10 || this.multiline <= 0)) {
                this.ungetChar(n2);
                return n;
            }
            ++n;
        }
    }

    private final void checkUnbalancedParens() throws TextParseException {
        if (this.multiline > 0) {
            throw this.exception("unbalanced parentheses");
        }
    }

    public Token get(boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        if (this.ungottenToken) {
            this.ungottenToken = false;
            if (this.current.type == 2) {
                if (bl) {
                    return this.current;
                }
            } else if (this.current.type == 5) {
                if (bl2) {
                    return this.current;
                }
            } else {
                if (this.current.type == 1) {
                    ++this.line;
                }
                return this.current;
            }
        }
        if ((n2 = this.skipWhitespace()) > 0 && bl) {
            return this.current.set(2, null);
        }
        int n3 = 3;
        this.sb.setLength(0);
        while (true) {
            if ((n = this.getChar()) == -1 || this.delimiters.indexOf(n) != -1) {
                if (n == -1) {
                    if (this.quoting) {
                        throw this.exception("EOF in quoted string");
                    }
                    if (this.sb.length() == 0) {
                        return this.current.set(0, null);
                    }
                    return this.current.set(n3, this.sb);
                }
                if (this.sb.length() == 0 && n3 != 4) {
                    if (n == 40) {
                        ++this.multiline;
                        this.skipWhitespace();
                        continue;
                    }
                    if (n == 41) {
                        if (this.multiline <= 0) {
                            throw this.exception("invalid close parenthesis");
                        }
                        --this.multiline;
                        this.skipWhitespace();
                        continue;
                    }
                    if (n == 34) {
                        if (!this.quoting) {
                            this.quoting = true;
                            this.delimiters = quotes;
                            n3 = 4;
                            continue;
                        }
                        this.quoting = false;
                        this.delimiters = delim;
                        this.skipWhitespace();
                        continue;
                    }
                    if (n == 10) {
                        return this.current.set(1, null);
                    }
                    if (n == 59) {
                        while ((n = this.getChar()) != 10 && n != -1) {
                            this.sb.append((char)n);
                        }
                        if (bl2) {
                            this.ungetChar(n);
                            return this.current.set(5, this.sb);
                        }
                        if (n == -1 && n3 != 4) {
                            this.checkUnbalancedParens();
                            return this.current.set(0, null);
                        }
                        if (this.multiline > 0) {
                            this.skipWhitespace();
                            this.sb.setLength(0);
                            continue;
                        }
                        return this.current.set(1, null);
                    }
                    throw new IllegalStateException();
                }
                break;
            }
            if (n == 92) {
                n = this.getChar();
                if (n == -1) {
                    throw this.exception("unterminated escape sequence");
                }
                this.sb.append('\\');
            } else if (this.quoting && n == 10) {
                throw this.exception("newline in quoted string");
            }
            this.sb.append((char)n);
        }
        this.ungetChar(n);
        if (this.sb.length() == 0 && n3 != 4) {
            this.checkUnbalancedParens();
            return this.current.set(0, null);
        }
        return this.current.set(n3, this.sb);
    }

    public Token get() throws IOException {
        return this.get(false, false);
    }

    public void unget() {
        if (this.ungottenToken) {
            throw new IllegalStateException("Cannot unget multiple tokens");
        }
        if (this.current.type == 1) {
            --this.line;
        }
        this.ungottenToken = true;
    }

    public String getString() throws IOException {
        Token token = this.get();
        if (!token.isString()) {
            throw this.exception("expected a string");
        }
        return token.value;
    }

    public String getIdentifier() throws IOException {
        Token token = this.get();
        if (token.type != 3) {
            throw this.exception("expected an identifier");
        }
        return token.value;
    }

    public long getLong() throws IOException {
        String string = this.getIdentifier();
        if (!Character.isDigit(string.charAt(0))) {
            throw this.exception("expecting an integer");
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception("expecting an integer");
        }
    }

    public long getUInt32() throws IOException {
        long l = this.getLong();
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw this.exception("expecting an 32 bit unsigned integer");
        }
        return l;
    }

    public int getUInt16() throws IOException {
        long l = this.getLong();
        if (l < 0L || l > 65535L) {
            throw this.exception("expecting an 16 bit unsigned integer");
        }
        return (int)l;
    }

    public int getUInt8() throws IOException {
        long l = this.getLong();
        if (l < 0L || l > 255L) {
            throw this.exception("expecting an 8 bit unsigned integer");
        }
        return (int)l;
    }

    public long getTTL() throws IOException {
        String string = this.getIdentifier();
        try {
            return TTL.parseTTL(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception("expecting a valid TTL value");
        }
    }

    public long getTTLLike() throws IOException {
        String string = this.getIdentifier();
        try {
            return TTL.parse(string, false);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception("expecting a valid TTL-like value");
        }
    }

    public Name getName(Name name) throws IOException {
        try {
            Name name2 = Name.fromString(this.getIdentifier(), name);
            if (!name2.isAbsolute()) {
                throw new RelativeNameException(name2);
            }
            return name2;
        }
        catch (TextParseException textParseException) {
            throw this.exception(textParseException.getMessage());
        }
    }

    public void getEOL() throws IOException {
        Token token = this.get();
        if (token.type != 1 && token.type != 0) {
            throw this.exception("expecting EOL or EOF");
        }
    }

    private final String remainingStrings() throws IOException {
        Token token;
        StringBuffer stringBuffer = null;
        while ((token = this.get()).isString()) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(token.value);
        }
        this.unget();
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public byte[] getBase64(boolean bl) throws IOException {
        String string = this.remainingStrings();
        if (string == null) {
            if (bl) {
                throw this.exception("expected base64 encoded string");
            }
            return null;
        }
        byte[] byArray = base64.fromString(string);
        if (byArray == null) {
            throw this.exception("invalid base64 encoding");
        }
        return byArray;
    }

    public byte[] getBase64() throws IOException {
        return this.getBase64(false);
    }

    public byte[] getHex(boolean bl) throws IOException {
        String string = this.remainingStrings();
        if (string == null) {
            if (bl) {
                throw this.exception("expected hex encoded string");
            }
            return null;
        }
        byte[] byArray = base16.fromString(string);
        if (byArray == null) {
            throw this.exception("invalid hex encoding");
        }
        return byArray;
    }

    public byte[] getHex() throws IOException {
        return this.getHex(false);
    }

    public TextParseException exception(String string) {
        return new TokenizerException(this.filename, this.line, string);
    }

    public void close() {
        if (this.wantClose) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void finalize() {
        this.close();
    }

    public Tokenizer(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.is = new PushbackInputStream(inputStream, 2);
        this.ungottenToken = false;
        this.multiline = 0;
        this.quoting = false;
        this.delimiters = delim;
        this.current = new Token();
        this.sb = new StringBuffer();
        this.filename = "<none>";
        this.line = 1;
    }

    public Tokenizer(String string) {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public Tokenizer(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
        this.wantClose = true;
        this.filename = file.getName();
    }

    public static class Token {
        public int type = -1;
        public String value = null;

        private final Token set(int n, StringBuffer stringBuffer) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.type = n;
            this.value = stringBuffer == null ? null : stringBuffer.toString();
            return this;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "<eof>";
                }
                case 1: {
                    return "<eol>";
                }
                case 2: {
                    return "<whitespace>";
                }
                case 3: {
                    return "<identifier: " + this.value + '>';
                }
                case 4: {
                    return "<quoted_string: " + this.value + '>';
                }
                case 5: {
                    return "<comment: " + this.value + '>';
                }
            }
            return "<unknown>";
        }

        public boolean isString() {
            boolean bl = false;
            if (this.type == 3 || this.type == 4) {
                bl = true;
            }
            return bl;
        }

        public boolean isEOL() {
            boolean bl = false;
            if (this.type == 1 || this.type == 0) {
                bl = true;
            }
            return bl;
        }

        private Token() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TokenizerException
    extends TextParseException {
        String message;

        public String getBaseMessage() {
            return this.message;
        }

        public TokenizerException(String string, int n, String string2) {
            super(string + ':' + n + ": " + string2);
            this.message = string2;
        }
    }
}

