/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Queues;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PermutationsCollector
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final Pattern IS_FUNCTION = Pattern.compile("^is\\([\"']([^\"']*)[\"'](?:,[\"']([^\"']*)[\"'])?\\)$");
    private static final String USER_AGENT_PERMUTATION = "user.agent";
    private final MutatingVisitController delegate;
    private final ErrorManager errorManager;
    private Deque<CssBooleanExpressionNode> childrenStack;
    private Set<String> permutationAxesSet;

    public PermutationsCollector(MutatingVisitController delegate, ErrorManager errorManager) {
        this.delegate = delegate;
        this.errorManager = errorManager;
    }

    public boolean enterConditionalRule(CssConditionalRuleNode node) {
        for (CssValueNode children : node.getChildren()) {
            if (!(children instanceof CssBooleanExpressionNode)) continue;
            this.childrenStack.addFirst((CssBooleanExpressionNode)children);
        }
        while (!this.childrenStack.isEmpty()) {
            CssBooleanExpressionNode visitingNode = this.childrenStack.pop();
            this.visitBooleanExpression(visitingNode);
            if (visitingNode.getLeft() != null) {
                this.childrenStack.addFirst(visitingNode.getLeft());
            }
            if (visitingNode.getRight() == null) continue;
            this.childrenStack.addFirst(visitingNode.getRight());
        }
        return true;
    }

    public List<String> getPermutationAxes() {
        return ImmutableList.copyOf(this.permutationAxesSet);
    }

    private void visitBooleanExpression(CssBooleanExpressionNode booleanExpressionNode) {
        if (booleanExpressionNode.getType() == CssBooleanExpressionNode.Type.CONSTANT && booleanExpressionNode.getValue() != null) {
            Matcher m = IS_FUNCTION.matcher(booleanExpressionNode.getValue());
            if (m.matches()) {
                String permutationName = m.group(1);
                String permutationValue = m.group(2);
                if (permutationValue == null) {
                    permutationValue = permutationName;
                    permutationName = USER_AGENT_PERMUTATION;
                }
                booleanExpressionNode.setValue(permutationName + ":" + permutationValue);
                if (!this.permutationAxesSet.contains(permutationName)) {
                    this.permutationAxesSet.add(permutationName);
                }
            } else {
                GssError error = new GssError("The expression [" + booleanExpressionNode.getValue() + "] is not valid condition.", booleanExpressionNode.getSourceCodeLocation());
                this.errorManager.report(error);
            }
        }
    }

    public void runPass() {
        this.childrenStack = Queues.newArrayDeque();
        this.permutationAxesSet = new HashSet<String>();
        this.delegate.startVisit((CssTreeVisitor)this);
    }
}

