/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class SimpleDemo
extends JFrame
implements DockingConstants {
    public static void main(String[] args) {
        SimpleDemo f = new SimpleDemo();
        f.setSize(600, 400);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
    }

    public SimpleDemo() {
        super("Simple Docking Demo");
        this.setContentPane(this.createContentPane());
    }

    private JPanel createContentPane() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)this.buildDockingPort(Color.blue, "Blue"), "North");
        p.add((Component)this.buildDockingPort(Color.red, "Red"), "South");
        p.add((Component)this.buildDockingPort(Color.green, "Green"), "East");
        p.add((Component)this.buildDockingPort(Color.yellow, "Yellow"), "West");
        p.add((Component)this.createDockingPort(), "Center");
        return p;
    }

    private DefaultDockingPort buildDockingPort(Color color, String desc) {
        DefaultDockingPort port = this.createDockingPort();
        JPanel p = new JPanel();
        p.setBackground(color);
        p.add(new JLabel("Drag Me"));
        DockingManager.registerDockable(p, desc);
        port.dock(p, "CENTER");
        return port;
    }

    private DefaultDockingPort createDockingPort() {
        DefaultDockingPort port = new DefaultDockingPort();
        port.setBackground(Color.ORANGE);
        port.setPreferredSize(new Dimension(100, 100));
        return port;
    }
}

