/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.speex.StreamPlayer;
import org.igoweb.util.speex.StreamRecorder;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;

public class AudioWidget
extends JPanel
implements EventListener,
ActionListener,
PropertyChangeListener {
    public static int FRAMES_PER_PACKET = 15;
    public static int MAX_FRAMES_PER_PACKET = 63;
    public static final String SOUND_ENABLED_PREF = "?x,`>/$bI_";
    private static final int REC_OFF_MUTE_TIME = 60000;
    public static final int BUFFERING_DROP_LIMIT = 600;
    private static final int MODE_NONE = 0;
    private static final int MODE_PLAY = 1;
    private static final int MODE_RECORD = 2;
    private static final String RECORD_CARD = "a";
    private static final String NO_AUDIO_CARD = "b";
    private static final String PLAYING_CARD = "c";
    private final Client client;
    private CGame cGame;
    private Timer muteTimer;
    private StreamRecorder recorder;
    private boolean gotAudioPlayerWarning;
    private StreamPlayer audioPlayer;
    private PipedOutputStream playerOut;
    private final CardLayout modeCards = new CardLayout();
    private final JCheckBox box = new JCheckBox();
    private VolumeReadout volumeReadout = new VolumeReadout();
    private boolean audioError;

    public static AudioWidget create(Client client, CGame cGame) {
        return AudioWidget.getAudioMode(client, cGame) == 0 ? null : new AudioWidget(client, cGame);
    }

    private AudioWidget(Client client, CGame cGame) {
        this.setLayout(this.modeCards);
        this.client = client;
        this.cGame = cGame;
        this.add(NO_AUDIO_CARD, new JLabel(Defs.getString(-903340500)));
        this.add(PLAYING_CARD, new JLabel(Defs.getString(-903340499)));
        JPanel recPanel = new JPanel(new BorderLayout());
        recPanel.add("Before", this.box);
        final CardLayout textVsMeterLayout = new CardLayout();
        final JPanel textVsMeter = new JPanel(textVsMeterLayout);
        textVsMeter.add(Boolean.FALSE.toString(), new JLabel(Defs.getString(-903340506)));
        textVsMeter.add(Boolean.TRUE.toString(), this.volumeReadout);
        recPanel.add(textVsMeter);
        this.add(RECORD_CARD, recPanel);
        this.box.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                textVsMeterLayout.show(textVsMeter, Boolean.valueOf(AudioWidget.this.box.isSelected()).toString());
            }
        });
        this.box.addActionListener(this);
        cGame.addListener(this);
        client.addListener(this);
        Prefs.addListener(SOUND_ENABLED_PREF, this);
        this.doCards();
        this.testPlayerState();
    }

    public void setCGame(CGame newGame) {
        this.cGame.removeListener(this);
        this.cGame = newGame;
        this.cGame.addListener(this);
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 47: {
                this.testPlayerState();
                break;
            }
            case 16: 
            case 87: {
                if (this.recorder != null) {
                    this.recorder.stop(0);
                    this.recorder = null;
                }
                this.closePlayer();
                this.client.removeListener(this);
                this.cGame.removeListener(this);
                Prefs.removeListener(SOUND_ENABLED_PREF, this);
                break;
            }
            case 24: {
                this.handleAudio((DataInputStream)event.arg);
            }
        }
    }

    private void handleAudio(DataInputStream in) {
        try {
            short streamId = in.readShort();
            if (this.audioPlayer == null) {
                if (streamId > MAX_FRAMES_PER_PACKET) {
                    if (!this.audioError) {
                        new MsgOut(Defs.getString(-903340547), Defs.getString(-903340491), 2, (Component)this.getTopLevelAncestor());
                        this.audioError = true;
                    }
                    return;
                }
                this.buildPlayer(streamId);
                if (this.audioPlayer == null) {
                    return;
                }
            }
            byte[] tmpBuf = new byte[in.available()];
            in.readFully(tmpBuf);
            this.playerOut.write(tmpBuf);
        }
        catch (IOException excep) {
            System.err.println("Got IO Error from audio system: " + excep);
            this.closePlayer();
        }
    }

    private void doCards() {
        int mode = AudioWidget.getAudioMode(this.client, this.cGame);
        User me = this.client.getMe();
        if (mode == 2 || mode == 0 && me.getAuthLevel() == 2 && this.cGame.gameType.isOwner(this.cGame.getRole())) {
            this.modeCards.show(this, RECORD_CARD);
        } else {
            this.modeCards.show(this, !this.cGame.isAudio() || this.audioPlayer != null && !this.audioPlayer.isOpen() ? NO_AUDIO_CARD : PLAYING_CARD);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.muteTimer) {
            this.muteTimer.stop();
            this.muteTimer = null;
            if (this.recorder != null) {
                this.recorder.stop(0);
                this.cGame.sendSetAudio(false);
                this.recorder = null;
            }
        } else if (src == this.box) {
            if (this.box.isSelected()) {
                if (!this.cGame.isAudio()) {
                    this.cGame.sendSetAudio(true);
                }
                if (this.recorder == null) {
                    this.recorder = new StreamRecorder(new GameAudioStream(this.cGame, (short)FRAMES_PER_PACKET), FRAMES_PER_PACKET);
                    this.recorder.addListener(new AudioListener());
                    this.recorder.start();
                    this.volumeReadout.createTimer();
                    this.doCards();
                } else {
                    this.recorder.setMuted(false);
                    this.volumeReadout.createTimer();
                    if (this.muteTimer != null) {
                        this.muteTimer.stop();
                        this.muteTimer = null;
                    }
                    this.doCards();
                }
            } else {
                if (this.cGame.isAudio()) {
                    this.cGame.sendSetAudio(false);
                }
                if (this.recorder != null) {
                    this.recorder.setMuted(true);
                    if (this.muteTimer == null) {
                        this.muteTimer = new Timer(60000, this);
                        this.muteTimer.setRepeats(false);
                        this.muteTimer.start();
                    }
                    this.doCards();
                }
            }
        }
    }

    private int getAudioMode() {
        return AudioWidget.getAudioMode(this.client, this.cGame);
    }

    private static int getAudioMode(Client client, CGame cGame) {
        if (!cGame.gameType.isEditable()) {
            return 0;
        }
        Role ownerRole = cGame.gameType.owner;
        if (ownerRole == null) {
            return 0;
        }
        User owner = cGame.getPlayer(ownerRole);
        if (owner.getAuthLevel() != 2) {
            return 0;
        }
        return owner == client.getMe() ? 2 : 1;
    }

    private void handleAudioEvent(Event event) {
        switch (event.type) {
            case 0: {
                if (this.audioError) break;
                this.audioError = true;
                new MsgOut(Defs.getString(-903340547), Defs.getString(-903340507), 2, (Component)this.getTopLevelAncestor());
                break;
            }
            case 2: {
                if (this.audioError) break;
                this.audioError = true;
                new MsgOut(Defs.getString(-903340547), Defs.getString(-903340502, event.arg), 2, (Component)this.getTopLevelAncestor());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                if (!this.audioError) {
                    this.audioError = true;
                    new MsgOut(Defs.getString(-903340547), Defs.getString(-903340505), 2, (Component)this.getTopLevelAncestor());
                }
                this.box.setSelected(false);
                this.recorder.stop(0);
                this.cGame.sendSetAudio(false);
                this.recorder = null;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                if (!this.audioError) {
                    this.audioError = true;
                    new MsgOut(Defs.getString(-903340547), Defs.getString(-903340504), 2, (Component)this.getTopLevelAncestor());
                }
                this.box.setSelected(false);
                this.recorder.stop(0);
                this.cGame.sendSetAudio(false);
                this.recorder = null;
                break;
            }
            case 7: {
                if (!this.audioError) {
                    this.audioError = true;
                    new MsgOut(Defs.getString(-903340547), Defs.getString(-903340501), 2, (Component)this.getTopLevelAncestor());
                }
                this.box.setSelected(false);
                this.recorder.stop(0);
                this.cGame.sendSetAudio(false);
                this.recorder = null;
            }
        }
        this.doCards();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.testPlayerState();
    }

    private void testPlayerState() {
        boolean playerOn = false;
        if (this.cGame.isAudio() && this.getAudioMode() == 1 && Prefs.getBoolean(SOUND_ENABLED_PREF, true)) {
            playerOn = true;
        }
        if (this.audioPlayer != null && !playerOn) {
            this.audioPlayer.stop();
            this.audioPlayer = null;
            this.playerOut = null;
        }
        this.doCards();
    }

    private void buildPlayer(int fpp) {
        if (this.audioPlayer != null || this.audioError) {
            return;
        }
        if (!Prefs.getBoolean(SOUND_ENABLED_PREF, true)) {
            if (!this.gotAudioPlayerWarning) {
                this.gotAudioPlayerWarning = true;
                new MsgOut(Defs.getString(-903340547), Defs.getString(-903340509), 2, (Component)this.getTopLevelAncestor());
            }
            return;
        }
        try {
            PipedInputStream in = new PipedInputStream();
            this.playerOut = new PipedOutputStream(in);
            this.audioPlayer = new StreamPlayer(in, fpp);
            this.audioPlayer.setDropLimit(600);
            this.audioPlayer.addListener(new AudioListener());
            this.audioPlayer.start();
        }
        catch (IOException excep) {
            throw new RuntimeException(excep);
        }
        this.doCards();
    }

    private void closePlayer() {
        if (this.audioPlayer != null) {
            this.audioPlayer.close();
            this.audioPlayer = null;
            try {
                this.playerOut.close();
            }
            catch (IOException excep) {
                throw new RuntimeException(excep);
            }
        }
    }

    public static class GameAudioStream
    extends OutputStream {
        private final CGame cGame;
        private final short audioType;

        public GameAudioStream(CGame cGame, short audioType) {
            this.cGame = cGame;
            this.audioType = audioType;
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int len) {
            this.cGame.sendAudio(this.audioType, bytes, offset, len);
        }

        @Override
        public void write(int b) {
            this.write(new byte[]{(byte)b}, 0, 1);
        }
    }

    private class VolumeReadout
    extends JComponent
    implements ActionListener {
        private static final int UPDATE_PERIOD = 75;
        private static final float GREEN_LIMIT = 15000.0f;
        private static final float YELLOW_LIMIT = 23169.8f;
        private Timer volumeTimer;
        private float volume;

        @Override
        public void actionPerformed(ActionEvent event) {
            float newVolume;
            if (AudioWidget.this.recorder == null) {
                this.volumeTimer.stop();
                this.volumeTimer = null;
                newVolume = 0.0f;
            } else {
                newVolume = AudioWidget.this.recorder.getRmsAmplitude(true);
            }
            if ((double)newVolume != -1.0 && newVolume != this.volume) {
                this.volume = newVolume;
                this.repaint(0L);
            }
        }

        @Override
        public void addNotify() {
            this.createTimer();
            super.addNotify();
        }

        public void createTimer() {
            if (AudioWidget.this.recorder != null && this.volumeTimer == null) {
                this.volumeTimer = new Timer(75, this);
                this.volumeTimer.setCoalesce(true);
                this.volumeTimer.start();
            }
        }

        @Override
        public void removeNotify() {
            if (this.volumeTimer != null) {
                this.volumeTimer.stop();
                this.volumeTimer = null;
            }
            super.removeNotify();
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.volume < 15000.0f ? Color.green : (this.volume < 23169.8f ? Color.yellow : Color.red));
            Insets insets = this.getInsets();
            int width = this.getWidth() - (insets.left + insets.right);
            int bound = (int)((float)width * (this.volume / 23169.8f) + 0.5f);
            if (bound > width) {
                bound = width;
            }
            int height = this.getHeight() - (insets.top + insets.bottom);
            g.fillRect(insets.left, insets.top, bound, height);
            g.setColor(Color.black);
            g.fillRect(insets.left + bound, insets.top, width - bound, height);
        }
    }

    private class AudioListener
    implements EventListener,
    Runnable {
        private Event event;

        public AudioListener() {
        }

        public AudioListener(Event event) {
            this.event = event;
        }

        @Override
        public void handleEvent(Event audioEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                AudioWidget.this.handleAudioEvent(audioEvent);
            } else {
                SwingUtilities.invokeLater(new AudioListener(audioEvent));
            }
        }

        @Override
        public void run() {
            AudioWidget.this.handleAudioEvent(this.event);
        }
    }
}

