/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object tombstone = new Object();
    static final Object emptyslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set entries;
    private transient int threshold;

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            IdentityHashMap copy = (IdentityHashMap)super.clone();
            copy.table = (Object[])this.table.clone();
            copy.entries = null;
            return e;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean containsKey(Object key) {
        boolean bl = false;
        if (key == this.table[this.hash(key)]) {
            bl = true;
        }
        return bl;
    }

    public boolean containsValue(Object value) {
        int i = this.table.length - 1;
        while (i > 0) {
            if (this.table[i] == value) {
                return true;
            }
            i -= 2;
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public final int size() {
                    return IdentityHashMap.this.size;
                }

                public final Iterator iterator() {
                    return new IdentityIterator(2);
                }

                public final void clear() {
                    IdentityHashMap.this.clear();
                }

                public final boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry m = (Map.Entry)o;
                    boolean bl = false;
                    if (m.getValue() == IdentityHashMap.this.table[IdentityHashMap.this.hash(m.getKey()) + 1]) {
                        bl = true;
                    }
                    return bl;
                }

                public final int hashCode() {
                    return IdentityHashMap.this.hashCode();
                }

                public final boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Object key = ((Map.Entry)o).getKey();
                    int h = IdentityHashMap.this.hash(key);
                    if (IdentityHashMap.this.table[h] == key) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[h] = tombstone;
                        IdentityHashMap.this.table[h + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public Object get(Object key) {
        int h = this.hash(key);
        return this.table[h] == key ? this.table[h + 1] : null;
    }

    public int hashCode() {
        int hash = 0;
        int i = this.table.length - 2;
        while (i >= 0) {
            Object key = this.table[i];
            if (key != emptyslot && key != tombstone) {
                hash += System.identityHashCode(key) ^ System.identityHashCode(this.table[i + 1]);
            }
            i -= 2;
        }
        return hash;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public final int size() {
                    return IdentityHashMap.this.size;
                }

                public final Iterator iterator() {
                    return new IdentityIterator(0);
                }

                public final void clear() {
                    IdentityHashMap.this.clear();
                }

                public final boolean contains(Object o) {
                    return IdentityHashMap.this.containsKey(o);
                }

                public final int hashCode() {
                    int hash = 0;
                    int i = IdentityHashMap.this.table.length - 2;
                    while (i >= 0) {
                        Object key = IdentityHashMap.this.table[i];
                        if (key != emptyslot && key != tombstone) {
                            hash += System.identityHashCode(key);
                        }
                        i -= 2;
                    }
                    return hash;
                }

                public final boolean remove(Object o) {
                    int h = IdentityHashMap.this.hash(o);
                    if (IdentityHashMap.this.table[h] == o) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[h] = tombstone;
                        IdentityHashMap.this.table[h + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    public Object put(Object key, Object value) {
        int h;
        if (this.size > this.threshold) {
            Object[] old = this.table;
            this.table = new Object[old.length * 2 + 2];
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            int i = old.length - 2;
            while (i >= 0) {
                Object oldkey = old[i];
                if (oldkey != tombstone && oldkey != emptyslot) {
                    this.put(oldkey, old[i + 1]);
                }
                i -= 2;
            }
        }
        if (this.table[h = this.hash(key)] == key) {
            Object r = this.table[h + 1];
            this.table[h + 1] = value;
            return r;
        }
        ++this.modCount;
        ++this.size;
        this.table[h] = key;
        this.table[h + 1] = value;
        return null;
    }

    public void putAll(Map m) {
        super.putAll(m);
    }

    public Object remove(Object key) {
        int h = this.hash(key);
        if (this.table[h] == key) {
            ++this.modCount;
            --this.size;
            Object r = this.table[h + 1];
            this.table[h] = tombstone;
            this.table[h + 1] = tombstone;
            return r;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public final int size() {
                    return IdentityHashMap.this.size;
                }

                public final Iterator iterator() {
                    return new IdentityIterator(1);
                }

                public final void clear() {
                    IdentityHashMap.this.clear();
                }

                public final boolean remove(Object o) {
                    int i = IdentityHashMap.this.table.length - 1;
                    while (i > 0) {
                        if (IdentityHashMap.this.table[i] == o) {
                            ++IdentityHashMap.this.modCount;
                            IdentityHashMap.this.table[i - 1] = tombstone;
                            IdentityHashMap.this.table[i] = tombstone;
                            --IdentityHashMap.this.size;
                            return true;
                        }
                        i -= 2;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    int hash(Object key) {
        int h = Math.abs(System.identityHashCode(key) % (this.table.length >> 1)) << 1;
        int del = -1;
        int save = h;
        do {
            if (this.table[h] == key) {
                return h;
            }
            if (this.table[h] == emptyslot) break;
            if (this.table[h] == tombstone && del < 0) {
                del = h;
            }
            if ((h -= 2) >= 0) continue;
            h = this.table.length - 2;
        } while (h != save);
        return del < 0 ? h : del;
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int num = s.readInt();
        this.table = new Object[Math.max(num << 1, 21) << 1];
        while (--num >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        int i = this.table.length - 2;
        while (i >= 0) {
            Object key = this.table[i];
            if (key != tombstone && key != emptyslot) {
                s.writeObject(key);
                s.writeObject(this.table[i + 1]);
            }
            i -= 2;
        }
    }

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        if (max < 2) {
            max = 2;
        }
        this.table = new Object[max << 1];
        Arrays.fill(this.table, emptyslot);
        this.threshold = (max >> 2) * 3;
    }

    public IdentityHashMap(Map m) {
        this(Math.max(m.size() << 1, 21));
        this.putAll(m);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class IdentityEntry
    implements Map.Entry {
        final int loc;
        final int knownMod;

        public final boolean equals(Object o) {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = false;
            if (IdentityHashMap.this.table[this.loc] == e.getKey() && IdentityHashMap.this.table[this.loc + 1] == e.getValue()) {
                bl = true;
            }
            return bl;
        }

        public final Object getKey() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return IdentityHashMap.this.table[this.loc];
        }

        public final Object getValue() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return IdentityHashMap.this.table[this.loc + 1];
        }

        public final int hashCode() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return System.identityHashCode(IdentityHashMap.this.table[this.loc]) ^ System.identityHashCode(IdentityHashMap.this.table[this.loc + 1]);
        }

        public final Object setValue(Object value) {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            Object r = IdentityHashMap.this.table[this.loc + 1];
            IdentityHashMap.this.table[this.loc + 1] = value;
            return r;
        }

        public final String toString() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return "" + IdentityHashMap.this.table[this.loc] + '=' + IdentityHashMap.this.table[this.loc + 1];
        }

        private final /* synthetic */ void this() {
            this.knownMod = IdentityHashMap.this.modCount;
        }

        IdentityEntry(int loc) {
            this.this();
            this.loc = loc;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IdentityIterator
    implements Iterator {
        final int type;
        int knownMod;
        int count;
        int loc;

        public boolean hasNext() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            Object key;
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((key = IdentityHashMap.this.table[this.loc]) == emptyslot || key == tombstone);
            return this.type == 0 ? key : (this.type == 1 ? IdentityHashMap.this.table[this.loc + 1] : new IdentityEntry(this.loc));
        }

        public void remove() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.loc == IdentityHashMap.this.table.length || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new IllegalStateException();
            }
            ++IdentityHashMap.this.modCount;
            --IdentityHashMap.this.size;
            IdentityHashMap.this.table[this.loc] = tombstone;
            IdentityHashMap.this.table[this.loc + 1] = tombstone;
            ++this.knownMod;
        }

        private final /* synthetic */ void this() {
            this.knownMod = IdentityHashMap.this.modCount;
            this.count = IdentityHashMap.this.size;
            this.loc = IdentityHashMap.this.table.length;
        }

        IdentityIterator(int type) {
            this.this();
            this.type = type;
        }
    }
}

