/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.Properties;
import java.util.Date;

public abstract class PrimitiveEntry
extends Entry {
    protected Date creationDate;

    public String getAlias() {
        return this.properties.get("alias");
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.clone();
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.getAlias().equals(((PrimitiveEntry)object).getAlias());
    }

    protected final void makeCreationDate() throws MalformedKeyringException {
        String string = this.properties.get("creation-date");
        if (string == null) {
            throw new MalformedKeyringException("no creation date");
        }
        try {
            this.creationDate = new Date(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedKeyringException("invalid creation date");
        }
    }

    protected PrimitiveEntry(int n, Date date, Properties properties) {
        super(n, properties);
        this.creationDate = date == null ? new Date() : (Date)date.clone();
        if (!this.properties.containsKey("alias") || this.properties.get("alias").length() == 0) {
            throw new IllegalArgumentException("primitive entries MUST have an alias");
        }
        this.properties.put("creation-date", String.valueOf(date.getTime()));
    }

    protected PrimitiveEntry(int n) {
        super(n);
    }
}

