/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RSAKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            BigInteger bigInteger = rSAPublicKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPublicKeySpec.getPublicExponent();
            return new GnuRSAPublicKey(2, bigInteger, bigInteger2);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            byte[] byArray = x509EncodedKeySpec.getEncoded();
            try {
                PublicKey publicKey = new RSAKeyPairX509Codec().decodePublicKey(byArray);
            }
            catch (RuntimeException runtimeException) {
                InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
                invalidKeySpecException.initCause(runtimeException);
                throw invalidKeySpecException;
            }
        }
        throw new InvalidKeySpecException("Unsupported (public) key specification");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            BigInteger bigInteger = rSAPrivateCrtKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPrivateCrtKeySpec.getPublicExponent();
            BigInteger bigInteger3 = rSAPrivateCrtKeySpec.getPrivateExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKeySpec.getPrimeP();
            BigInteger bigInteger5 = rSAPrivateCrtKeySpec.getPrimeQ();
            BigInteger bigInteger6 = rSAPrivateCrtKeySpec.getPrimeExponentP();
            BigInteger bigInteger7 = rSAPrivateCrtKeySpec.getPrimeExponentQ();
            BigInteger bigInteger8 = rSAPrivateCrtKeySpec.getCrtCoefficient();
            return new GnuRSAPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            byte[] byArray = pKCS8EncodedKeySpec.getEncoded();
            try {
                PrivateKey privateKey = new RSAKeyPairPKCS8Codec().decodePrivateKey(byArray);
            }
            catch (RuntimeException runtimeException) {
                InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
                invalidKeySpecException.initCause(runtimeException);
                throw invalidKeySpecException;
            }
        }
        throw new InvalidKeySpecException("Unsupported (private) key specification");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        Class clazz2;
        if (key instanceof RSAPublicKey) {
            Class clazz3 = class$java$security$spec$RSAPublicKeySpec;
            if (clazz3 == null) {
                clazz3 = class$java$security$spec$RSAPublicKeySpec = RSAKeyFactory.class("[Ljava.security.spec.RSAPublicKeySpec;", false);
            }
            if (clazz.isAssignableFrom(clazz3)) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                BigInteger bigInteger = rSAPublicKey.getModulus();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                return new RSAPublicKeySpec(bigInteger, bigInteger2);
            }
            Class clazz4 = class$java$security$spec$X509EncodedKeySpec;
            if (clazz4 == null) {
                clazz4 = class$java$security$spec$X509EncodedKeySpec = RSAKeyFactory.class("[Ljava.security.spec.X509EncodedKeySpec;", false);
            }
            if (clazz.isAssignableFrom(clazz4)) {
                if (key instanceof GnuRSAPublicKey) {
                    GnuRSAPublicKey gnuRSAPublicKey = (GnuRSAPublicKey)key;
                    byte[] byArray = gnuRSAPublicKey.getEncoded(2);
                    return new X509EncodedKeySpec(byArray);
                }
                if ("X.509".equalsIgnoreCase(key.getFormat())) {
                    byte[] byArray = key.getEncoded();
                    return new X509EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (public) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (public) key specification");
        }
        if (key instanceof RSAPrivateCrtKey) {
            Class clazz5 = class$java$security$spec$RSAPrivateCrtKeySpec;
            if (clazz5 == null) {
                clazz5 = class$java$security$spec$RSAPrivateCrtKeySpec = RSAKeyFactory.class("[Ljava.security.spec.RSAPrivateCrtKeySpec;", false);
            }
            if (clazz.isAssignableFrom(clazz5)) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                BigInteger bigInteger = rSAPrivateCrtKey.getModulus();
                BigInteger bigInteger3 = rSAPrivateCrtKey.getPublicExponent();
                BigInteger bigInteger4 = rSAPrivateCrtKey.getPrivateExponent();
                BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeP();
                BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeQ();
                BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentP();
                BigInteger bigInteger8 = rSAPrivateCrtKey.getPrimeExponentQ();
                BigInteger bigInteger9 = rSAPrivateCrtKey.getCrtCoefficient();
                return new RSAPrivateCrtKeySpec(bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
            }
        }
        if (key instanceof RSAPrivateKey) {
            Class clazz6 = class$java$security$spec$RSAPrivateKeySpec;
            if (clazz6 == null) {
                clazz6 = class$java$security$spec$RSAPrivateKeySpec = RSAKeyFactory.class("[Ljava.security.spec.RSAPrivateKeySpec;", false);
            }
            if (clazz.isAssignableFrom(clazz6)) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                BigInteger bigInteger = rSAPrivateKey.getModulus();
                BigInteger bigInteger10 = rSAPrivateKey.getPrivateExponent();
                return new RSAPrivateKeySpec(bigInteger, bigInteger10);
            }
        }
        if ((clazz2 = class$java$security$spec$PKCS8EncodedKeySpec) == null) {
            clazz2 = class$java$security$spec$PKCS8EncodedKeySpec = RSAKeyFactory.class("[Ljava.security.spec.PKCS8EncodedKeySpec;", false);
        }
        if (clazz.isAssignableFrom(clazz2)) {
            if (key instanceof GnuRSAPrivateKey) {
                GnuRSAPrivateKey gnuRSAPrivateKey = (GnuRSAPrivateKey)key;
                byte[] byArray = gnuRSAPrivateKey.getEncoded(3);
                return new PKCS8EncodedKeySpec(byArray);
            }
            if ("PKCS#8".equalsIgnoreCase(key.getFormat())) {
                byte[] byArray = key.getEncoded();
                return new PKCS8EncodedKeySpec(byArray);
            }
            throw new InvalidKeySpecException("Wrong key type or unsupported (private) key specification");
        }
        throw new InvalidKeySpecException("Wrong key type or unsupported key specification");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GnuRSAPublicKey || key instanceof GnuRSAPrivateKey) {
            return key;
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            BigInteger bigInteger = rSAPublicKey.getModulus();
            BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
            return new GnuRSAPublicKey(2, bigInteger, bigInteger2);
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            BigInteger bigInteger = rSAPrivateCrtKey.getModulus();
            BigInteger bigInteger3 = rSAPrivateCrtKey.getPublicExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKey.getPrivateExponent();
            BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeP();
            BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeQ();
            BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentP();
            BigInteger bigInteger8 = rSAPrivateCrtKey.getPrimeExponentQ();
            BigInteger bigInteger9 = rSAPrivateCrtKey.getCrtCoefficient();
            return new GnuRSAPrivateKey(3, bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
        }
        throw new InvalidKeyException("Unsupported key type");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

