/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.OggSpeexWriter;
import org.xiph.speex.RawWriter;
import org.xiph.speex.SpeexEncoder;

public class JSpeexEnc {
    public static final String VERSION = "Java Speex Command Line Encoder v0.9 ($Revision: 1.10 $)";
    public static final String COPYRIGHT = "Copyright (C) 2002-2004 Wimba S.A.";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    protected static int printlevel = 1;
    protected static boolean wav = true;
    protected static boolean ogg = true;
    protected static int mode = -1;
    protected static int quality = 8;
    protected static int complexity = 3;
    protected static int nframes = 1;
    protected static int bitrate = -1;
    protected static int sampleRate = -1;
    protected static int channels = 1;
    protected static float vbr_quality = -1.0f;
    protected static boolean vbr = false;
    protected static boolean vad = false;
    protected static boolean dtx = false;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            if (stringArray.length == 1 && (stringArray[0].equalsIgnoreCase("-v") || stringArray[0].equalsIgnoreCase("--version"))) {
                JSpeexEnc.version();
                return;
            }
            JSpeexEnc.usage();
            return;
        }
        String string = stringArray[stringArray.length - 2];
        String string2 = stringArray[stringArray.length - 1];
        wav = string.toLowerCase().endsWith(".wav");
        ogg = string2.toLowerCase().endsWith(".spx");
        for (int i = 0; i < stringArray.length - 2; ++i) {
            if (stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("--help")) {
                JSpeexEnc.usage();
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-v") || stringArray[i].equalsIgnoreCase("--version")) {
                JSpeexEnc.version();
                return;
            }
            if (stringArray[i].equalsIgnoreCase("--verbose")) {
                printlevel = 0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--quiet")) {
                printlevel = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-n") || stringArray[i].equalsIgnoreCase("-nb") || stringArray[i].equalsIgnoreCase("--narrowband")) {
                mode = 0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-w") || stringArray[i].equalsIgnoreCase("-wb") || stringArray[i].equalsIgnoreCase("--wideband")) {
                mode = 1;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-u") || stringArray[i].equalsIgnoreCase("-uwb") || stringArray[i].equalsIgnoreCase("--ultra-wideband")) {
                mode = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-q") || stringArray[i].equalsIgnoreCase("--quality")) {
                try {
                    vbr_quality = Float.parseFloat(stringArray[++i]);
                    quality = (int)vbr_quality;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexEnc.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--complexity")) {
                try {
                    complexity = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexEnc.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--nframes")) {
                try {
                    nframes = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexEnc.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--vbr")) {
                vbr = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--vad")) {
                vad = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--dtx")) {
                dtx = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--rate")) {
                try {
                    sampleRate = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexEnc.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--stereo")) {
                channels = 2;
                continue;
            }
            JSpeexEnc.usage();
            return;
        }
        JSpeexEnc.encode(string, string2);
    }

    public static void usage() {
        JSpeexEnc.version();
        System.out.println("");
        System.out.println("Usage: JSpeexEnc [options] input_file output_file");
        System.out.println("Where:");
        System.out.println("  input_file can be:");
        System.out.println("    filename.wav  a PCM wav file");
        System.out.println("    filename.*    a raw PCM file (any extension other than .wav)");
        System.out.println("  output_file can be:");
        System.out.println("    filename.spx  an Ogg Speex file");
        System.out.println("    filename.*    a raw Speex file");
        System.out.println("Options: -h, --help     This help");
        System.out.println("         -v, --version  Version information");
        System.out.println("         --verbose      Print detailed information");
        System.out.println("         --quiet        Print minimal information");
        System.out.println("         -n, -nb        Consider input as Narrowband (8kHz)");
        System.out.println("         -w, -wb        Consider input as Wideband (16kHz)");
        System.out.println("         -u, -uwb       Consider input as Ultra-Wideband (32kHz)");
        System.out.println("         --quality n    Encoding quality (0-10) default 8");
        System.out.println("         --complexity n Encoding complexity (0-10) default 3");
        System.out.println("         --nframes n    Number of frames per Ogg packet, default 1");
        System.out.println("         --vbr          Enable varible bit-rate (VBR)");
        System.out.println("         --vad          Enable voice activity detection (VAD)");
        System.out.println("         --dtx          Enable file based discontinuous transmission (DTX)");
        System.out.println("         if the input file is raw PCM (not a Wave file)");
        System.out.println("         --rate n       Sampling rate for raw input");
        System.out.println("         --stereo       Consider input as stereo");
        System.out.println("More information is available from: http://jspeex.sourceforge.net/");
        System.out.println("This code is a Java port of the Speex codec: http://www.speex.org/");
    }

    public static void version() {
        System.out.println(VERSION);
        System.out.println("using Java Speex Encoder v0.9 ($Revision: 1.8 $)");
        System.out.println(COPYRIGHT);
    }

    public static void encode(String string, String string2) throws IOException {
        Object object;
        byte[] byArray = new byte[2560];
        if (printlevel <= 1) {
            JSpeexEnc.version();
        }
        if (printlevel <= 0) {
            System.out.println("");
        }
        if (printlevel <= 0) {
            System.out.println("Input File: " + string);
        }
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        if (wav) {
            dataInputStream.readFully(byArray, 0, 12);
            if (!"RIFF".equals(new String(byArray, 0, 4)) && !"WAVE".equals(new String(byArray, 8, 4))) {
                System.err.println("Not a WAVE file");
                return;
            }
            dataInputStream.readFully(byArray, 0, 8);
            object = new String(byArray, 0, 4);
            int n = JSpeexEnc.readInt(byArray, 4);
            while (!((String)object).equals("data")) {
                dataInputStream.readFully(byArray, 0, n);
                if (((String)object).equals("fmt ")) {
                    if (JSpeexEnc.readShort(byArray, 0) != 1) {
                        System.err.println("Not a PCM file");
                        return;
                    }
                    channels = JSpeexEnc.readShort(byArray, 2);
                    sampleRate = JSpeexEnc.readInt(byArray, 4);
                    if (JSpeexEnc.readShort(byArray, 14) != 16) {
                        System.err.println("Not a 16 bit file " + JSpeexEnc.readShort(byArray, 18));
                        return;
                    }
                    if (printlevel <= 0) {
                        System.out.println("File Format: PCM wave");
                        System.out.println("Sample Rate: " + sampleRate);
                        System.out.println("Channels: " + channels);
                    }
                }
                dataInputStream.readFully(byArray, 0, 8);
                object = new String(byArray, 0, 4);
                n = JSpeexEnc.readInt(byArray, 4);
            }
            if (printlevel <= 0) {
                System.out.println("Data size: " + n);
            }
        } else {
            if (sampleRate < 0) {
                switch (mode) {
                    case 0: {
                        sampleRate = 8000;
                        break;
                    }
                    case 1: {
                        sampleRate = 16000;
                        break;
                    }
                    case 2: {
                        sampleRate = 32000;
                        break;
                    }
                    default: {
                        sampleRate = 8000;
                    }
                }
            }
            if (printlevel <= 0) {
                System.out.println("File format: Raw audio");
                System.out.println("Sample rate: " + sampleRate);
                System.out.println("Channels: " + channels);
                System.out.println("Data size: " + new File(string).length());
            }
        }
        if (mode < 0) {
            if (sampleRate < 100) {
                sampleRate *= 1000;
            }
            mode = sampleRate < 12000 ? 0 : (sampleRate < 24000 ? 1 : 2);
        }
        object = new SpeexEncoder();
        ((SpeexEncoder)object).init(mode, quality, sampleRate, channels);
        if (complexity > 0) {
            ((SpeexEncoder)object).getEncoder().setComplexity(complexity);
        }
        if (bitrate > 0) {
            ((SpeexEncoder)object).getEncoder().setBitRate(bitrate);
        }
        if (vbr) {
            ((SpeexEncoder)object).getEncoder().setVbr(vbr);
            if (vbr_quality > 0.0f) {
                ((SpeexEncoder)object).getEncoder().setVbrQuality(vbr_quality);
            }
        }
        if (vad) {
            ((SpeexEncoder)object).getEncoder().setVad(vad);
        }
        if (dtx) {
            ((SpeexEncoder)object).getEncoder().setDtx(dtx);
        }
        if (printlevel <= 0) {
            System.out.println("");
            System.out.println("Output File: " + string2);
            System.out.println("File format: Ogg Speex");
            System.out.println("Encoder mode: " + (mode == 0 ? "Narrowband" : (mode == 1 ? "Wideband" : "UltraWideband")));
            System.out.println("Quality: " + (vbr ? vbr_quality : (float)quality));
            System.out.println("Complexity: " + complexity);
            System.out.println("Frames per packet: " + nframes);
            System.out.println("Varible bitrate: " + vbr);
            System.out.println("Voice activity detection: " + vad);
            System.out.println("Discontinouous Transmission: " + dtx);
        }
        AudioFileWriter audioFileWriter = ogg ? new OggSpeexWriter(mode, sampleRate, channels, nframes, vbr) : new RawWriter();
        audioFileWriter.open(string2);
        audioFileWriter.writeHeader("Encoded with: Java Speex Command Line Encoder v0.9 ($Revision: 1.10 $)");
        int n = 2 * channels * ((SpeexEncoder)object).getFrameSize();
        try {
            while (true) {
                int n2;
                dataInputStream.readFully(byArray, 0, nframes * n);
                for (n2 = 0; n2 < nframes; ++n2) {
                    ((SpeexEncoder)object).processData(byArray, n2 * n, n);
                }
                n2 = ((SpeexEncoder)object).getProcessedData(byArray, 0);
                if (n2 <= 0) continue;
                audioFileWriter.writePacket(byArray, 0, n2);
            }
        }
        catch (EOFException eOFException) {
            audioFileWriter.close();
            return;
        }
    }

    protected static int readInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    protected static int readShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | byArray[n + 1] << 8;
    }
}

