module WebUnit ; end

def WebUnit.dispatch(args)
  f_type = args.shift
  case f_type
  when '-fr'
    ['AVAILABLE_FRAMEWORKS', %w(RubyUnit runit/testcase)]
  when '-ft'
    ['AVAILABLE_FRAMEWORKS', %w(Test::Unit test/unit/testcase)]
  when '-xr'
    ['AVAILABLE_XMLPARSERS', %w(REXML rexml/document)]
  when '-xn'
    ['AVAILABLE_XMLPARSERS', %w(NQXML nqxml/treeparser)]
  else
    args.unshift(f_type)
    nil
  end
end

def WebUnit.runtest(args)
  if args.size > 0
    while res = dispatch(args)
      next if WebUnit.const_defined?(res[0])
      WebUnit.const_set(res[0], [res[1]])
    end
    require 'webunit/ui/cui/testrunner'
    test_runner = WebUnit::UI::CUI::TestRunner.new
    args.each {|f| require f}
    test_runner.run
  else
    puts "#{File.basename($0)} [-fr|-ft|-xr|-xn] testfile1 [, testfile2, ...]"
    puts "\t-fr : use RubyUnit as Testing Framework"
    puts "\t-ft : use Test::Unit as Testing Framework(default)"
    puts "\t-xr : use REXML as XML parser(default)"
    puts "\t-xn : use NQXML as XML parser"
  end
end

if $0 == __FILE__
  WebUnit.runtest(ARGV)
end
