/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.jsp;

import java.util.HashMap;
import java.util.Locale;

public enum PaymentMethod {
    AUTHORIZE_NET(true),
    PAYPAL(true),
    TOURNAMENT(false),
    NONE(false);

    public final boolean isPayment;
    public final String sqlName = this.name().toLowerCase(Locale.US);
    private static HashMap<String, PaymentMethod> nameToPayment;

    private PaymentMethod(boolean isPayment) {
        this.isPayment = isPayment;
    }

    public static PaymentMethod get(String sqlName) {
        PaymentMethod result;
        if (nameToPayment == null) {
            PaymentMethod.initNameToPayment();
        }
        if ((result = nameToPayment.get(sqlName)) == null) {
            throw new IllegalArgumentException("Invalid payment sql name: " + sqlName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNameToPayment() {
        Class<PaymentMethod> clazz = PaymentMethod.class;
        synchronized (PaymentMethod.class) {
            if (nameToPayment == null) {
                HashMap<String, PaymentMethod> map = new HashMap<String, PaymentMethod>();
                for (PaymentMethod pm : PaymentMethod.values()) {
                    map.put(pm.sqlName, pm);
                }
                nameToPayment = map;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

