/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCGame;
import com.gokgs.client.swing.GameInfoWindow;
import com.gokgs.client.swing.KGameUpdater;
import com.gokgs.client.swing.KPlayerWidget;
import com.gokgs.client.swing.SetPlayersWindow;
import com.gokgs.client.swing.TagIcon;
import com.gokgs.shared.KGameType;
import com.gokgs.shared.KRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.igoweb.games.Clock;
import org.igoweb.go.Go;
import org.igoweb.go.Loc;
import org.igoweb.go.Rules;
import org.igoweb.go.sgf.FileIo;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.SgfEvent;
import org.igoweb.go.sgf.ShadowTree;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.Editor;
import org.igoweb.go.swing.GameLayout;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.go.swing.GameWindow;
import org.igoweb.go.swing.GobanController;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.NumberingWindow;
import org.igoweb.go.swing.PlayerWidget;
import org.igoweb.go.swing.VarLabelWindow;
import org.igoweb.go.swing.sgf.SgfGamePanel;
import org.igoweb.go.swing.sgf.gameInfo.DisplayWindow;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.AdWidget;
import org.igoweb.igoweb.client.swing.AudioWidget;
import org.igoweb.igoweb.client.swing.AutomatchStartWindow;
import org.igoweb.igoweb.client.swing.CommentViewer;
import org.igoweb.igoweb.client.swing.GameAccessList;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.ModerationPane;
import org.igoweb.igoweb.client.swing.RoomSubmenu;
import org.igoweb.igoweb.client.swing.UserList;
import org.igoweb.igoweb.shared.ChatMode;
import org.igoweb.igoweb.shared.GameAction;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SingletonWindow;
import org.igoweb.util.swing.SizeLimitDoc;

public class KGamePanel
extends GamePanel {
    public static final Object GAME_START_KEY = new Object();
    public static final Object UPLOAD_WARNING_KEY = new Object();
    private static final String resignMsg = Defs.getString(-903340655);
    private final Client client;
    private final JFrame mainWin;
    private JMenuItem add5MinMI;
    private JMenuItem add1MinMI;
    private JMenuItem giveControlMI;
    private JMenuItem allowChatMI;
    private JMenuItem setPlayersMI;
    JMenuItem numberMI;
    JMenuItem varLabelMI;
    private JLabel editorLabel;
    private CommentViewer comments;
    private JButton resignBut;
    private JButton undoBut;
    private JMenuItem saveAsMI;
    private JMenuItem viewOfflineMI;
    private JMenuItem reviewMI;
    private JMenuItem accessListMI;
    private RoomSubmenu cloneMenu;
    private final SingletonWindow confirmClose = new SingletonWindow();
    private final SingletonWindow undoRequest = new SingletonWindow();
    private final SingletonWindow resignConfWin = new SingletonWindow();
    private final KCGame cGame;
    private KCGame review;
    private UserList userList;
    private Editor editor = null;
    private GobanController editorBoardController;
    private JMenuItem takeControlMI;
    private JMenuItem defaultGiveMI;
    private JMenuItem resumePlayMI;
    private JCheckBoxMenuItem quietMI;
    private String defaultEditor;
    private User prevEditor;
    private User prevEditorLabel;
    private KGameUpdater updater;
    private static boolean hasShownDeadMsg = false;
    private JButton talkButton;
    private ShadowTree tree;
    private ArrayList<SgfEvent> eventsToSend;
    private static ArrayList<JButton> talkButtonList = new ArrayList();
    private MsgOut userLeftMsg;
    private int opponentUndoReqCount;
    private ATextField tagField;
    private JButton tagButton;
    private final EventListener cGameListener = this::handleCGameEvent;
    private final EventListener gameListener = event -> {
        switch (event.type) {
            case 2: 
            case 3: {
                this.syncUndoBut();
            }
        }
    };
    private JComponent rawCommentWidget;
    private boolean scoreHintShown;
    private GameAccessList gameAccessList;
    private final GobanController boardController = new GobanController(){

        @Override
        public int getCursor(Loc loc, int modifiers, boolean shifted) {
            if ((modifiers & 2) != 0) {
                return loc != Loc.PASS && KGamePanel.this.comments.getInput().isEnabled() ? 3 : 2;
            }
            GameAction action = KGamePanel.this.cGame.getAction();
            switch (action == null ? -1 : action.id) {
                case 0: {
                    if (shifted || KGamePanel.this.getGame().isLegal(loc) != 0) break;
                    return KGamePanel.this.getGame().getWhoseMove();
                }
                case 2: {
                    if (loc == Loc.PASS) {
                        return ((KGamePanel)KGamePanel.this).cGame.gameType.isScorable() ? 0 : 2;
                    }
                    if (KGamePanel.this.getGame().getColor(loc) == 2) break;
                    return Go.opponent(KGamePanel.this.getGame().getColor(loc));
                }
                case 1: {
                    if (KGamePanel.this.editorBoardController == null) break;
                    return KGamePanel.this.editorBoardController.getCursor(loc, modifiers, shifted);
                }
                default: {
                    return 2;
                }
            }
            return shifted && KGamePanel.this.isNodeChangeEnabled() ? 3 : 2;
        }

        @Override
        public boolean isCapsLockShift() {
            return false;
        }

        @Override
        public boolean useAntiSkid() {
            return (((KGamePanel)KGamePanel.this).cGame.gameType.isTournament() || Prefs.getBoolean("sF)R3377", false)) && !KGamePanel.this.getGame().isPlayOver();
        }

        @Override
        public void boardClicked(Loc loc, int modifiers, boolean shifted) {
            if (loc != Loc.PASS && (modifiers & 3) == 2) {
                KGamePanel.this.displayLocName(loc);
                return;
            }
            GameAction myAction = KGamePanel.this.cGame.getAction();
            if (myAction == null) {
                if (KGamePanel.this.isNodeChangeEnabled() && shifted) {
                    Node node = KGamePanel.this.tree.findNodeContainingMove(loc, KGamePanel.this.getGame().getColor(loc) == 2);
                    if (node == null) {
                        Defs.ringBell();
                    } else {
                        KGamePanel.this.changeActiveNode(node);
                    }
                }
                return;
            }
            if (myAction == GameAction.EDIT && KGamePanel.this.editorBoardController != null) {
                if (KGamePanel.this.eventsToSend == null) {
                    KGamePanel.this.eventsToSend = new ArrayList();
                }
                KGamePanel.this.editorBoardController.boardClicked(loc, modifiers, shifted);
                KGamePanel.this.cGame.sendSgfChange(KGamePanel.this.eventsToSend);
                KGamePanel.this.eventsToSend = null;
                if (KGamePanel.this.editor.getTool() == 2) {
                    KGamePanel.this.cGame.sendScores(KGamePanel.this.getGame().getScore(1), KGamePanel.this.getGame().getScore(0));
                }
                return;
            }
            if (loc != Loc.PASS && this.getCursor(loc, modifiers, shifted) == 2) {
                return;
            }
            if (myAction == GameAction.SCORE) {
                if (loc == Loc.PASS) {
                    KGamePanel.this.cGame.sendDone();
                } else if (shifted) {
                    KGamePanel.this.cGame.sendMarkDead(loc, false);
                } else if ((KGamePanel.this.getGobanWidget().getMark(loc) & 0x80) != 0 && !hasShownDeadMsg) {
                    hasShownDeadMsg = true;
                    new MsgOut(Defs.getString(-903340709), Defs.getString(-903340540), 1, (Component)KGamePanel.this);
                } else {
                    KGamePanel.this.cGame.sendMarkDead(loc, true);
                }
            } else if (myAction == GameAction.MOVE) {
                KGamePanel.this.cGame.sendMove(loc);
            }
        }
    };

    public KGamePanel(Client newClient, KCGame newCGame, final JFrame newMainWin) {
        this.cGame = newCGame;
        this.client = newClient;
        this.mainWin = newMainWin;
        if (Prefs.getBoolean(":14_`9Lf", true)) {
            this.talkButton = new JButton(new AbstractAction(Defs.getString(-903340783)){

                @Override
                public void actionPerformed(ActionEvent event) {
                    newMainWin.toFront();
                }
            });
            talkButtonList.add(this.talkButton);
        } else {
            this.talkButton = null;
        }
    }

    protected void init() {
        this.tree = new ShadowTree(this.cGame.getSgfTree());
        super.init(this.tree, new GameLayout(this));
        this.userList = new UserList(this.client, this.cGame.getMembers().values());
        this.comments = new CommentViewer(this.client, this.cGame);
        this.cGame.forwardChats(this.comments.getChannelListener(), 0);
        this.cGame.addListener(this.cGameListener);
        this.setGameInfoMenuItems();
        this.getGame().addListener(this.gameListener);
        this.updater.setCGame(this.cGame);
        this.updater.setIAmPlaying(this.cGame.getRole() != null);
        if (this.getGobanWidget().getController() == null) {
            this.getGobanWidget().setController(this.boardController);
        }
        this.giveControlMI = new JMenuItem(Defs.getString(-903340717));
        this.giveControlMI.setEnabled(false);
        this.allowChatMI = new JMenuItem(Defs.getString(-903340817));
        this.allowChatMI.setEnabled(false);
        this.setPlayersMI = new JMenuItem(Defs.getString(-809883781));
        this.setPlayersMI.addActionListener(this);
        this.syncEditBut();
        this.syncUndoBut();
        this.userList.addMenuItem(this.giveControlMI);
        this.giveControlMI.addActionListener(this);
        if (this.cGame.gameType.isOwner(this.cGame.getRole()) && this.cGame.gameType.isEditable()) {
            this.userList.addMenuItem(this.allowChatMI);
            this.allowChatMI.addActionListener(this);
        }
        if (!this.cGame.gameType.isEditable()) {
            String toolTip = Defs.getString(-903340781);
            AdWidget ad = new AdWidget(this.cGame, 0, 88, 31, this.getTitlePanel(), "Before");
            ad.setToolTipText(toolTip);
            ad = new AdWidget(this.cGame, 1, 88, 31, this.getTitlePanel(), "After");
            ad.setToolTipText(toolTip);
        }
        this.setNodeChangeEnabled(this.iAmEditor() || this.iAmObserver() && this.cGame.getUser(GameAction.EDIT) == null);
        this.getPlayerWidget(0).setSoundWarningEnabled(this.cGame.getRole() != null);
        this.getPlayerWidget(1).setSoundWarningEnabled(this.cGame.getRole() != null);
        this.doneLoadingSgf();
        this.handleGameStateChange();
    }

    @Override
    protected JComponent buildCommentWidget() {
        JPanel result = new JPanel(new BorderLayout());
        result.setOpaque(false);
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.resignBut) {
            if (this.resignConfWin != null) {
                this.resignConfWin.dispose();
            }
            String[] buttons = new String[]{Defs.getString(1436228510), resignMsg};
            this.resignConfWin.setWindow(new MsgOut(Defs.getString(-903340560), Defs.getString(-903340622), 3, (Component)this, buttons, (ActionListener)this));
        } else if (source == this.add1MinMI) {
            this.addTimePressed(60000);
        } else if (source == this.add5MinMI) {
            this.addTimePressed(300000);
        } else if (source == this.undoBut) {
            this.undoPressed();
        } else if (source == this.resignConfWin.getWindow()) {
            this.resignConfWin.dispose();
            if (event.getActionCommand().equals(resignMsg)) {
                this.resignPressed();
            }
        } else if (source == this.giveControlMI) {
            User u = this.userList.getMenuTarget();
            if (u != null) {
                this.cGame.sendSetRoles(u.name, Role.OWNER);
            }
        } else if (source == this.allowChatMI) {
            this.cGame.sendAllowChat(this.userList.getMenuTarget().name, true);
        } else if (source == this.setPlayersMI) {
            SetPlayersWindow spwin = new SetPlayersWindow(this.cGame, (JFrame)this.getTopLevelAncestor());
            spwin.setVisible(true);
        } else if (source == this.undoRequest.getWindow()) {
            this.undoRequest.dispose();
            if (event.getActionCommand().equals(Defs.getString(1436228518))) {
                this.cGame.sendGrantUndo();
            } else if (event.getActionCommand().equals(Defs.getString(-809883749))) {
                this.opponentUndoReqCount = -1;
            }
        } else if (source == this.saveAsMI) {
            GuiClientUtil.get(this.client).save(this, this.cGame.getGameSummary(), this.cGame.getSgfTree());
        } else if (source == this.accessListMI) {
            if (this.gameAccessList != null) {
                this.gameAccessList.dispose();
            }
            this.gameAccessList = new GameAccessList(this.client, this.cGame, this);
        } else if (source == this.viewOfflineMI) {
            new GameWindow(1096335315, null, new SgfGamePanel(new FileIo(new Tree(this.tree))));
        } else if (source == this.reviewMI) {
            this.cGame.sendReviewRequest();
        } else if (source == this.takeControlMI) {
            this.cGame.sendSetRoles(this.client.getMe().name, Role.OWNER);
        } else if (source == this.resumePlayMI) {
            this.cGame.sendSetRoles(new String[]{this.cGame.getGameSummary().getPlayer((Role)KRole.WHITE).name, this.cGame.getGameSummary().getPlayer((Role)KRole.BLACK).name}, new Role[]{KRole.WHITE, KRole.BLACK});
        } else if (source == this.quietMI) {
            this.cGame.sendSetChatMode(this.quietMI.isSelected() ? (this.client.getMe().getAuthLevel() == 2 ? ChatMode.MODERATED : ChatMode.QUIET) : ChatMode.NORMAL);
        } else if (source == this.defaultGiveMI) {
            this.cGame.sendSetRoles(this.defaultEditor, Role.OWNER);
        } else if (source == this.tagField || source == this.tagButton) {
            this.client.setTag(this.cGame.getGameSummary().id, this.tagField.getText());
            this.tagField.transferFocus();
        } else {
            super.actionPerformed(event);
        }
    }

    protected boolean iAmEditor() {
        GameAction action = this.cGame.getAction();
        return action == GameAction.EDIT || action == GameAction.EDIT_DELAY;
    }

    private void resignPressed() {
        this.cGame.sendResign();
    }

    @Override
    public void closePressed() {
        if (this.cGame.getRole() != null && !this.cGame.isOver() && !this.cGame.gameType.isEditable()) {
            this.confirmClose.setWindow(new MsgOut(Defs.getString(-903340547), Defs.getString(this.getGame().isPlayOver() && !this.cGame.isOver() ? -903340740 : -903340741), 2, (Component)this, new String[]{Defs.getString(-903340654), Defs.getString(-903340623), Defs.getString(-903340801)}, event -> {
                if (event.getActionCommand().equals(Defs.getString(-903340654))) {
                    if (this.cGame.isSaved() || !this.cGame.gameType.isOwner(this.cGame.getRole())) {
                        this.cGame.sendUnjoinRequest();
                    } else {
                        this.askSaveBeforeClosing();
                    }
                } else if (event.getActionCommand().equals(Defs.getString(-903340623))) {
                    this.cGame.sendResign();
                    this.cGame.sendUnjoinRequest();
                }
            }));
        } else if (this.cGame.gameType.isOwner(this.cGame.getRole()) && !this.cGame.isSaved() && !this.cGame.isUploaded()) {
            this.askSaveBeforeClosing();
        } else {
            this.cGame.sendUnjoinRequest();
        }
    }

    private void askSaveBeforeClosing() {
        this.confirmClose.setWindow(new MsgOut(Defs.getString(-903340533), Defs.getString(-903340534), 3, (Component)this, new String[]{Defs.getString(1436228521), Defs.getString(1436228522), Defs.getString(720104027)}, event -> {
            if (event.getActionCommand().equals(Defs.getString(1436228521))) {
                this.cGame.sendSaveRequest();
                this.cGame.sendUnjoinRequest();
            } else if (event.getActionCommand().equals(Defs.getString(1436228522))) {
                this.cGame.sendUnjoinRequest();
            }
        }));
    }

    public void addTimePressed(int ms) {
        this.cGame.sendAddTime(KRole.opponent(this.cGame.getRole()), ms);
    }

    public void undoPressed() {
        this.cGame.sendUndoRequest();
    }

    protected void newEditor() {
        if (this.editor != null) {
            return;
        }
        while (this.getTitlePanel().getComponentCount() > 1) {
            this.getTitlePanel().remove(1);
        }
        this.editor = new Editor(this){

            @Override
            protected GobanController buildBoardController(int tool) {
                KGamePanel.this.editorBoardController = super.buildBoardController(tool);
                return KGamePanel.this.boardController;
            }
        };
        this.editor.addListener(this::handleEditorEvent);
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        this.numberMI = NumberingWindow.createMenuItem(this);
        this.numberMI.setEnabled(this.iAmEditor());
        menuItems.add(this.numberMI);
        this.varLabelMI = VarLabelWindow.createMenuItem(this);
        this.varLabelMI.setEnabled(this.iAmEditor());
        menuItems.add(this.varLabelMI);
        menuItems.add(null);
        this.defaultEditor = this.cGame.getPlayer((Role)this.cGame.gameType.owner).name;
        if (this.cGame.gameType.isOwner(this.cGame.getRole())) {
            this.takeControlMI = new JMenuItem(Defs.getString(-903340587));
            this.takeControlMI.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            this.takeControlMI.addActionListener(this);
            menuItems.add(this.takeControlMI);
            User u = this.cGame.getPlayer(KRole.WHITE);
            if (u == this.client.getMe()) {
                u = this.cGame.getPlayer(KRole.BLACK);
            }
            if (u != null) {
                this.defaultEditor = u.name;
            }
        }
        if (this.defaultEditor == null) {
            this.defaultEditor = this.client.getMe().name;
        }
        this.defaultGiveMI = new JMenuItem(Defs.getString(-903340716, this.defaultEditor));
        if (this.cGame.gameType == KGameType.TEACHING && this.cGame.gameType.isOwner(this.cGame.getRole())) {
            this.resumePlayMI = new JMenuItem(Defs.getString(-903340619));
            this.resumePlayMI.addActionListener(this);
            menuItems.add(this.resumePlayMI);
        }
        this.defaultGiveMI.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.defaultGiveMI.addActionListener(this);
        this.defaultGiveMI.setEnabled(false);
        menuItems.add(this.defaultGiveMI);
        if (this.cGame.gameType.isOwner(this.cGame.getRole())) {
            menuItems.add(this.setPlayersMI);
            menuItems.add(null);
            this.quietMI = new JCheckBoxMenuItem(Defs.getString(-903340514), false);
            this.quietMI.addActionListener(this);
            this.quietMI.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            menuItems.add(this.quietMI);
        }
        this.editor.addToolMenu(menuItems.toArray(new JComponent[0]));
        this.editor.addMap();
        this.syncToolEnableFlags();
        this.giveControlMI.setEnabled(this.cGame.gameType.isOwner(this.cGame.getRole()));
        this.editor.setTool(0);
    }

    protected void syncToolEnableFlags() {
        boolean amEditor = this.iAmEditor();
        if (this.numberMI != null) {
            this.numberMI.setEnabled(amEditor);
            this.varLabelMI.setEnabled(amEditor);
        }
        if (this.resumePlayMI != null) {
            this.resumePlayMI.setEnabled(this.editor != null && (!this.getGame().isPlayOver() || !this.cGame.isOver()));
        }
        for (int i = 7; i >= 0; --i) {
            this.editor.getToolMenuItem(i).setEnabled(amEditor);
        }
        AFrame gameInfoWin = this.getGameInfoWindow();
        if (gameInfoWin != null && gameInfoWin instanceof DisplayWindow) {
            ((DisplayWindow)gameInfoWin).setEditable(this.iAmEditor());
        }
    }

    private void handleEditorEvent(Event event) {
        switch (event.type) {
            case 0: {
                if (this.editor.getTool() != 2) break;
                if (this.eventsToSend == null) {
                    this.eventsToSend = new ArrayList();
                    this.editor.changeLiveness(Loc.PASS, false);
                    this.cGame.sendSgfChange(this.eventsToSend);
                    this.eventsToSend = null;
                    break;
                }
                this.editor.changeLiveness(Loc.PASS, false);
            }
        }
    }

    @Override
    public void changeActiveNode(Node node) {
        if (this.cGame.getSgfTree() == null) {
            return;
        }
        if (node == this.tree.getActiveNode()) {
            return;
        }
        if (this.iAmObserver()) {
            if (node.id == this.cGame.getSgfTree().getActiveNode().id || node.countChildren() == 0) {
                this.tree.setSplit(false);
            } else {
                this.tree.setSplit(true);
                this.tree.setActiveNode(node);
            }
        } else if (this.iAmEditor()) {
            ArrayList<SgfEvent> newEvents = this.eventsToSend == null ? new ArrayList<SgfEvent>() : this.eventsToSend;
            newEvents.add(new SgfEvent(node.id, 7));
            if (this.eventsToSend == null) {
                this.cGame.sendSgfChange(newEvents);
            }
        }
    }

    @Override
    protected void addUpdater(GobanWidget gobanWidget, Tree newTree) {
        this.updater = new KGameUpdater(this.cGame, gobanWidget, newTree);
        this.updater.setClock(0, this.getPlayerWidget(0).getClock());
        this.updater.setClock(1, this.getPlayerWidget(1).getClock());
    }

    protected void handleCGameEvent(Event event) {
        switch (event.type) {
            case 63: {
                Role myRole = this.cGame.getRole();
                if (myRole != null && this.cGame.gameType.isMainRole(myRole)) break;
                new MsgOut(Defs.getString(-903340709), Defs.getString(-903340656), 1, (Component)this);
                break;
            }
            case 16: {
                this.emit(2);
                break;
            }
            case 20: {
                this.userLeft((User)event.arg);
                break;
            }
            case 19: {
                this.userArrived((User)event.arg);
                break;
            }
            case 61: {
                if (this.opponentUndoReqCount < 0) break;
                this.undoRequested((Role)event.arg, ++this.opponentUndoReqCount >= 3);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                GuiClientUtil.messageReceived(event, this);
                break;
            }
            case 97: {
                GuiClientUtil.messageReceived(Defs.getString(2031923640), 13, this);
                break;
            }
            case 98: {
                System.err.println("Can't create game???");
                break;
            }
            case 60: {
                this.allowChatMI.setEnabled(this.cGame.getChatMode() != ChatMode.NORMAL);
                if (this.quietMI != null) {
                    this.quietMI.setSelected(event.arg != ChatMode.NORMAL);
                }
                this.comments.append(Defs.getString(711957008 + this.cGame.getChatMode().ordinal()) + '\n', 2, this.comments.getCommentMoveNum());
                if (!this.cGame.gameType.isOwner(this.cGame.getRole())) break;
                ChatMode mode = (ChatMode)((Object)event.arg);
                if (mode == ChatMode.MODERATED) {
                    if (this.rawCommentWidget.getParent() != this.getCommentWidget()) break;
                    this.rawCommentWidget.setBorder(null);
                    this.getCommentWidget().removeAll();
                    this.getCommentWidget().add(ModerationPane.buildModerationTabs(this.client, this.rawCommentWidget, this.cGame));
                    break;
                }
                if (this.rawCommentWidget.getParent() == this.getCommentWidget()) break;
                this.getCommentWidget().removeAll();
                this.getCommentWidget().add(this.rawCommentWidget);
                this.rawCommentWidget.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                break;
            }
            case 27: {
                this.comments.append(Defs.getString(-903340609) + '\n', 2, this.comments.getCommentMoveNum());
                break;
            }
            case 40: {
                this.handleGameStateChange();
                break;
            }
            case 65: {
                this.showFinalScore(event.arg);
                break;
            }
            case 66: {
                new Errout(Defs.getString(-903340658, event.arg));
                break;
            }
            case 64: {
                new Errout(Defs.getString(-903340664, event.arg));
                break;
            }
            case 62: {
                this.review = (KCGame)event.arg;
                this.review.addListener(this.cGameListener);
                break;
            }
            case 15: {
                if (event.source != this.review) break;
                KGamePanel newGamePanel = new KGamePanel(this.client, this.review, this.mainWin);
                this.review.removeListener(this.cGameListener);
                newGamePanel.init();
                Container parent = this;
                while (!(parent instanceof GameWindow)) {
                    if (parent == null) {
                        return;
                    }
                    parent = parent.getParent();
                }
                ((GameWindow)parent).setGamePanel(this, newGamePanel);
                if (this.tagField == null) break;
                this.tagField.setText(this.client.getTag(this.review.getGameSummary().id));
                break;
            }
            case 28: {
                JFrame frame = (JFrame)this.getTopLevelAncestor();
                if (frame == null) break;
                frame.toFront();
                break;
            }
            case 68: {
                if (this.cGame.gameType.isTournament()) break;
                new AutomatchStartWindow((JFrame)this.getTopLevelAncestor(), (Integer)event.arg);
                break;
            }
            case 67: {
                if (!this.cGame.gameType.isTournament() || !this.cGame.gameType.isMainRole(this.cGame.getRole())) break;
                new MsgOut(Defs.getString(-903340709), Defs.getString(-903340701), 1, (Component)this);
                break;
            }
            case 39: {
                this.changeTitleText();
            }
        }
    }

    private void showFinalScore(Object scores) {
        String[] scoreMsgs = this.cGame.formatFinalScores(scores);
        if (scoreMsgs.length == 1) {
            new MsgOut(Defs.getString(-903340709), scoreMsgs[0], 1, (Component)this);
        } else {
            new MsgOut(Defs.getString(-903340709), new JLabel("<html>" + scoreMsgs[0] + "<br>&nbsp;&nbsp;" + scoreMsgs[1] + "<br>&nbsp;&nbsp;" + scoreMsgs[2] + "<br>" + scoreMsgs[3]), 1, (Component)this);
        }
    }

    @Override
    protected void showGameOptionsPopup() {
        boolean iAmPlayer;
        boolean bl = iAmPlayer = !this.cGame.gameType.isEditable() && this.cGame.getRole() != null && !this.cGame.isOver();
        if (this.scoreEstMI != null) {
            this.scoreEstMI.setEnabled(estimator.possible(this.getGame()) && !iAmPlayer);
            this.viewOfflineMI.setEnabled(!iAmPlayer);
        }
        this.reviewMI.setEnabled(this.cGame.isOver() && this.cGame.getRole() != null && !this.cGame.gameType.isEditable());
        this.saveAsMI.setEnabled(Defs.isApp());
        this.accessListMI.setEnabled(this.cGame.isPrivate() && this.client.getRoom(this.cGame) != null && !this.client.getRoom(this.cGame).isPrivate() && this.cGame.isOwner(this.client.getMe()));
        this.cloneMenu.setEnabled(!this.cGame.gameType.isMainRole(this.cGame.getRole()) && !this.cGame.isOver());
        boolean canAddTime = !this.cGame.gameType.isTournament() && this.cGame.getRole() != null && this.cGame.getRole().team != -1 && !this.cGame.isOver();
        this.add1MinMI.setEnabled(canAddTime);
        this.add5MinMI.setEnabled(canAddTime);
    }

    @Override
    protected PlayerWidget buildPlayerWidget(int color, String name, int rank) {
        Clock clock = this.cGame.getClock(KRole.forColor(color));
        if (clock == null) {
            clock = this.cGame.getRules().buildClock();
        }
        KPlayerWidget result = new KPlayerWidget(color, this.getGame(), clock, name, rank);
        result.setRankShown(this.cGame.gameType.isEditable());
        User u = this.cGame.getPlayer(KRole.forColor(color));
        if (color == 1 && u == null) {
            u = this.cGame.getPlayer(KRole.OWNER);
        }
        if (u != null && u.isAvatar() && (color != 0 || u != this.cGame.getPlayer(KRole.WHITE))) {
            result.setImage(u, GuiClientUtil.get(this.client));
        }
        return result;
    }

    public KCGame getCGame() {
        return this.cGame;
    }

    @Override
    protected void displayLocName(Loc loc) {
        ATextField input = this.comments.getInput();
        input.setText(input.getText() + loc.toCoords(this.getGame().size) + ' ');
    }

    @Override
    protected String helpUrl() {
        return "gameWin.html";
    }

    public boolean iAmObserver() {
        return !this.cGame.gameType.isEditable() && !this.cGame.gameType.isMainRole(this.cGame.getRole());
    }

    @Override
    protected AFrame buildGameInfoWindow() {
        DFrame result;
        if (this.cGame.gameType.isEditable()) {
            DisplayWindow dw = new DisplayWindow(this.getSgfTree(), this, this, false);
            dw.setEditable(this.iAmEditor());
            result = dw;
        } else {
            result = new GameInfoWindow(this.cGame, this.getGame().getRules(), this.tree, this);
        }
        return result;
    }

    @Override
    protected void buildControlButtonList(ArrayList<JComponent> list) {
        this.undoBut = new JButton(Defs.getString(-1337055794));
        this.undoBut.addActionListener(this);
        this.resignBut = new JButton(Defs.getString(-903340623));
        this.resignBut.addActionListener(this);
        AudioWidget audioWidget = AudioWidget.create(this.client, this.cGame);
        list.add(this.helpBut);
        list.add(this.gameInfoBut);
        list.add(this.getGobanWidget().passBut);
        list.add(this.undoBut);
        list.add(this.resignBut);
        list.add(this.closeBut);
        if (!this.client.getMe().isGuest()) {
            JPanel tagPanel = new JPanel(new BorderLayout());
            this.tagField = new ATextField("", 1, this);
            this.tagField.setDocument(new SizeLimitDoc(50));
            this.tagField.setText(this.client.getTag(this.cGame.getGameSummary().id));
            String tagTip = Defs.getString(-809883782);
            this.tagField.setToolTipText(tagTip);
            tagPanel.add("Center", this.tagField);
            this.tagButton = new JButton(new TagIcon());
            this.tagButton.addActionListener(this);
            this.tagButton.setToolTipText(tagTip);
            tagPanel.add("East", this.tagButton);
            list.add(tagPanel);
        }
        if (audioWidget != null) {
            list.add(audioWidget);
        }
        super.buildControlButtonList(list);
    }

    private void setGameInfoMenuItems() {
        boolean app = Defs.isApp();
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        result.add(this.rulesMI);
        if (app) {
            result.add(this.scoreEstMI);
        }
        result.add(null);
        this.reviewMI = new JMenuItem(Defs.getString(-903340757));
        this.reviewMI.addActionListener(this);
        result.add(this.reviewMI);
        this.saveAsMI = new JMenuItem(Defs.getString(-903340612));
        this.saveAsMI.addActionListener(this);
        result.add(this.saveAsMI);
        this.accessListMI = new JMenuItem(Defs.getString(-903340704));
        this.accessListMI.addActionListener(this);
        result.add(this.accessListMI);
        if (app) {
            this.viewOfflineMI = new JMenuItem(Defs.getString(-903340570));
            this.viewOfflineMI.addActionListener(this);
            result.add(this.viewOfflineMI);
        }
        this.cloneMenu = new RoomSubmenu(Defs.getString(-903340550), this.client, -5, event -> this.cloneGame((CRoom)event.source), 0, null);
        result.add(this.cloneMenu);
        result.add(null);
        this.add1MinMI = new JMenuItem(Defs.getString(-903340814));
        this.add1MinMI.addActionListener(this);
        result.add(this.add1MinMI);
        this.add5MinMI = new JMenuItem(Defs.getString(-903340813));
        this.add5MinMI.addActionListener(this);
        result.add(this.add5MinMI);
        this.setGameInfoMenuItems(result.toArray(new JMenuItem[0]));
    }

    @Override
    public void addProp(Node node, Prop prop) {
        ArrayList<SgfEvent> newEvents;
        ArrayList<SgfEvent> arrayList = newEvents = this.eventsToSend == null ? new ArrayList<SgfEvent>() : this.eventsToSend;
        if (prop.type == 14 || prop.type == 17) {
            if (node == null) {
                node = this.tree.getActiveNode();
            }
            if (prop.type == 14 || node == this.tree.root || node.countChildren() > 0 || node.findProp(14) != null) {
                newEvents.add(new SgfEvent(node == null ? -1 : node.id, 5, (Object)new int[]{-1, -1}));
                newEvents.add(new SgfEvent(-1, 7));
                node = null;
                this.cGame.getActions().clear();
            }
        }
        newEvents.add(new SgfEvent(node == null ? -1 : node.id, 0, (Object)prop));
        if (this.eventsToSend == null) {
            this.cGame.sendSgfChange(newEvents);
        }
    }

    @Override
    public void removeProp(Node node, Prop prop) {
        ArrayList<SgfEvent> newEvents = this.eventsToSend == null ? new ArrayList<SgfEvent>() : this.eventsToSend;
        newEvents.add(new SgfEvent(node == null ? -1 : node.id, 1, (Object)prop));
        if (this.eventsToSend == null) {
            this.cGame.sendSgfChange(newEvents);
        }
    }

    @Override
    public void addNode(Node parent, boolean makeActive) {
        ArrayList<SgfEvent> newEvents = this.eventsToSend == null ? new ArrayList<SgfEvent>() : this.eventsToSend;
        newEvents.add(new SgfEvent(parent == null ? -1 : parent.id, 5, (Object)new int[]{-1, -1}));
        if (makeActive) {
            newEvents.add(new SgfEvent(-1, 7));
        }
        if (this.eventsToSend == null) {
            this.cGame.sendSgfChange(newEvents);
        }
    }

    @Override
    public String getTitleText() {
        if (this.cGame == null || this.cGame.gameType != KGameType.DEMONSTRATION && this.cGame.gameType != KGameType.REVIEW && this.cGame.gameType != KGameType.RENGO && this.cGame.gameType != KGameType.RENGO_REVIEW) {
            return super.getTitleText();
        }
        return this.cGame.getGameTitle();
    }

    @Override
    public String getMoveText() {
        if (this.cGame != null && (this.getGame().isPlayOver() || this.cGame.isOver()) && this.cGame.getUser(GameAction.EDIT) == null) {
            if (this.cGame.isOver()) {
                return Defs.getString(-903340720, IBundle.get().formatScore(this.cGame.getScore()));
            }
            if (this.cGame.getRole() == null || this.cGame.getRole().team == -1) {
                return Defs.getString(-903340624);
            }
            if (this.cGame.isDoneSent(this.cGame.getRole().team)) {
                return Defs.getString(-903340549);
            }
            if (this.cGame.isDoneSent(Go.opponent(this.cGame.getRole().team))) {
                return Defs.getString(-903340645);
            }
            return Defs.getString(-903340624);
        }
        if (this.cGame != null && (this.cGame.gameType == KGameType.RENGO || this.cGame.gameType == KGameType.RENGO_REVIEW)) {
            User toMove;
            if (this.cGame.gameType == KGameType.RENGO) {
                toMove = this.cGame.getUser(GameAction.MOVE);
            } else {
                int moveNum = this.getGame().getMoveNum();
                Rules rules = this.getGame().getRules();
                if (rules.isFixedHandicap()) {
                    if (rules.getHandicap() > 0) {
                        ++moveNum;
                    }
                } else if (moveNum <= rules.getHandicap()) {
                    moveNum *= 2;
                } else if (rules.getHandicap() > 0) {
                    moveNum -= rules.getHandicap() - 1;
                    if ((moveNum &= 3) == 0 || moveNum == 2 && (rules.getHandicap() & 1) == 0) {
                        moveNum ^= 2;
                    }
                }
                KRole moveRole = null;
                switch (moveNum & 3) {
                    case 0: {
                        moveRole = KRole.BLACK;
                        break;
                    }
                    case 1: {
                        moveRole = KRole.WHITE;
                        break;
                    }
                    case 2: {
                        moveRole = KRole.BLACK_2;
                        break;
                    }
                    case 3: {
                        moveRole = KRole.WHITE_2;
                    }
                }
                toMove = this.cGame.getGameSummary().getPlayer(moveRole);
            }
            if (toMove != null) {
                return Defs.getString(-809883777, new Object[]{this.getGame().getMoveNum(), this.getGame().lastMoveDesc(), this.getGame().getWhoseMove(), toMove.name});
            }
        } else if (this.cGame == null || this.cGame.gameType == KGameType.RENGO_REVIEW) {
            // empty if block
        }
        return super.getMoveText();
    }

    @Override
    public boolean isMoveTextBlinking() {
        return this.cGame != null && this.getGame().isPlayOver() && !this.cGame.isOver() && this.cGame.getRole() != null && this.cGame.getRole().team >= 0 && this.cGame.isDoneSent(Go.opponent(this.cGame.getRole().team)) && !this.cGame.isDoneSent(this.cGame.getRole().team);
    }

    public void syncEditBut() {
        this.resignBut.setEnabled(!this.cGame.isOver() && this.cGame.gameType.isScorable() && this.cGame.getRole() != null && this.cGame.getUser(GameAction.EDIT) == null);
        this.syncUndoBut();
        if (this.cGame.gameType.isEditable()) {
            this.newEditor();
        }
    }

    protected void syncUndoBut() {
        boolean isEnabled;
        if (this.cGame.getAction() == GameAction.MOVE) {
            isEnabled = this.getGame().isPlayOver() || !this.cGame.gameType.isTournament() && this.getGame().hasMoved(this.getGame().getWhoseMove());
        } else {
            Role role = this.cGame.getRole();
            isEnabled = !(this.cGame.isOver() || this.cGame.getUser(GameAction.EDIT) != null || role != KRole.BLACK && role != KRole.BLACK_2 && role != KRole.WHITE && role != KRole.WHITE_2 || !this.getGame().hasMoved(role.team) || !this.getGame().isPlayOver() && this.cGame.gameType.isTournament());
        }
        this.undoBut.setEnabled(isEnabled);
    }

    @Override
    public void removeNotify() {
        talkButtonList.remove(this.talkButton);
        this.cGame.removeListener(this.cGameListener);
        this.getGame().removeListener(this.gameListener);
        super.removeNotify();
    }

    public void userLeft(User user) {
        Role color;
        this.userList.remove(user);
        if (this.defaultGiveMI != null && user.name.equals(this.defaultEditor)) {
            this.defaultGiveMI.setEnabled(this.isDefaultEditorEnabled());
        }
        if ((color = this.cGame.getRole(user.name)) != null && !this.cGame.gameType.isTournament() && this.cGame.gameType.isMainRole(color) && color.team != -1 && this.cGame.gameType.isMainRole(this.cGame.getRole()) && !this.client.getMe().equals(user) && !this.cGame.isOver()) {
            this.userLeftMsg = new MsgOut(Defs.getString(-903340547), Defs.getString(-903340652, user.name), 2, (Component)this);
        } else if (this.cGame.getRole(user) == Role.OWNER) {
            new MsgOut(Defs.getString(-903340709), Defs.getString(-903340620), 1, (Component)this);
        }
    }

    public void userArrived(User user) {
        if (this.defaultGiveMI != null && user.name.equals(this.defaultEditor)) {
            this.defaultGiveMI.setEnabled(this.isDefaultEditorEnabled());
        }
        this.userList.add(user);
    }

    public void doneLoadingSgf() {
        this.getGobanWidget().setEnabled(true);
        this.getGobanWidget().passBut.setText(this.cGame.getAction() == GameAction.SCORE ? Defs.getString(-903340760) : Defs.getString(-1337055796));
        Object src = this.client.objects.remove(GAME_START_KEY);
        if (src == null) {
            this.updater.setSoundEnabled(true);
        } else {
            ArrayList<SgfEvent> origTree = ((Tree)src).asEventList();
            Iterator<SgfEvent> iter = origTree.iterator();
            while (iter.hasNext()) {
                Prop prop;
                SgfEvent event = iter.next();
                if (event.type != 0 || !(prop = (Prop)event.arg).isRoot()) continue;
                iter.remove();
            }
            this.cGame.sendSgfChange(origTree);
            this.client.sendSync(() -> this.updater.setSoundEnabled(true));
        }
    }

    private void setEditor(User user) {
        this.setEditorLabel(user);
        if (this.prevEditor == user) {
            return;
        }
        this.prevEditor = user;
        boolean amEditor = this.iAmEditor();
        boolean amOwner = this.cGame.gameType.isOwner(this.cGame.getRole());
        if (this.editor != null) {
            this.syncToolEnableFlags();
            if (amEditor) {
                if (this.editor.getTool() == -1) {
                    this.editor.setTool(this.getGame().isPlayOver() ? 2 : 0);
                }
            } else if (this.editor.getTool() != -1 && this.cGame.getAction() != GameAction.EDIT_DELAY) {
                this.editor.setTool(-1);
                if (this.resumePlayMI != null) {
                    this.resumePlayMI.setSelected(true);
                }
            }
            this.syncToolEnableFlags();
        }
        if (user != null && !amEditor && amOwner) {
            this.defaultEditor = user.name;
            if (this.defaultGiveMI != null) {
                this.defaultGiveMI.setText(Defs.getString(-903340716, this.defaultEditor));
            }
        }
        if (this.defaultGiveMI != null && this.cGame.isJoined() && this.defaultEditor != null) {
            this.defaultGiveMI.setEnabled(this.isDefaultEditorEnabled());
        }
        if (this.editor == null || !amEditor) {
            this.getGobanWidget().setController(this.boardController);
            this.getGobanWidget().setEnabled(true);
        }
        this.setNodeChangeEnabled(amEditor || this.iAmObserver() && user == null);
    }

    private void undoRequested(Role requestor, boolean shutoffAllowed) {
        if (!this.undoRequest.raiseIfOpen()) {
            String[] buttons = new String[shutoffAllowed ? 3 : 2];
            buttons[0] = Defs.getString(1436228518);
            buttons[1] = Defs.getString(1436228522);
            if (shutoffAllowed) {
                buttons[2] = Defs.getString(-809883749);
            }
            this.undoRequest.setWindow(new MsgOut(Defs.getString(-903340561), Defs.getString(-903340578, this.cGame.getPlayer((Role)requestor).name), 3, (Component)this, buttons, (ActionListener)this));
            this.updater.setUndoWindow(this.undoRequest.getWindow());
        }
    }

    @Override
    protected void buildControlPanel(boolean wide) {
        super.buildControlPanel(wide);
        if (this.rawCommentWidget == null) {
            this.rawCommentWidget = new JPanel();
            this.rawCommentWidget.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.getCommentWidget().add(this.rawCommentWidget);
        }
        this.rawCommentWidget.removeAll();
        this.rawCommentWidget.setLayout(new GCLayout());
        if (wide) {
            this.rawCommentWidget.add("xGrow=t,yGrow=t" + (this.talkButton == null ? "" : ",xSpan=2"), this.comments);
        } else {
            this.rawCommentWidget.add("xGrow=t,yGrow=t", this.comments);
            this.rawCommentWidget.add("xGrow=f" + (this.talkButton == null ? ",ySpan=2" : ""), this.userList);
        }
        this.rawCommentWidget.add("x=0,xGrow=t,yGrow=f,xSpan=1,ySpan=1", this.comments.getInput());
        if (this.talkButton != null) {
            this.rawCommentWidget.add("xGrow=f", this.talkButton);
        }
    }

    @Override
    protected void buildButtonPanel(JPanel buttonPanel, ArrayList<JComponent> buttons, boolean wide) {
        super.buildButtonPanel(buttonPanel, buttons, false);
        if (wide) {
            buttonPanel.add("x=1,y=0,xGrow=f,ySpan=" + buttons.size(), this.userList);
        }
    }

    @Override
    protected boolean changeWhoseMove(int newWhoseMove) {
        if (this.getGame().isPlayOver()) {
            return false;
        }
        Prop toAdd = new Prop(26, newWhoseMove);
        Node active = this.tree.getActiveNode();
        if (active.findProp(26) == null && active.hasConflicts(toAdd)) {
            this.getGame().setWhoseMove(newWhoseMove);
        } else {
            this.addProp(new Prop(26, newWhoseMove));
        }
        return true;
    }

    @Override
    protected void changeScoreMarks(boolean addMarks) {
    }

    protected Client getClient() {
        return this.client;
    }

    private void handleGameStateChange() {
        this.getGobanWidget().passBut.setText(this.cGame.getAction() == GameAction.SCORE ? Defs.getString(-903340760) : Defs.getString(-1337055796));
        if (this.cGame.getAction() == GameAction.SCORE && !this.scoreHintShown) {
            this.scoreHintShown = true;
            new MsgOut(Defs.getString(-903340709), Defs.getString(-809883774), 1, (Component)this);
        }
        this.syncEditBut();
        this.getGobanWidget().enablePassBut();
        this.changeMoveText();
        this.changeTitleText();
        User editorUser = this.cGame.getUser(GameAction.EDIT);
        this.setEditor(editorUser);
        if (editorUser == null) {
            editorUser = this.cGame.getUser(GameAction.MOVE);
            this.setEditorLabel(this.cGame.gameType == KGameType.RENGO || editorUser == this.cGame.getPlayer(KRole.forColor(this.getGame().getWhoseMove())) ? null : editorUser);
        }
        if (this.userLeftMsg != null && this.cGame.isOver()) {
            this.userLeftMsg.dispose();
            this.userLeftMsg = null;
        }
    }

    private void cloneGame(CRoom room) {
        room.sendCloneGameRequest(this.cGame);
    }

    private boolean isDefaultEditorEnabled() {
        return this.cGame.getMembers().containsKey(this.defaultEditor) && !this.defaultEditor.equals(this.client.getMe().name) && (this.iAmEditor() || this.cGame.gameType.isOwner(this.cGame.getRole()));
    }

    private void setEditorLabel(User user) {
        if (this.prevEditorLabel == user) {
            return;
        }
        this.prevEditorLabel = user;
        if (user == null) {
            if (this.editorLabel != null) {
                this.getTitlePanel().remove(this.editorLabel);
                this.editorLabel = null;
            }
        } else {
            if (this.editorLabel == null) {
                this.editorLabel = new JLabel();
                this.getTitlePanel().add("After", this.editorLabel);
            }
            this.editorLabel.setText("<html>" + Defs.getString(-903340486) + "<br>" + user.name + "</html>");
        }
    }
}

