/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    View[] children = new View[0];
    Rectangle insideAllocation;
    Insets insets = new Insets(0, 0, 0, 0);

    protected void loadChildren(ViewFactory f) {
        Element el = this.getElement();
        int count = el.getElementCount();
        View[] newChildren = new View[count];
        int i = 0;
        while (i < count) {
            View view;
            Element child = el.getElement(i);
            newChildren[i] = view = f.create(child);
            ++i;
        }
        this.replace(0, this.getViewCount(), newChildren);
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null && (this.children == null || this.children.length == 0)) {
            this.loadChildren(this.getViewFactory());
        }
    }

    public int getViewCount() {
        return this.children.length;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public void replace(int offset, int length, View[] views) {
        int i = 0;
        while (i < views.length) {
            if (views[i] == null) {
                throw new NullPointerException("Added views must not be null");
            }
            ++i;
        }
        int endOffset = offset + length;
        int i2 = offset;
        while (i2 < endOffset) {
            this.children[i2].setParent(null);
            ++i2;
        }
        View[] newChildren = new View[this.children.length - length + views.length];
        System.arraycopy(this.children, 0, newChildren, 0, offset);
        System.arraycopy(views, 0, newChildren, offset, views.length);
        System.arraycopy(this.children, offset + length, newChildren, offset + views.length, this.children.length - (offset + length));
        this.children = newChildren;
        int i3 = 0;
        while (i3 < views.length) {
            views[i3].setParent(this);
            ++i3;
        }
    }

    public Shape getChildAllocation(int index, Shape a) {
        Rectangle r = this.getInsideAllocation(a);
        this.childAllocation(index, r);
        return r;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias bias) throws BadLocationException {
        int childIndex = this.getViewIndex(pos, bias);
        if (childIndex != -1) {
            View child = this.getView(childIndex);
            Shape result = child.modelToView(pos, a, bias);
            if (result == null) {
                throw new AssertionError((Object)(child.getClass().getName() + ".modelToView() must not return null"));
            }
            return result;
        }
        throw new AssertionError((Object)("No child views found where child views are expected. pos = " + pos + ", bias = " + bias));
    }

    public Shape modelToView(int p1, Position.Bias b1, int p2, Position.Bias b2, Shape a) throws BadLocationException {
        return super.modelToView(p1, b1, p2, b2, a);
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        Rectangle r = this.getInsideAllocation(a);
        View view = this.getViewAtPoint((int)x, (int)y, r);
        return view.viewToModel(x, y, a, b);
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int retVal = -1;
        switch (direction) {
            case 3: 
            case 7: {
                retVal = this.getNextEastWestVisualPositionFrom(pos, b, a, direction, biasRet);
                break;
            }
            case 1: 
            case 5: {
                retVal = this.getNextNorthSouthVisualPositionFrom(pos, b, a, direction, biasRet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for direction.");
            }
        }
        return retVal;
    }

    public int getViewIndex(int pos, Position.Bias b) {
        return this.getViewIndexAtPosition(pos);
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int pos, Rectangle a) {
        int i = this.getViewIndexAtPosition(pos);
        View view = this.children[i];
        this.childAllocation(i, a);
        return view;
    }

    protected int getViewIndexAtPosition(int pos) {
        int index = -1;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getStartOffset() <= pos && this.children[i].getEndOffset() > pos) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Rectangle getInsideAllocation(Shape a) {
        if (a == null) {
            return null;
        }
        Rectangle alloc = a.getBounds();
        CompositeView compositeView = this;
        synchronized (compositeView) {
            Rectangle inside = this.insideAllocation;
            if (inside == null) {
                this.insideAllocation = inside = new Rectangle();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
            inside.x = alloc.x + this.insets.left;
            inside.y = alloc.y + this.insets.top;
            inside.width = alloc.width - this.insets.left - this.insets.right;
            inside.height = alloc.height - this.insets.top - this.insets.bottom;
            return inside;
        }
    }

    protected void setParagraphInsets(AttributeSet attributes) {
        Float l = (Float)attributes.getAttribute(StyleConstants.LeftIndent);
        short left = 0;
        if (l != null) {
            left = l.shortValue();
        }
        Float r = (Float)attributes.getAttribute(StyleConstants.RightIndent);
        short right = 0;
        if (r != null) {
            right = r.shortValue();
        }
        Float t = (Float)attributes.getAttribute(StyleConstants.SpaceAbove);
        short top = 0;
        if (t != null) {
            top = t.shortValue();
        }
        Float b = (Float)attributes.getAttribute(StyleConstants.SpaceBelow);
        short bottom = 0;
        if (b != null) {
            bottom = b.shortValue();
        }
        this.setInsets(top, left, bottom, right);
    }

    protected void setInsets(short top, short left, short bottom, short right) {
        this.insets.top = top;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    protected short getLeftInset() {
        return (short)this.insets.left;
    }

    protected short getRightInset() {
        return (short)this.insets.right;
    }

    protected short getTopInset() {
        return (short)this.insets.top;
    }

    protected short getBottomInset() {
        return (short)this.insets.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return pos;
    }

    protected int getNextEastWestVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return pos;
    }

    protected boolean flipEastAndWestAtEnds(int pos, Position.Bias bias) {
        return false;
    }

    public CompositeView(Element element) {
        super(element);
    }
}

