#  SubKey.pm
#    - encompass some information about GnuPG::SubKeys
#
#  Copyright (C) 2000 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This file is part of pgpenvelope
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org/copyleft/gpl.html
#
#  $Id: SubKey.pm,v 1.1 2001/04/30 02:15:11 ftobin Exp $

package PGPEnvelope::SubKey;

push @ISA, 'GnuPG::SubKey', 'PGPEnvelope::Key';

use strict;

use GnuPG::SubKey;
use PGPEnvelope::Key;


sub pgpenvelope_init
{
    my ( $self ) = @_;
    $self->short_key_type( 'sub' );
}


sub info
{
    my ( $self, %args ) = @_;
    my $short_only = $args{short} || 0;
    
    my @info = ( join( ' ', ( $self->short_key_type() . ' ' ),
		       $self->short_hex_id(),
		       $self->creation_date_string()
		     )
		 . "\n"
	       );
    
    return @info;
}
