/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.ATextField;

public class Spinner
extends JPanel {
    private ActionListener listener;
    private final ATextField text;
    private final JButton incBut;
    private final JButton decBut;
    public final Model model;

    public Spinner(Model spinModel, String initText, int numChars, ActionListener spinListener) {
        super(new BorderLayout());
        this.model = spinModel;
        this.listener = spinListener;
        this.decBut = this.spinBut(1436228507, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Spinner.this.setText(Spinner.this.model.decrement(Spinner.this));
                }
                catch (BadInputException excep) {
                    Spinner.this.listener.actionPerformed(new ActionEvent(Spinner.this, 1001, excep.getMessage()));
                }
            }
        });
        this.add("Before", this.decBut);
        this.incBut = this.spinBut(1436228508, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Spinner.this.setText(Spinner.this.model.increment(Spinner.this));
                }
                catch (BadInputException excep) {
                    Spinner.this.listener.actionPerformed(new ActionEvent(Spinner.this, 1001, excep.getMessage()));
                }
            }
        });
        this.add("After", this.incBut);
        Dimension dim = this.incBut.getPreferredSize();
        Dimension decDim = this.decBut.getPreferredSize();
        if (decDim.width > dim.width) {
            dim.width = decDim.width;
        }
        if (decDim.height > dim.height) {
            dim.height = decDim.height;
        }
        this.incBut.setPreferredSize(dim);
        this.decBut.setPreferredSize(dim);
        this.text = new ATextField(initText, numChars, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Spinner.this.test(true);
                Spinner.this.incBut.setEnabled(Spinner.this.isEnabled() && Spinner.this.model.incrementOK(Spinner.this));
                Spinner.this.decBut.setEnabled(Spinner.this.isEnabled() && Spinner.this.model.decrementOK(Spinner.this));
            }
        });
        this.add(this.text);
    }

    public void addActionListener(final ActionListener newListener) {
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                newListener.actionPerformed(new ActionEvent(Spinner.this, 1001, ""));
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.changedUpdate(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.changedUpdate(null);
            }
        });
    }

    private JButton spinBut(int labelId, ActionListener newListener) {
        JButton result = new JButton(Defs.getString(labelId));
        result.addActionListener(newListener);
        result.setMargin(new Insets(2, 2, 2, 2));
        return result;
    }

    public final void setText(String newText) {
        if (!newText.equals(this.text.getText())) {
            this.text.setText(newText);
            this.incBut.setEnabled(this.isEnabled() && this.model.incrementOK(this));
            this.decBut.setEnabled(this.isEnabled() && this.model.decrementOK(this));
        }
    }

    public final String getText() {
        return this.text.getText();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.text.setEnabled(isEnabled);
        this.incBut.setEnabled(isEnabled && this.model.incrementOK(this));
        this.decBut.setEnabled(isEnabled && this.model.decrementOK(this));
    }

    @Override
    public boolean isEnabled() {
        return this.text.isEnabled();
    }

    public boolean test(boolean propagate) {
        boolean result;
        block2: {
            result = true;
            try {
                this.model.test(this);
            }
            catch (BadInputException excep) {
                result = false;
                if (!propagate) break block2;
                this.listener.actionPerformed(new ActionEvent(this, 1001, excep.getMessage()));
            }
        }
        this.incBut.setEnabled(this.isEnabled() && this.model.incrementOK(this));
        this.decBut.setEnabled(this.isEnabled() && this.model.decrementOK(this));
        return result;
    }

    public Model getModel() {
        return this.model;
    }

    public ATextField getTextWidget() {
        return this.text;
    }

    public static class DefaultModel
    implements Model {
        private String errorMessage;
        private int minVal;
        private int maxVal;

        public DefaultModel() {
        }

        public DefaultModel(String errorMessage, int minVal, int maxVal) {
            this.errorMessage = errorMessage;
            this.minVal = minVal;
            this.maxVal = maxVal;
        }

        public void setErrorMessage(String newErrorMessage) {
            this.errorMessage = newErrorMessage;
        }

        public void setLimits(int newMinVal, int newMaxVal) {
            this.minVal = newMinVal;
            this.maxVal = newMaxVal;
        }

        @Override
        public String increment(Spinner spinner) throws BadInputException {
            int val;
            try {
                val = this.getVal(spinner) + 1;
            }
            catch (BadInputException excep) {
                val = this.minVal;
            }
            return Integer.toString(val);
        }

        @Override
        public boolean incrementOK(Spinner spinner) {
            try {
                return this.getVal(spinner) < this.maxVal;
            }
            catch (BadInputException excep) {
                return true;
            }
        }

        @Override
        public String decrement(Spinner spinner) throws BadInputException {
            int val;
            try {
                val = this.getVal(spinner) - 1;
            }
            catch (BadInputException excep) {
                val = this.maxVal;
            }
            return Integer.toString(val);
        }

        @Override
        public boolean decrementOK(Spinner spinner) {
            try {
                return this.getVal(spinner) > this.minVal;
            }
            catch (BadInputException excep) {
                return true;
            }
        }

        @Override
        public void test(Spinner spinner) throws BadInputException {
            this.getVal(spinner);
        }

        public int getVal(Spinner spinner) throws BadInputException {
            try {
                int iVal = NumberFormat.getNumberInstance().parse(spinner.getText().trim()).intValue();
                if (iVal >= this.minVal && iVal <= this.maxVal) {
                    return iVal;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            throw this.error(spinner);
        }

        public BadInputException error(Spinner spinner) {
            return new BadInputException(MessageFormat.format(this.errorMessage, spinner.getText()));
        }
    }

    public static class BadInputException
    extends Exception {
        public BadInputException(String message) {
            super(message);
        }
    }

    public static interface Model {
        public String increment(Spinner var1) throws BadInputException;

        public boolean incrementOK(Spinner var1);

        public String decrement(Spinner var1) throws BadInputException;

        public boolean decrementOK(Spinner var1);

        public void test(Spinner var1) throws BadInputException;
    }
}

