"""Store encryption state event in db

Revision ID: bb5a68cd3f8e
Revises: 4567a7c4de97
Create Date: 2020-07-12 17:02:06.694396

"""
from alembic import op
import sqlalchemy as sa

from mautrix.client.state_store.sqlalchemy import SerializableType
from mautrix.types import RoomEncryptionStateEventContent

# revision identifiers, used by Alembic.
revision = 'bb5a68cd3f8e'
down_revision = '4567a7c4de97'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('mx_room_state', schema=None) as batch_op:
        batch_op.add_column(sa.Column('encryption',
                                      SerializableType(RoomEncryptionStateEventContent),
                                      nullable=True))
        batch_op.add_column(sa.Column('has_full_member_list', sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column('is_encrypted', sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('mx_room_state', schema=None) as batch_op:
        batch_op.drop_column('is_encrypted')
        batch_op.drop_column('has_full_member_list')
        batch_op.drop_column('encryption')
    # ### end Alembic commands ###
