#!/bin/sh
# - Makes index for repositories in a single directory.
# - Makes static pages for each repository directory.
#
# NOTE, things to do manually (once) before running this script:
# - write clone URL, for example "git://git.codemadness.org/dir" to the "url"
#   file for each repo.
# - write description in "description" file.
#
# Usage:
# - mkdir -p gphdir && cd gphdir
# - sh example_create.sh

# path must be absolute.
reposdir="/var/scm/git"
gopherdir="/var/gopher"
stagitdir="/scm"
destdir="${gopherdir}/${stagitdir}"

# remove /'s at the end.
stagitdir=$(printf "%s" "${stagitdir}" | sed 's@[/]*$@@g')

# make index.
stagit-gopher-index -b "${stagitdir}" "${reposdir}/"*/ > "${destdir}/index.gph"

# make files per repo.
for dir in "${reposdir}/"*/; do
	# strip .git suffix.
	r=$(basename "${dir}")
	d=$(basename "${dir}" ".git")
	printf "%s... " "${d}"

	mkdir -p "${destdir}/${d}"
	cd "${destdir}/${d}" || continue
	stagit-gopher -b "${stagitdir}/${d}" -c ".cache" \
		-u "gopher://codemadness.org/1/git/$d/" "${reposdir}/${r}"

	# symlinks
	ln -sf log.gph index.gph

	echo "done"
done
