info = {
    "name": "be",
    "date_order": "DMY",
    "january": [
        "сту",
        "студзень",
        "студзеня",
        "Стд"
    ],
    "february": [
        "лют",
        "лютага",
        "люты"
    ],
    "march": [
        "сак",
        "сакавік",
        "сакавіка"
    ],
    "april": [
        "кра",
        "красавік",
        "красавіка",
        "Крс"
    ],
    "may": [
        "май",
        "мая",
        "Траўня",
        "Тра"
    ],
    "june": [
        "чэр",
        "чэрвень",
        "чэрвеня"
    ],
    "july": [
        "ліп",
        "ліпень",
        "ліпеня"
    ],
    "august": [
        "жні",
        "жнівень",
        "жніўня",
        "Жнівеня",
        "Жнв"
    ],
    "september": [
        "вер",
        "верасень",
        "верасня",
        "Врс"
    ],
    "october": [
        "кас",
        "кастрычнік",
        "кастрычніка",
        "Кст"
    ],
    "november": [
        "ліс",
        "лістапад",
        "лістапада",
        "Ліс"
    ],
    "december": [
        "сне",
        "снежань",
        "снежня",
        "Снж"
    ],
    "monday": [
        "панядзелак",
        "пн",
        "Пнд"
    ],
    "tuesday": [
        "аў",
        "аўторак",
        "Аўт"
    ],
    "wednesday": [
        "серада",
        "ср"
    ],
    "thursday": [
        "чацвер",
        "чц",
        "Чцв",
        "Чв"
    ],
    "friday": [
        "пт",
        "пятніца",
        "Пят"
    ],
    "saturday": [
        "сб",
        "субота",
        "Суб"
    ],
    "sunday": [
        "нд",
        "нядзеля",
        "Няд"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "г",
        "год",
        "гады",
        "года",
        "гадоў"
    ],
    "month": [
        "мес",
        "месяц",
        "месяца",
        "месяцы",
        "месяцаў"
    ],
    "week": [
        "тыд",
        "тыдзень",
        "тыдня",
        "тыдні",
        "тыдняў"
    ],
    "day": [
        "д",
        "дзень",
        "дні",
        "дзён",
        "дзен"
    ],
    "hour": [
        "гадз",
        "гадзіна",
        "гадзіны",
        "гадзіну",
        "гадзін"
    ],
    "minute": [
        "хв",
        "хвіліна",
        "хвілін",
        "хвіліны",
        "хвіліну",
        "хвіл"
    ],
    "second": [
        "с",
        "секунда",
        "секунды",
        "секунду",
        "секунд",
        "сек"
    ],
    "relative-type": {
        "0 day ago": [
            "сёння",
            "сення"
        ],
        "0 hour ago": [
            "у гэту гадзіну"
        ],
        "0 minute ago": [
            "у гэту хвіліну"
        ],
        "0 month ago": [
            "у гэтым месяцы"
        ],
        "0 second ago": [
            "цяпер"
        ],
        "0 week ago": [
            "на гэтым тыдні"
        ],
        "0 year ago": [
            "у гэтым годзе"
        ],
        "1 day ago": [
            "учора",
            "ўчора"
        ],
        "1 month ago": [
            "у мінулым месяцы"
        ],
        "1 week ago": [
            "на мінулым тыдні"
        ],
        "1 year ago": [
            "у мінулым годзе"
        ],
        "in 1 day": [
            "заўтра"
        ],
        "in 1 month": [
            "у наступным месяцы"
        ],
        "in 1 week": [
            "на наступным тыдні"
        ],
        "in 1 year": [
            "у наступным годзе"
        ],
        "2 day ago": [
            "пазаўчора"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) д таму",
            "(\\d+[.,]?\\d*) дзень таму",
            "(\\d+[.,]?\\d*) дня таму"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) гадз таму",
            "(\\d+[.,]?\\d*) гадзіну таму",
            "(\\d+[.,]?\\d*) гадзіны таму"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) хв таму",
            "(\\d+[.,]?\\d*) хвіліну таму",
            "(\\d+[.,]?\\d*) хвіліны таму"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) мес таму",
            "(\\d+[.,]?\\d*) месяц таму",
            "(\\d+[.,]?\\d*) месяца таму"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) с таму",
            "(\\d+[.,]?\\d*) секунду таму",
            "(\\d+[.,]?\\d*) секунды таму"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) тыд таму",
            "(\\d+[.,]?\\d*) тыдзень таму",
            "(\\d+[.,]?\\d*) тыдня таму"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) г таму",
            "(\\d+[.,]?\\d*) год таму",
            "(\\d+[.,]?\\d*) года таму"
        ],
        "in \\1 day": [
            "праз (\\d+[.,]?\\d*) д",
            "праз (\\d+[.,]?\\d*) дзень",
            "праз (\\d+[.,]?\\d*) дня"
        ],
        "in \\1 hour": [
            "праз (\\d+[.,]?\\d*) гадз",
            "праз (\\d+[.,]?\\d*) гадзіну",
            "праз (\\d+[.,]?\\d*) гадзіны"
        ],
        "in \\1 minute": [
            "праз (\\d+[.,]?\\d*) хв",
            "праз (\\d+[.,]?\\d*) хвіліну",
            "праз (\\d+[.,]?\\d*) хвіліны"
        ],
        "in \\1 month": [
            "праз (\\d+[.,]?\\d*) мес",
            "праз (\\d+[.,]?\\d*) месяц",
            "праз (\\d+[.,]?\\d*) месяца"
        ],
        "in \\1 second": [
            "праз (\\d+[.,]?\\d*) с",
            "праз (\\d+[.,]?\\d*) секунду",
            "праз (\\d+[.,]?\\d*) секунды"
        ],
        "in \\1 week": [
            "праз (\\d+[.,]?\\d*) тыд",
            "праз (\\d+[.,]?\\d*) тыдзень",
            "праз (\\d+[.,]?\\d*) тыдня"
        ],
        "in \\1 year": [
            "праз (\\d+[.,]?\\d*) г",
            "праз (\\d+[.,]?\\d*) год",
            "праз (\\d+[.,]?\\d*) года"
        ]
    },
    "locale_specific": {},
    "skip": [
        "каля",
        "у",
        "і",
        "ў",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "таму назад",
        "таму",
        "назад"
    ],
    "in": [
        "на працягу"
    ],
    "simplifications": [
        {
            "^гадзіна": "1 гадзіна"
        },
        {
            "гадзіну": "1 гадзіну"
        },
        {
            "^хвіліну": "1 хвіліну"
        },
        {
            "^секунду": "1 секунду"
        },
        {
            "некалькі секунд": "44 секунды"
        },
        {
            "некалькі хвілін": "2 хвіліны"
        },
        {
            "(\\d+[.,]?\\d*)\\s*гадзін\\s(\\d+[.,]?\\d*)\\s*хвілін": "\\1:\\2"
        }
    ]
}
