/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{FlashMessage}from"@typo3/install/renderable/flash-message.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.output=".t3js-coreUpdate-output",e.updateButton=".t3js-coreUpdate-button"}(Identifiers||(Identifiers={}));class CoreUpdate extends AbstractInteractableModule{constructor(){super(...arguments),this.actionQueue={coreUpdateIsUpdateAvailable:{loadingMessage:"Checking for possible regular or security update",finishMessage:void 0,nextActionName:void 0},coreUpdateCheckPreConditions:{loadingMessage:"Checking if update is possible",finishMessage:"System can be updated",nextActionName:"coreUpdateDownload"},coreUpdateDownload:{loadingMessage:"Downloading new core",finishMessage:void 0,nextActionName:"coreUpdateVerifyChecksum"},coreUpdateVerifyChecksum:{loadingMessage:"Verifying checksum of downloaded core",finishMessage:void 0,nextActionName:"coreUpdateUnpack"},coreUpdateUnpack:{loadingMessage:"Unpacking core",finishMessage:void 0,nextActionName:"coreUpdateMove"},coreUpdateMove:{loadingMessage:"Moving core",finishMessage:void 0,nextActionName:"coreUpdateActivate"},coreUpdateActivate:{loadingMessage:"Activating core",finishMessage:"Core updated - please reload your browser",nextActionName:void 0}},this.buttonTemplate=null}initialize(e){super.initialize(e),this.loadModuleFrameAgnostic("@typo3/install/renderable/flash-message.js").then((async()=>{await this.getData(),this.buttonTemplate=this.findInModal(Identifiers.updateButton)?.cloneNode(!0)})),new RegularEvent("click",((e,t)=>{if(e.preventDefault(),!t.hasAttribute("data-action"))return void this.callAction("coreUpdateIsUpdateAvailable");const a=t.dataset.action;switch(this.findInModal(Identifiers.output).innerHTML="",a){case"updateDevelopment":this.update("development");break;case"updateRegular":this.update("regular");break;default:throw'Unknown update action "'+a+'"'}})).delegateTo(e,".t3js-coreUpdate-init")}getData(){const e=this.getModalBody();return new AjaxRequest(Router.getUrl("coreUpdateGetData")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success?(e.innerHTML=a.html,Modal.setButtons(a.buttons)):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)}))}update(e){"development"!==e&&(e="regular"),this.callAction("coreUpdateCheckPreConditions",e)}callAction(e,t){const a={install:{action:e}};void 0!==t&&(a.install.type=t),this.addLoadingMessage(this.actionQueue[e].loadingMessage),new AjaxRequest(Router.getUrl()).withQueryArguments(a).get({cache:"no-cache"}).then((async a=>{const o=await a.resolve();!0===this.handleResult(o,this.actionQueue[e].finishMessage)&&void 0!==this.actionQueue[e].nextActionName&&this.callAction(this.actionQueue[e].nextActionName,t)}),(e=>{Router.handleAjaxError(e,this.getModalBody())}))}handleResult(e,t){const a=e.success;return this.removeLoadingMessage(),e.status&&"object"==typeof e.status&&this.showStatusMessages(e.status),e.action&&"object"==typeof e.action&&this.showActionButton(e.action),a&&t&&this.addMessage(Severity.ok,t),a}addLoadingMessage(e){this.addMessage(Severity.loading,e)}removeLoadingMessage(){this.findInModal(Identifiers.output).querySelector("typo3-install-flashmessage")?.remove()}showStatusMessages(e){for(const t of e)this.addMessage(t.severity,t.title??"",t.message??"")}showActionButton(e){const t=this.buttonTemplate;e.action&&t.setAttribute("data-action",e.action),e.title&&(t.innerText=e.title),this.findInModal(Identifiers.updateButton).replaceWith(t)}addMessage(e,t,a){this.findInModal(Identifiers.output).append(FlashMessage.create(e,t,a))}}export default new CoreUpdate;