/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;

public abstract class XMLGregorianCalendar
implements Cloneable {
    public abstract void clear();

    public abstract void reset();

    public abstract void setYear(BigInteger var1);

    public abstract void setYear(int var1);

    public abstract void setMonth(int var1);

    public abstract void setDay(int var1);

    public abstract void setTimezone(int var1);

    public void setTime(int hour, int minute, int second) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public abstract void setHour(int var1);

    public abstract void setMinute(int var1);

    public abstract void setSecond(int var1);

    public abstract void setMillisecond(int var1);

    public abstract void setFractionalSecond(BigDecimal var1);

    public void setTime(int hour, int minute, int second, BigDecimal fractional) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setFractionalSecond(fractional);
    }

    public void setTime(int hour, int minute, int second, int millisecond) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(millisecond);
    }

    public abstract BigInteger getEon();

    public abstract int getYear();

    public abstract BigInteger getEonAndYear();

    public abstract int getMonth();

    public abstract int getDay();

    public abstract int getTimezone();

    public abstract int getHour();

    public abstract int getMinute();

    public abstract int getSecond();

    public int getMillisecond() {
        BigDecimal factor = BigDecimal.valueOf(1000L);
        BigDecimal val = this.getFractionalSecond().multiply(factor);
        return val.intValue();
    }

    public abstract BigDecimal getFractionalSecond();

    public abstract int compare(XMLGregorianCalendar var1);

    public abstract XMLGregorianCalendar normalize();

    public boolean equals(Object obj) {
        if (obj instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xgc = (XMLGregorianCalendar)obj;
            BigInteger y1 = this.getEonAndYear();
            BigInteger y2 = xgc.getEonAndYear();
            BigDecimal f1 = this.getFractionalSecond();
            BigDecimal f2 = xgc.getFractionalSecond();
            boolean bl = false;
            if ((y1 == null && y2 == null || y1 != null && y1.equals(y2)) && this.getMonth() == xgc.getMonth() && this.getDay() == xgc.getDay() && this.getTimezone() == xgc.getTimezone() && this.getHour() == xgc.getHour() && this.getMinute() == xgc.getMinute() && this.getSecond() == xgc.getSecond() && (f1 == null && f2 == null || f1 != null && f1.equals(f2))) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        BigInteger y = this.getEonAndYear();
        BigDecimal f = this.getFractionalSecond();
        if (y != null) {
            hash *= 31 + y.hashCode();
        }
        hash *= 31 + this.getMonth();
        hash *= 31 + this.getDay();
        hash *= 31 + this.getTimezone();
        hash *= 31 + this.getHour();
        hash *= 31 + this.getMinute();
        hash *= 31 + this.getSecond();
        if (f != null) {
            hash *= 31 + f.hashCode();
        }
        return hash;
    }

    public abstract String toXMLFormat();

    public abstract QName getXMLSchemaType();

    public String toString() {
        return this.toXMLFormat();
    }

    public abstract boolean isValid();

    public abstract void add(Duration var1);

    public abstract GregorianCalendar toGregorianCalendar();

    public abstract GregorianCalendar toGregorianCalendar(TimeZone var1, Locale var2, XMLGregorianCalendar var3);

    public abstract TimeZone getTimeZone(int var1);

    public abstract Object clone();
}

