/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedPrivateKeyInfo
implements PKCSObjectIdentifiers,
DEREncodable {
    private AlgorithmIdentifier algId;
    private DEROctetString data;

    public EncryptedPrivateKeyInfo(DERConstructedSequence seq) {
        Enumeration e = seq.getObjects();
        this.algId = new AlgorithmIdentifier((DERConstructedSequence)e.nextElement());
        this.data = (DEROctetString)e.nextElement();
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier algId, byte[] encoding) {
        this.algId = algId;
        this.data = new DEROctetString(encoding);
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.algId;
    }

    public byte[] getEncryptedData() {
        return this.data.getOctets();
    }

    public DERObject getDERObject() {
        DERConstructedSequence seq = new DERConstructedSequence();
        seq.addObject(this.algId);
        seq.addObject(this.data);
        return seq;
    }
}

