/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.jsp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import org.igoweb.util.CacheMap;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;
import org.igoweb.util.LockOrder;
import org.igoweb.util.jsp.AbstractInvoice;
import org.igoweb.util.jsp.InvoiceState;

public abstract class AbstractInvoiceManager<ProductT, InvoiceT extends AbstractInvoice> {
    private int nextInvoiceId;
    protected final DbConnFactory factory;
    private List<ProductT> products;
    protected final Logger logger;
    private CacheMap<Integer, InvoiceT> cachedInvoices = new CacheMap(true);

    public AbstractInvoiceManager(DbConnFactory factory, Logger logger) {
        this.factory = factory;
        DbConn db = factory.getDbConn();
        this.logger = logger;
        ResultSet rs = null;
        try {
            rs = db.executeQuery("SELECT MAX(id) AS max_id  FROM invoices");
            this.nextInvoiceId = (rs.next() ? rs.getInt("max_id") : 0) + 1;
            logger.fine("Next invoice ID: " + this.nextInvoiceId);
            rs.close();
            rs = null;
            this.products = this.loadProductList(db);
        }
        catch (SQLException excep) {
            db.error();
            throw new RuntimeException("Error setting up invoice manager", excep);
        }
        finally {
            db.close(rs);
        }
    }

    protected abstract List<ProductT> loadProductList(DbConn var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProducts(DbConn db) throws SQLException {
        List<ProductT> tmpProducts = this.loadProductList(db);
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager = this;
        synchronized (abstractInvoiceManager) {
            this.products = tmpProducts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNewInvoiceId() {
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager = this;
        synchronized (abstractInvoiceManager) {
            return this.nextInvoiceId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInvoice(InvoiceT invoice) {
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager = this;
        synchronized (abstractInvoiceManager) {
            if (this.cachedInvoices.get(((AbstractInvoice)invoice).id) != null) {
                throw new RuntimeException("Invoice " + invoice + " already in our cache!");
            }
            this.cachedInvoices.put(((AbstractInvoice)invoice).id, invoice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setState(InvoiceT invoice, InvoiceState state, String notes) {
        DbConn db = this.factory.getDbConn();
        ResultSet rs = null;
        try {
            boolean bl;
            assert (LockOrder.testAcquire(invoice));
            InvoiceT InvoiceT = invoice;
            synchronized (InvoiceT) {
                if (((AbstractInvoice)invoice).getNumChanges() == 0) {
                    throw new IllegalStateException("Invoice " + invoice + " has not been started yet!");
                }
                if (!((AbstractInvoice)invoice).getState().canBecome(state)) {
                    this.logger.warning("Attempt to change invoice " + invoice + " from state " + (Object)((Object)((AbstractInvoice)invoice).getState()) + " to " + (Object)((Object)state) + " is illegal (notes " + notes + ")");
                    boolean bl2 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var6_6
                    db.close(rs);
                    return bl2;
                }
                if (!this.setState(db, invoice, state)) {
                    boolean bl3 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 9] lbl18 : MonitorExitStatement: MONITOREXIT : var6_6
                    db.close(rs);
                    return bl3;
                }
                ((AbstractInvoice)invoice).addChange(db, state, notes);
                bl = true;
            }
            db.close(rs);
            return bl;
        }
        catch (Throwable throwable) {
            db.close(rs);
            throw throwable;
        }
        {
            catch (SQLException excep) {
                db.error();
                throw new RuntimeException(excep);
            }
        }
    }

    protected boolean setState(DbConn db, InvoiceT invoice, InvoiceState newState) throws SQLException {
        return true;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvoiceT getInvoice(int invoiceId) {
        InvoiceT invoice;
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager = this;
        synchronized (abstractInvoiceManager) {
            AbstractInvoice invoice2 = (AbstractInvoice)this.cachedInvoices.get(invoiceId);
            if (invoice2 != null) {
                return (InvoiceT)invoice2;
            }
        }
        try (DbConn db = this.factory.getDbConn();){
            invoice = this.loadInvoice(db, invoiceId);
            if (invoice == null) {
                InvoiceT InvoiceT = null;
                return InvoiceT;
            }
        }
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager2 = this;
        synchronized (abstractInvoiceManager2) {
            AbstractInvoice oldInvoice = (AbstractInvoice)this.cachedInvoices.get(invoiceId);
            if (oldInvoice != null) {
                return (InvoiceT)oldInvoice;
            }
            this.cachedInvoices.put(((AbstractInvoice)invoice).id, invoice);
            return invoice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InvoiceT loadInvoice(DbConn db, int invoiceId) throws SQLException {
        PreparedStatement ps = db.get("SELECT * FROM invoices, invoices_changes  WHERE invoices.id = ? AND invoices_changes.invoice_id = invoices.id  ORDER BY invoices_changes.change_id");
        ps.setInt(1, invoiceId);
        try (ResultSet rs = ps.executeQuery();){
            InvoiceT InvoiceT = rs.next() ? (InvoiceT)this.createInvoice(rs) : null;
            return InvoiceT;
        }
    }

    protected abstract InvoiceT createInvoice(ResultSet var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductT getProduct(int id) {
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager = this;
        synchronized (abstractInvoiceManager) {
            ProductT product;
            if (id >= 0 && id < this.products.size() && (product = this.products.get(id)) != null) {
                return product;
            }
        }
        throw new IllegalArgumentException("Invalid product ID " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProductT> getProducts() {
        assert (LockOrder.testAcquire(this));
        AbstractInvoiceManager abstractInvoiceManager = this;
        synchronized (abstractInvoiceManager) {
            return this.products;
        }
    }
}

