<?php

/**
 * BaseTimesheetItem
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int              $timesheetItemId                         Type: integer, primary key
 * @property int              $timesheetId                             Type: integer
 * @property int              $employeeId                              Type: integer
 * @property int              $projectId                               Type: integer
 * @property int              $activityId                              Type: integer
 * @property string           $date                                    Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property int              $duration                                Type: integer
 * @property string           $comment                                 Type: string(2000)
 * @property Timesheet        $Timesheet                               
 * @property Project          $Project                                 
 * @property ProjectActivity  $ProjectActivity                         
 * @property Employee         $Employee                                
 *  
 * @method int                getTimesheetitemid()                     Type: integer, primary key
 * @method int                getTimesheetid()                         Type: integer
 * @method int                getEmployeeid()                          Type: integer
 * @method int                getProjectid()                           Type: integer
 * @method int                getActivityid()                          Type: integer
 * @method string             getDate()                                Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                getDuration()                            Type: integer
 * @method string             getComment()                             Type: string(2000)
 * @method Timesheet          getTimesheet()                           
 * @method Project            getProject()                             
 * @method ProjectActivity    getProjectActivity()                     
 * @method Employee           getEmployee()                            
 *  
 * @method TimesheetItem      setTimesheetitemid(int $val)             Type: integer, primary key
 * @method TimesheetItem      setTimesheetid(int $val)                 Type: integer
 * @method TimesheetItem      setEmployeeid(int $val)                  Type: integer
 * @method TimesheetItem      setProjectid(int $val)                   Type: integer
 * @method TimesheetItem      setActivityid(int $val)                  Type: integer
 * @method TimesheetItem      setDate(string $val)                     Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method TimesheetItem      setDuration(int $val)                    Type: integer
 * @method TimesheetItem      setComment(string $val)                  Type: string(2000)
 * @method TimesheetItem      setTimesheet(Timesheet $val)             
 * @method TimesheetItem      setProject(Project $val)                 
 * @method TimesheetItem      setProjectActivity(ProjectActivity $val) 
 * @method TimesheetItem      setEmployee(Employee $val)               
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseTimesheetItem extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_timesheet_item');
        $this->hasColumn('timesheet_item_id as timesheetItemId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('timesheet_id as timesheetId', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('employee_id as employeeId', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('project_id as projectId', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('activity_id as activityId', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('date', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('duration', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('comment', 'string', 2000, array(
             'type' => 'string',
             'length' => 2000,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Timesheet', array(
             'local' => 'timesheetId',
             'foreign' => 'timesheetId',
             'onDelete' => 'cascade'));

        $this->hasOne('Project', array(
             'local' => 'projectId',
             'foreign' => 'project_id',
             'onDelete' => 'cascade'));

        $this->hasOne('ProjectActivity', array(
             'local' => 'activityId',
             'foreign' => 'activity_id',
             'onDelete' => 'cascade'));

        $this->hasOne('Employee', array(
             'local' => 'employeeId',
             'foreign' => 'empNumber',
             'onDelete' => 'cascade'));
    }
}