/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.UnitTypeOption;

public final class UnitTypeOptionUI
extends OptionUI<UnitTypeOption> {
    private final JComboBox<UnitType> box = new JComboBox();

    public UnitTypeOptionUI(UnitTypeOption option, boolean editable) {
        super(option, editable);
        List<UnitType> choices = option.getChoices();
        this.box.setModel(new DefaultComboBoxModel<UnitType>(choices.toArray(new UnitType[choices.size()])));
        this.box.setSelectedItem(option.getValue());
        this.box.setRenderer(new ChoiceRenderer());
        this.initialize();
    }

    @Override
    public JComboBox getComponent() {
        return this.box;
    }

    @Override
    public void updateOption() {
        ((UnitTypeOption)this.getOption()).setValue((UnitType)this.box.getSelectedItem());
    }

    @Override
    public void reset() {
        this.box.setSelectedItem(((UnitTypeOption)this.getOption()).getValue());
    }

    private static class ChoiceRenderer
    extends FreeColComboBoxRenderer<UnitType> {
        private ChoiceRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, UnitType value) {
            label.setText(value == null ? Messages.message("none") : Messages.getName(value));
        }
    }
}

