/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;

class SimpleError
implements EditorError {
    private final String absolutePath;
    private boolean consumed;
    private final Editor<?> editor;
    private final String message;
    private final Object value;
    private final Object userData;
    private int pathPrefixLength;

    SimpleError(AbstractEditorDelegate<?, ?> delegate, String message, Object value, Object userData) {
        this.absolutePath = delegate.getPath();
        this.editor = delegate.getEditor();
        this.message = message;
        this.value = value == null ? delegate.getObject() : value;
        this.userData = userData;
    }

    SimpleError(AbstractEditorDelegate<?, ?> delegate, String message, Object value, Object userData, String extraPath, Editor<?> leafEditor) {
        assert (extraPath != null && extraPath.length() > 0);
        this.absolutePath = delegate.getPath() + extraPath;
        this.editor = leafEditor;
        this.message = message;
        this.value = value;
        this.userData = userData;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public Editor<?> getEditor() {
        return this.editor;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getPath() {
        return this.absolutePath.substring(this.pathPrefixLength);
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    public String toString() {
        return this.getMessage() + " @ " + this.getPath();
    }

    void setPathPrefixLength(int pathPrefixLength) {
        this.pathPrefixLength = pathPrefixLength;
    }
}

