/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.update;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.wiztools.appupdate.Version;
import org.wiztools.appupdate.VersionImpl;
import org.wiztools.appupdate.VersionUrl;
import org.wiztools.appupdate.VersionWSUtil;
import org.wiztools.restclient.IGlobalOptions;

public class AppUpdateRunner
implements Runnable {
    @Inject
    private IGlobalOptions options;
    private static final Logger LOG = Logger.getLogger(AppUpdateRunner.class.getName());
    private static final String UPDATE_URL = "http://static.wiztools.org/v/restclient.json";
    private static final String PROP_UPDATE_CHECK_LAST = "update.check.last";
    private static final String PROP_UPDATE_CHECK_ENABLED = "update.check.enabled";
    static final long TIME_GAP = 604800000L;
    private VersionUrl data;

    private void openUrl(String url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException | URISyntaxException ex) {
                LOG.log(Level.INFO, "Error when opening browser", ex);
            }
        }
    }

    boolean doUpdateCheck(long lastUpdateCheck) {
        return lastUpdateCheck + 604800000L < System.currentTimeMillis();
    }

    boolean requiresUpdate(Version latestVersion) {
        return latestVersion.isGreaterThan(new VersionImpl("3.7.2"));
    }

    boolean requiresUpdate() throws IOException {
        this.data = VersionWSUtil.getLatestVersion(UPDATE_URL);
        Version latestVersion = this.data.getVersion();
        return this.requiresUpdate(latestVersion);
    }

    @Override
    public void run() {
        long lastRun;
        String strEnabled = this.options.getProperty(PROP_UPDATE_CHECK_ENABLED);
        if (strEnabled != null && strEnabled.equals("false")) {
            return;
        }
        String strLastRun = this.options.getProperty(PROP_UPDATE_CHECK_LAST);
        if (strLastRun != null && !this.doUpdateCheck(lastRun = Long.parseLong(strLastRun))) {
            return;
        }
        try {
            if (this.requiresUpdate()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int opt = JOptionPane.showConfirmDialog(null, "An updated version of RESTClient is available. Do you want to download?", "Download update?", 0);
                        if (opt == 0) {
                            AppUpdateRunner.this.openUrl(AppUpdateRunner.this.data.getDlUrl());
                        }
                    }
                });
            }
            this.options.setProperty(PROP_UPDATE_CHECK_LAST, String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot perform update check...", ex);
        }
    }
}

