/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.dnd;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wiztools.restclient.ui.dnd.DndAction;

public class FileDropTargetListener
implements DropTargetListener {
    private static final Logger LOG = Logger.getLogger(FileDropTargetListener.class.getName());
    private final List<DndAction> actions = new ArrayList<DndAction>();

    public void addDndAction(DndAction action) {
        this.actions.add(action);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.getDropTargetContext().getComponent().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.getDropTargetContext().getComponent().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        dte.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent evt) {
        int action = evt.getDropAction();
        evt.acceptDrop(action);
        try {
            Transferable data = evt.getTransferable();
            if (data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
                for (DndAction a : this.actions) {
                    a.onDrop(list);
                }
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
        finally {
            evt.dropComplete(true);
            evt.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

