/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;

public final class DateUtil {
    private static final SimpleDateFormat SDF_ISO_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat SDF_ISO_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final Pattern p1 = Pattern.compile("[0-9]{1,2}-[0-9]{1,2}-[0-9]{2}");
    private static final SimpleDateFormat sdf_p1 = new SimpleDateFormat("dd-MM-yy");
    private static final Pattern p2 = Pattern.compile("[0-9]{1,2}-[0-9]{1,2}-[0-9]{4}");
    private static final SimpleDateFormat sdf_p2 = new SimpleDateFormat("dd-MM-yyyy");
    private static final Pattern p3 = Pattern.compile("[0-9]{1,2}/[0-9]{1,2}/[0-9]{2}");
    private static final SimpleDateFormat sdf_p3 = new SimpleDateFormat("dd/MM/yy");
    private static final Pattern p4 = Pattern.compile("[0-9]{1,2}/[0-9]{1,2}/[0-9]{4}");
    private static final SimpleDateFormat sdf_p4 = new SimpleDateFormat("dd/MM/yyyy");
    private static final Pattern p5 = Pattern.compile("[A-Za-z]{3} [0-9]{1,2}, [0-9]{4}");
    private static final SimpleDateFormat sdf_p5 = new SimpleDateFormat("MMM dd, yyyy");
    private static final Pattern p6 = Pattern.compile("[A-Za-z]{3} [0-9]{1,2} [0-9]{4}");
    private static final SimpleDateFormat sdf_p6 = new SimpleDateFormat("MMM dd yyyy");
    private static final Pattern p7 = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    private static final SimpleDateFormat sdf_p7 = new SimpleDateFormat("yyyy-MM-dd");

    public static String getAsISODateString(Date date) {
        return SDF_ISO_DATE.format(date);
    }

    public static String getAsISODateTimeString(Date date) {
        return SDF_ISO_DATE.format(date) + "T" + SDF_ISO_TIME.format(date);
    }

    public static Date getFromISODateString(String dateStr) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            return (Date)fmt.parseObject(dateStr);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static boolean isDateBetween(Date startDate, Date endDate, Date date) {
        if (startDate.compareTo(endDate) > 0) {
            throw new IllegalArgumentException("Start date cannot be greater than end date!");
        }
        return date.compareTo(startDate) >= 0 && date.compareTo(endDate) <= 0;
    }

    private static Date getDatePlus(int unit, Date date, int quantity) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.add(unit, quantity);
        return c.getTime();
    }

    public static Date getDatePlusDays(Date date, int days) {
        return DateUtil.getDatePlus(5, date, days);
    }

    public static Date getDatePlusMonths(Date date, int months) {
        return DateUtil.getDatePlus(2, date, months);
    }

    public static Date getDatePlusYears(Date date, int years) {
        return DateUtil.getDatePlus(1, date, years);
    }

    public static Date getDateFromString(String dateStr) throws ParseException {
        SimpleDateFormat sdf = null;
        if (p1.matcher(dateStr).matches()) {
            sdf = sdf_p1;
        } else if (p2.matcher(dateStr).matches()) {
            sdf = sdf_p2;
        } else if (p3.matcher(dateStr).matches()) {
            sdf = sdf_p3;
        } else if (p4.matcher(dateStr).matches()) {
            sdf = sdf_p4;
        } else if (p5.matcher(dateStr).matches()) {
            sdf = sdf_p5;
        } else if (p6.matcher(dateStr).matches()) {
            sdf = sdf_p6;
        } else if (p7.matcher(dateStr).matches()) {
            sdf = sdf_p7;
        }
        if (sdf != null) {
            return sdf.parse(dateStr);
        }
        throw new ParseException(dateStr + " does not match any defined pattern!", 0);
    }

    public static Date now() {
        return new Date();
    }
}

