/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.DoubleArray;
import ints.IntList;
import ints.WrappedIntArray;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import phase.FixedPhaseData;
import phase.FwdPbwtPhaser;
import phase.SamplePhase;
import vcf.GT;

public class PbwtPhaser {
    private final int start;
    private final int end;
    private final FwdPbwtPhaser fwdPbwt;

    private PbwtPhaser(FixedPhaseData fixedPhaseData, int n, int n2, long l) {
        if (n < 0 || n2 > fixedPhaseData.targGT().nMarkers() || n >= n2) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.start = n;
        this.end = n2;
        this.fwdPbwt = new FwdPbwtPhaser(fixedPhaseData, n, n2, l);
    }

    public static AtomicReferenceArray<SamplePhase> initPhase(FixedPhaseData fixedPhaseData, long l) {
        PbwtPhaser[] pbwtPhaserArray = PbwtPhaser.pbwtPhasers(fixedPhaseData, l);
        int n = fixedPhaseData.stage1TargGT().nSamples();
        int n3 = PbwtPhaser.nSamplesPerBatch(n, fixedPhaseData.par().nthreads());
        int n4 = (n + (n3 - 1)) / n3;
        AtomicReferenceArray<SamplePhase> atomicReferenceArray = new AtomicReferenceArray<SamplePhase>(n);
        IntStream.range(0, n4).parallel().boxed().forEach(n2 -> PbwtPhaser.setSamplePhase(fixedPhaseData, pbwtPhaserArray, atomicReferenceArray, n2, n3));
        return atomicReferenceArray;
    }

    private static int nSamplesPerBatch(int n, int n2) {
        int n3 = 4096;
        int n4 = (n + n2 - 1) / n2;
        while (n4 > n3) {
            n4 = n4 + 1 >> 1;
        }
        return n4;
    }

    private static void setSamplePhase(FixedPhaseData fixedPhaseData, PbwtPhaser[] pbwtPhaserArray, AtomicReferenceArray<SamplePhase> atomicReferenceArray, int n, int n2) {
        int n3;
        GT gT = fixedPhaseData.stage1TargGT();
        int n4 = n * n2;
        int n5 = Math.min(n4 + n2, gT.nSamples());
        Indices[] indicesArray = PbwtPhaser.indices(fixedPhaseData, n4, n5);
        int n6 = 0;
        int[][] nArray = new int[n5 - n4 << 1][gT.nMarkers()];
        pbwtPhaserArray[0].copyHaps(nArray, indicesArray, n6, n4, n5);
        for (n3 = 1; n3 < pbwtPhaserArray.length; ++n3) {
            n6 = pbwtPhaserArray[n3 - 1].end;
            pbwtPhaserArray[n3].copyHaps(nArray, indicesArray, n6, n4, n5);
        }
        for (n3 = n4; n3 < n5; ++n3) {
            int n7 = n3 - n4;
            int n8 = n7 << 1;
            int n9 = n8 | 1;
            atomicReferenceArray.set(n3, new SamplePhase(gT.markers(), fixedPhaseData.stage1Map().genPos(), nArray[n8], nArray[n9], indicesArray[n7].hetIndices, indicesArray[n7].missIndices));
        }
    }

    private void copyHaps(int[][] nArray, Indices[] indicesArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.start + n >>> 1;
        int[][] nArray2 = (int[][])nArray.clone();
        if (this.start > 0) {
            for (n8 = n2; n8 < n3; ++n8) {
                n7 = n8 - n2;
                n6 = n7 << 1;
                n5 = n6 | 1;
                n4 = PbwtPhaser.alignmentHet(indicesArray[n7].hetIndices, this.start, n9, n);
                if (n4 < 0 || !this.switchHapLabels(n8, nArray[n6], nArray[n5], n4)) continue;
                nArray2[n6] = nArray[n5];
                nArray2[n5] = nArray[n6];
            }
        }
        for (n8 = n9; n8 < this.end; ++n8) {
            for (n7 = n2; n7 < n3; ++n7) {
                n6 = n7 << 1;
                n5 = n6 | 1;
                n4 = n7 - n2 << 1;
                int n10 = n4 | 1;
                nArray2[n4][n8] = this.fwdPbwt.allele(n8, n6);
                nArray2[n10][n8] = this.fwdPbwt.allele(n8, n5);
            }
        }
    }

    private static int alignmentHet(WrappedIntArray wrappedIntArray, int n, int n2, int n3) {
        int n4;
        if (wrappedIntArray.size() == 0) {
            return -1;
        }
        int n5 = PbwtPhaser.insPt(wrappedIntArray, n2);
        if (n5 == wrappedIntArray.size() || wrappedIntArray.get(n5) >= n3 && n5 > 0) {
            --n5;
        }
        return n <= (n4 = wrappedIntArray.get(n5)) && n4 < n3 ? n4 : -1;
    }

    private boolean switchHapLabels(int n, int[] nArray, int[] nArray2, int n2) {
        int n3 = n << 1;
        int n4 = n3 | 1;
        int n5 = nArray[n2];
        int n6 = nArray2[n2];
        int n7 = this.fwdPbwt.allele(n2, n3);
        int n8 = this.fwdPbwt.allele(n2, n4);
        return n5 == n8 && n6 == n7;
    }

    private static int insPt(WrappedIntArray wrappedIntArray, int n) {
        int n2 = wrappedIntArray.binarySearch(n);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    private static PbwtPhaser[] pbwtPhasers(FixedPhaseData fixedPhaseData, long l) {
        int[][] nArray = PbwtPhaser.hiFreqWindows(fixedPhaseData);
        return (PbwtPhaser[])IntStream.range(0, nArray.length).parallel().mapToObj(n -> new PbwtPhaser(fixedPhaseData, nArray[n][0], nArray[n][1], l + (long)n)).toArray(PbwtPhaser[]::new);
    }

    private static int[][] hiFreqWindows(FixedPhaseData fixedPhaseData) {
        DoubleArray doubleArray = fixedPhaseData.stage1Map().genPos();
        int n = doubleArray.size();
        int n2 = fixedPhaseData.par().nthreads();
        double d = doubleArray.get(doubleArray.size() - 1) - doubleArray.get(0);
        double d2 = 1.5;
        double d3 = Math.max(2.0 * d2, (d - d2) / (double)n2);
        ArrayList<int[]> arrayList = new ArrayList<int[]>(n2);
        int n3 = 0;
        int n4 = PbwtPhaser.insPt(doubleArray, doubleArray.get(n3) + d2 + d3) + 1;
        while (n4 < n) {
            arrayList.add(new int[]{n3, n4});
            n3 = PbwtPhaser.insPt(doubleArray, doubleArray.get(n4) - d2) - 1;
            n4 = PbwtPhaser.insPt(doubleArray, doubleArray.get(n4) + d3) + 1;
        }
        arrayList.add(new int[]{n3, n});
        return (int[][])arrayList.toArray((T[])new int[0][]);
    }

    private static int insPt(DoubleArray doubleArray, double d) {
        int n = doubleArray.binarySearch(d);
        return n < 0 ? -n - 1 : n;
    }

    private static Indices[] indices(FixedPhaseData fixedPhaseData, int n2, int n3) {
        GT gT = fixedPhaseData.stage1TargGT();
        int n4 = fixedPhaseData.stage1Overlap();
        int n5 = gT.nMarkers();
        int n6 = n3 - n2;
        IntList[] intListArray = PbwtPhaser.intLists(n6);
        IntList[] intListArray2 = PbwtPhaser.intLists(n6);
        boolean[] blArray = new boolean[n6];
        for (int i = 0; i < n5; ++i) {
            for (int j = n2; j < n3; ++j) {
                int n7 = j - n2;
                int n8 = gT.allele1(i, j);
                int n9 = gT.allele2(i, j);
                if (n8 < 0 || n9 < 0) {
                    intListArray[n7].add(i);
                    continue;
                }
                if (n8 == n9) continue;
                if (i >= n4 && blArray[n7]) {
                    intListArray2[n7].add(i);
                    continue;
                }
                blArray[n7] = true;
            }
        }
        return (Indices[])IntStream.range(0, n6).mapToObj(n -> new Indices(intListArray[n], intListArray2[n])).toArray(Indices[]::new);
    }

    private static IntList[] intLists(int n2) {
        return (IntList[])IntStream.range(0, n2).parallel().mapToObj(n -> new IntList()).toArray(IntList[]::new);
    }

    private static class Indices {
        public final WrappedIntArray missIndices;
        public final WrappedIntArray hetIndices;

        public Indices(IntList intList, IntList intList2) {
            this.missIndices = new WrappedIntArray(intList);
            this.hetIndices = new WrappedIntArray(intList2);
        }
    }
}

