/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.security.sig.rsa.EME_PKCS1_V1_5;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.io.PrintWriter;

public class PKCS1_V1_5
extends BasePad {
    private static final String NAME = "eme-pkcs1-v1.5";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 9;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private EME_PKCS1_V1_5 codec;

    private static final void debug(String string) {
        err.println(">>> eme-pkcs1-v1.5: " + string);
    }

    public void setup() {
        this.codec = EME_PKCS1_V1_5.getInstance(this.blockSize);
    }

    public byte[] pad(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.codec.encode(byArray2);
        byte[] byArray4 = new byte[this.blockSize - n2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return byArray4;
    }

    public int unpad(byte[] byArray, int n, int n2) throws WrongPaddingException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = n2 - this.codec.decode(byArray2).length;
        return n3;
    }

    public boolean selfTest() {
        int[] nArray = new int[]{16, 20, 32, 48, 64};
        byte[] byArray = new byte[nArray[nArray.length - 1]];
        PRNG.getInstance().nextBytes(byArray);
        byte[] byArray2 = new byte[1024];
        int n = 256;
        while (n < 1025) {
            this.init(n);
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2];
                byte[] byArray3 = this.pad(byArray, 0, n3);
                if (n3 + byArray3.length != this.blockSize) {
                    new RuntimeException(this.name()).printStackTrace(System.err);
                    return false;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                System.arraycopy(byArray, 0, byArray2, byArray3.length, n3);
                try {
                    if (byArray3.length != this.unpad(byArray2, 0, this.blockSize)) {
                        new RuntimeException(this.name()).printStackTrace(System.err);
                        return false;
                    }
                }
                catch (WrongPaddingException wrongPaddingException) {
                    wrongPaddingException.printStackTrace(System.err);
                    return false;
                }
                ++n2;
            }
            this.reset();
            n += 256;
        }
        return true;
    }

    PKCS1_V1_5() {
        super(NAME);
    }
}

