/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.LiquidWindowButtonUI;
import com.birosoft.liquid.SpecialUIButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class LiquidInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager {
    static LiquidWindowButtonUI iconButtonUI;
    static LiquidWindowButtonUI maxButtonUI;
    static LiquidWindowButtonUI closeButtonUI;
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    Color normalTitleColor = Color.white;
    Color shadowColor = new Color(10, 24, 131);
    Color disabledTitleColor = new Color(64, 63, 63);
    protected int frameTitleHeight;
    private int buttonsWidth;

    protected void installDefaults() {
        super.installDefaults();
        this.frameTitleHeight = UIManager.getInt("InternalFrame.frameTitleHeight");
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void paintTitleBackground(Graphics g) {
    }

    public void paintComponent(Graphics g) {
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        Color foreground = LiquidLookAndFeel.getWindowTitleInactiveForeground();
        this.drawLiquidCaption(g, isSelected, width, height);
        int titleLength = 0;
        int xOffset = leftToRight ? 2 : width - 2;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 2 : -2;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            titleLength = fm.stringWidth(frameTitle);
            if (this.isPalette) {
                if (isSelected) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.black);
                }
                int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
                if (!leftToRight) {
                    xOffset -= titleLength;
                }
                g.drawString(frameTitle, xOffset, yOffset);
                xOffset += leftToRight ? titleLength + 2 : -2;
            } else {
                int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + 1;
                if (!leftToRight) {
                    xOffset -= titleLength;
                }
                xOffset = width / 2 - titleLength / 2;
                if (isSelected) {
                    Graphics2D g2 = (Graphics2D)g;
                    GradientPaint grad = new GradientPaint(xOffset + titleLength / 2, yOffset - 15, new Color(60, 144, 233), xOffset + titleLength / 2, fm.getHeight() + 6, new Color(102, 186, 255));
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setPaint(grad);
                    g2.fillRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, fm.getHeight() + 1, 18, 18);
                    g.setColor(new Color(0, 78, 167));
                    g2.drawRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, fm.getHeight() + 1, 18, 18);
                    g.setColor(Color.black);
                    g.drawString(frameTitle, xOffset + 1, yOffset);
                    g.setColor(this.normalTitleColor);
                    g.drawString(frameTitle, xOffset, yOffset - 1);
                    xOffset += leftToRight ? titleLength + 2 : -2;
                } else {
                    Graphics2D g2 = (Graphics2D)g;
                    GradientPaint grad = new GradientPaint(xOffset + titleLength / 2, yOffset - 15, new Color(191, 211, 233), xOffset + titleLength / 2, fm.getHeight() + 6, new Color(233, 253, 255));
                    g2.setPaint(grad);
                    g2.fillRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, fm.getHeight() + 1, 18, 18);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(new Color(125, 145, 167));
                    g2.drawRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, fm.getHeight() + 1, 18, 18);
                    g.setColor(Color.black);
                    g.drawString(frameTitle, xOffset, yOffset - 1);
                    xOffset += leftToRight ? titleLength + 2 : -2;
                }
            }
        }
    }

    private final void drawLiquidCaption(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(0, 0, w, h - 1);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, 0, w, 0);
        c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
        g.setColor(c);
        g.drawLine(0, 1, w, 1);
        int i = 4;
        while (i < h - 1) {
            c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
            g.setColor(c);
            g.drawLine(0, i, w, i);
            c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
            g.setColor(c);
            g.drawLine(0, i + 1, w, i + 1);
            i += 4;
        }
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(0, h - 1, w, h - 1);
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
        if (this.menuBar != null) {
            // empty if block
        }
    }

    protected void setButtonIcons() {
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = LiquidWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = LiquidWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = LiquidWindowButtonUI.createButtonUIForType(0);
        }
        this.iconButton = new SpecialUIButton((ButtonUI)iconButtonUI, this.frame);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.addMouseListener(new RolloverListener(this.iconButton, this.iconifyAction));
        this.maxButton = new SpecialUIButton((ButtonUI)maxButtonUI, this.frame);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.addMouseListener(new RolloverListener(this.maxButton, this.maximizeAction));
        this.closeButton = new SpecialUIButton((ButtonUI)closeButtonUI, this.frame);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new RolloverListener(this.closeButton, this.closeAction));
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        if (this.frame.isSelected()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void paintPalette(Graphics g) {
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(Container c) {
        return new Dimension(c.getSize().width, this.isPalette ? this.paletteTitleHeight : this.frameTitleHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(70, 25);
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    public void layoutContainer(Container c) {
        int spacing;
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int buttonHeight = this.closeButton.getPreferredSize().height;
        int w = this.getWidth();
        int x = leftToRight ? w : 0;
        int y = (this.getHeight() - buttonHeight) / 2 + 1;
        int buttonWidth = 18;
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                spacing = 0;
                this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            } else {
                spacing = 0;
                this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            spacing = 0;
            this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            spacing = 0;
            this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        this.buttonsWidth = leftToRight ? w - x : x;
    }

    public void activate() {
        this.closeButton.setEnabled(true);
        this.iconButton.setEnabled(true);
        this.maxButton.setEnabled(true);
    }

    public void deactivate() {
        this.closeButton.setEnabled(false);
        this.iconButton.setEnabled(false);
        this.maxButton.setEnabled(false);
    }

    public Font getFont() {
        return this.isPalette ? super.getFont() : UIManager.getFont("InternalFrame.normalTitleFont");
    }

    public LiquidInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    class RolloverListener
    implements MouseListener {
        JButton button;
        Action action;

        public void mouseClicked(MouseEvent e) {
            this.action.actionPerformed(new ActionEvent(this, 1001, this.button.getText()));
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.button.getModel().setRollover(true);
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
            }
            this.button.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.button.getModel().setRollover(false);
            if (!LiquidInternalFrameTitlePane.this.frame.isSelected()) {
                this.button.setEnabled(false);
            }
            this.button.repaint();
        }

        public RolloverListener(JButton b, Action a) {
            this.button = b;
            this.action = a;
        }
    }
}

