/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.appupdate;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiztools.appupdate.Version;

public class VersionImpl
implements Version {
    private static final String regex = "^([0-9]+)(\\.([0-9]+))?(\\.([0-9]+))?$";
    private final String stringRepresentation;
    private final int major;
    private final int minor;
    private final int patch;

    public VersionImpl(String vStr) {
        this.stringRepresentation = vStr;
        Pattern p = Pattern.compile(regex);
        Matcher m3 = p.matcher(vStr);
        if (m3.matches()) {
            this.major = Integer.parseInt(m3.group(1));
            String minorStr = m3.group(3);
            this.minor = minorStr != null && !minorStr.equals("") ? Integer.parseInt(minorStr) : 0;
            String patchStr = m3.group(5);
            this.patch = patchStr != null && !patchStr.equals("") ? Integer.parseInt(patchStr) : 0;
        } else {
            throw new IllegalArgumentException("Invalid version string: " + vStr);
        }
    }

    public String toString() {
        return this.stringRepresentation;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    public boolean isLessThan(Version v) {
        if (this.getMajor() < v.getMajor()) {
            return true;
        }
        if (this.getMajor() == v.getMajor()) {
            if (this.getMinor() < v.getMinor()) {
                return true;
            }
            if (this.getMinor() == v.getMinor() && this.getPatch() < v.getPatch()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isGreaterThan(Version v) {
        if (this.getMajor() > v.getMajor()) {
            return true;
        }
        if (this.getMajor() == v.getMajor()) {
            if (this.getMinor() > v.getMinor()) {
                return true;
            }
            if (this.getMinor() == v.getMinor() && this.getPatch() > v.getPatch()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLessThanOrEqual(Version v) {
        return this.isLessThan(v) || this.equals(v);
    }

    @Override
    public boolean isGreaterThanOrEqual(Version v) {
        return this.isGreaterThan(v) || this.equals(v);
    }

    @Override
    public boolean isWithin(Version min2, Version max) {
        return this.isGreaterThanOrEqual(min2) && this.isLessThanOrEqual(max);
    }

    @Override
    public boolean isBetween(Version min2, Version max) {
        return this.isGreaterThan(min2) && this.isLessThan(max);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.stringRepresentation);
        hash = 97 * hash + this.major;
        hash = 97 * hash + this.minor;
        hash = 97 * hash + this.patch;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        if (!Objects.equals(this.stringRepresentation, other.stringRepresentation)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }
}

