from _typeshed import Incomplete
from typing import Any

from stripe import error as error
from stripe.request_metrics import RequestMetrics as RequestMetrics

version: Any
major: Any
minor: Any
patch: Any

def new_default_http_client(*args, **kwargs): ...

class HTTPClient:
    MAX_DELAY: int
    INITIAL_DELAY: float
    MAX_RETRY_AFTER: int
    def __init__(self, verify_ssl_certs: bool = True, proxy: Incomplete | None = None) -> None: ...
    def request_with_retries(self, method, url, headers, post_data: Incomplete | None = None): ...
    def request_stream_with_retries(self, method, url, headers, post_data: Incomplete | None = None): ...
    def request(self, method, url, headers, post_data: Incomplete | None = None) -> None: ...
    def request_stream(self, method, url, headers, post_data: Incomplete | None = None) -> None: ...
    def close(self) -> None: ...

class RequestsClient(HTTPClient):
    name: str
    def __init__(self, timeout: int = 80, session: Incomplete | None = None, **kwargs) -> None: ...
    def request(self, method, url, headers, post_data: Incomplete | None = None): ...
    def request_stream(self, method, url, headers, post_data: Incomplete | None = None): ...
    def close(self) -> None: ...

class UrlFetchClient(HTTPClient):
    name: str
    def __init__(self, verify_ssl_certs: bool = True, proxy: Incomplete | None = None, deadline: int = 55) -> None: ...
    def request(self, method, url, headers, post_data: Incomplete | None = None): ...
    def request_stream(self, method, url, headers, post_data: Incomplete | None = None): ...
    def close(self) -> None: ...

class PycurlClient(HTTPClient):
    name: str
    def __init__(self, verify_ssl_certs: bool = True, proxy: Incomplete | None = None) -> None: ...
    def parse_headers(self, data): ...
    def request(self, method, url, headers, post_data: Incomplete | None = None): ...
    def request_stream(self, method, url, headers, post_data: Incomplete | None = None): ...
    def close(self) -> None: ...

class Urllib2Client(HTTPClient):
    name: str
    def __init__(self, verify_ssl_certs: bool = True, proxy: Incomplete | None = None) -> None: ...
    def request(self, method, url, headers, post_data: Incomplete | None = None): ...
    def request_stream(self, method, url, headers, post_data: Incomplete | None = None): ...
    def close(self) -> None: ...
