/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.maps;

import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class LinkedHashToMultiTypeMap<T>
extends LinkedHashMap<T, String> {
    private static final long serialVersionUID = -664788513228402228L;

    public String getString(T field) {
        return (String)this.get(field);
    }

    public Double getDouble(T field) {
        String value = (String)this.get(field);
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        return NumberUtils.toDouble((String)value);
    }

    public Integer getInt(T field) {
        String value = (String)this.get(field);
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        return NumberUtils.toInt((String)value);
    }

    public double[] getDoubleArray(T field) {
        return this.getDoubleArray(field, ',');
    }

    public double[] getDoubleArray(T field, char splitChar) {
        String value = (String)this.get(field);
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        if (value.indexOf(splitChar) == -1) {
            return new double[]{this.getDouble(field)};
        }
        String[] splits = StringUtils.split((String)value, (char)splitChar);
        double[] result = new double[splits.length];
        int i = 0;
        for (String split : splits) {
            if (StringUtils.isBlank((String)split)) {
                split = "0";
            }
            result[i++] = NumberUtils.toDouble((String)split.trim());
        }
        return result;
    }

    public int[] getIntArray(T field) {
        return this.getIntArray(field, ',');
    }

    public int[] getIntArray(T field, char splitChar) {
        String value = (String)this.get(field);
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        if (value.indexOf(splitChar) == -1) {
            return new int[]{this.getInt(field)};
        }
        String[] splits = StringUtils.split((String)value, (char)splitChar);
        int[] result = new int[splits.length];
        int i = 0;
        for (String split : splits) {
            if (StringUtils.isBlank((String)split)) {
                split = "0";
            }
            result[i++] = NumberUtils.toInt((String)split.trim());
        }
        return result;
    }

    @Override
    public void put(T field, Double val) {
        if (val == null) {
            this.put(field, (String)null);
        } else {
            this.put(field, Double.toString(val));
        }
    }

    @Override
    public void put(T field, double[] val) {
        if (val == null) {
            this.put(field, (String)null);
        } else {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < val.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(Double.toString(val[i]));
            }
            this.put(field, result.toString());
        }
    }

    @Override
    public void put(T field, Integer val) {
        if (val == null) {
            this.put(field, (String)null);
        } else {
            this.put(field, Integer.toString(val));
        }
    }

    @Override
    public void put(T field, int[] val) {
        if (val == null) {
            this.put(field, (String)null);
        } else {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < val.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(Integer.toString(val[i]));
            }
            this.put(field, result.toString());
        }
    }
}

