/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-06 06:14:25 +0100 (Thu, 06 Mar 2014) $
//  number=$Revision: 9876 $
//  type=root

/**
 * Localized names for the "ml" locale.
 */
public class LocalizedNamesImpl_ml extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AO",
        "AD",
        "AF",
        "US",
        "AS",
        "IE",
        "AW",
        "AX",
        "AC",
        "AZ",
        "AQ",
        "AR",
        "AM",
        "AL",
        "DZ",
        "AI",
        "AG",
        "EC",
        "GQ",
        "IN",
        "IQ",
        "IR",
        "IT",
        "IL",
        "ID",
        "EG",
        "UA",
        "UG",
        "KP",
        "MP",
        "UY",
        "UZ",
        "ET",
        "ER",
        "EE",
        "SV",
        "IS",
        "IM",
        "OM",
        "AT",
        "AU",
        "KH",
        "KZ",
        "CA",
        "IC",
        "CM",
        "KI",
        "TL",
        "KG",
        "CW",
        "KW",
        "CK",
        "KE",
        "CV",
        "KY",
        "CO",
        "XK",
        "CD",
        "CG",
        "CC",
        "CI",
        "KM",
        "CR",
        "CU",
        "CX",
        "HR",
        "CP",
        "QA",
        "GY",
        "GM",
        "GA",
        "GW",
        "GP",
        "GG",
        "GD",
        "GR",
        "GL",
        "GU",
        "GT",
        "GN",
        "GH",
        "TD",
        "CL",
        "CZ",
        "CN",
        "JP",
        "JM",
        "DJ",
        "GI",
        "JE",
        "GE",
        "JO",
        "DE",
        "TZ",
        "TN",
        "TK",
        "TO",
        "TG",
        "TA",
        "TT",
        "TC",
        "DG",
        "DK",
        "DM",
        "DO",
        "TJ",
        "TH",
        "TW",
        "TV",
        "TR",
        "TM",
        "KR",
        "GS",
        "SS",
        "ZA",
        "NA",
        "NI",
        "NL",
        "AN",
        "NP",
        "NG",
        "NE",
        "NF",
        "NO",
        "NU",
        "NZ",
        "NR",
        "PA",
        "PG",
        "PY",
        "PW",
        "EH",
        "PK",
        "PS",
        "PN",
        "NC",
        "QO",
        "PE",
        "PL",
        "PT",
        "PR",
        "FO",
        "FK",
        "FJ",
        "PH",
        "FI",
        "GF",
        "TF",
        "PF",
        "FR",
        "BD",
        "BS",
        "BH",
        "BB",
        "BI",
        "BF",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BQ",
        "BO",
        "BW",
        "BA",
        "BR",
        "IO",
        "VG",
        "GB",
        "BN",
        "BV",
        "BM",
        "BG",
        "BT",
        "MN",
        "MO",
        "MG",
        "YT",
        "MW",
        "MY",
        "ML",
        "MV",
        "MK",
        "MQ",
        "MH",
        "MT",
        "MX",
        "FM",
        "MC",
        "MA",
        "MZ",
        "ME",
        "MS",
        "MM",
        "MR",
        "MU",
        "MD",
        "YE",
        "VI",
        "UM",
        "AE",
        "EU",
        "RU",
        "RE",
        "RO",
        "RW",
        "LU",
        "LB",
        "LV",
        "LA",
        "LI",
        "LT",
        "LY",
        "LS",
        "LR",
        "VA",
        "VU",
        "WF",
        "VN",
        "VE",
        "LK",
        "ZM",
        "WS",
        "ST",
        "SM",
        "SG",
        "ZW",
        "SX",
        "SL",
        "SY",
        "SD",
        "SR",
        "SN",
        "EA",
        "SC",
        "KN",
        "CF",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "RS",
        "CY",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "SA",
        "HU",
        "HM",
        "HT",
        "HK",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ലോകം");
    namesMap.put("002", "ആഫ്രിക്ക");
    namesMap.put("003", "വടക്കേ അമേരിക്കൻ ഭൂഖണ്ഡം");
    namesMap.put("005", "തെക്കേ അമേരിക്കൻ ഭൂഖണ്ഡം");
    namesMap.put("009", "ഓഷ്യാനിയ");
    namesMap.put("011", "പശ്ചിമ ആഫ്രിക്ക");
    namesMap.put("013", "മദ്ധ്യഅമേരിക്ക");
    namesMap.put("014", "കിഴക്കൻ ആഫ്രിക്ക");
    namesMap.put("015", "വടക്കേ ആഫ്രിക്ക");
    namesMap.put("017", "മദ്ധ്യആഫ്രിക്ക");
    namesMap.put("018", "തെക്കേ ആഫ്രിക്ക");
    namesMap.put("019", "അമേരിക്കൻ ഭൂഖണ്ഡം");
    namesMap.put("021", "വടക്കേ അമേരിക്ക");
    namesMap.put("029", "കരീബിയൻ");
    namesMap.put("030", "കിഴക്കൻ ഏഷ്യ");
    namesMap.put("034", "തെക്കേ ഏഷ്യ");
    namesMap.put("035", "തെക്ക്-കിഴക്കൻ ഏഷ്യ");
    namesMap.put("039", "തെക്കേ യൂറോപ്പ്");
    namesMap.put("053", "ഓസ്‌ട്രേലിയയും ന്യൂസിലാൻഡും");
    namesMap.put("054", "മെലനേഷ്യ");
    namesMap.put("057", "മൈക്രോനേഷ്യൻ പ്രദേശം");
    namesMap.put("061", "പോളിനേഷ്യ");
    namesMap.put("142", "ഏഷ്യ");
    namesMap.put("143", "മദ്ധ്യേഷ്യ");
    namesMap.put("145", "പശ്ചിമേഷ്യ");
    namesMap.put("150", "യൂറോപ്പ്");
    namesMap.put("151", "കിഴക്കൻ യൂറോപ്പ്");
    namesMap.put("154", "വടക്കേ യൂറോപ്പ്");
    namesMap.put("155", "പശ്ചിമ യൂറോപ്പ്");
    namesMap.put("419", "ലാറ്റിനമേരിക്ക");
    namesMap.put("AC", "അസൻഷൻ ദ്വീപ്");
    namesMap.put("AD", "അന്റോറ");
    namesMap.put("AE", "യുണൈറ്റഡ് അറബ് എമിറൈറ്റ്‌സ്");
    namesMap.put("AF", "അഫ്‌ഗാനിസ്ഥാൻ");
    namesMap.put("AG", "ആൻറിഗ്വയും ബർബുഡയും");
    namesMap.put("AI", "ആൻഗ്വില്ല");
    namesMap.put("AL", "അൽബേനിയ");
    namesMap.put("AM", "അർമേനിയ");
    namesMap.put("AN", "നെതർലൻഡ്സ് ആൻറിലിസ്");
    namesMap.put("AO", "അംഗോള");
    namesMap.put("AQ", "അൻറാർട്ടിക്ക");
    namesMap.put("AR", "അർജൻറീന");
    namesMap.put("AS", "അമേരിക്കൻ സാമോവ");
    namesMap.put("AT", "ഓസ്ട്രിയ");
    namesMap.put("AU", "ഓസ്‌ട്രേലിയ");
    namesMap.put("AW", "അറുബ");
    namesMap.put("AX", "അലൻഡ് ദ്വീപുകൾ");
    namesMap.put("AZ", "അസർബൈജാൻ");
    namesMap.put("BA", "ബോസ്നിയയും ഹെർസഗോവിനയും");
    namesMap.put("BB", "ബാർബഡോസ്");
    namesMap.put("BD", "ബംഗ്ലാദേശ്");
    namesMap.put("BE", "ബെൽജിയം");
    namesMap.put("BF", "ബുർക്കിനാ ഫാസോ");
    namesMap.put("BG", "ബൾഗേറിയ");
    namesMap.put("BH", "ബഹ്റൈൻ");
    namesMap.put("BI", "ബുറുണ്ടി");
    namesMap.put("BJ", "ബെനിൻ");
    namesMap.put("BL", "സെൻറ് ബാർത്തെൽമി");
    namesMap.put("BM", "ബർമുഡ");
    namesMap.put("BN", "ബ്രൂണൈ");
    namesMap.put("BO", "ബൊളീവിയ");
    namesMap.put("BQ", "ബൊണെയ്ർ, സിന്റ് യുസ്റ്റേഷ്യസ്, സാബ എന്നിവ");
    namesMap.put("BR", "ബ്രസീൽ");
    namesMap.put("BS", "ബഹാമാസ്");
    namesMap.put("BT", "ഭൂട്ടാൻ");
    namesMap.put("BV", "ബൗവെറ്റ് ദ്വീപ്");
    namesMap.put("BW", "ബോട്സ്വാന");
    namesMap.put("BY", "ബെലറൂസ്");
    namesMap.put("BZ", "ബെലീസ്");
    namesMap.put("CA", "കാനഡ");
    namesMap.put("CC", "കോക്കസ് ദ്വീപുകൾ");
    namesMap.put("CD", "കോംഗോ - കിൻഷാസ");
    namesMap.put("CF", "സെൻട്രൽ ആഫ്രിക്കൻ റിപ്പബ്ലിക്");
    namesMap.put("CG", "കോംഗോ - ബ്രാസാവിൽ");
    namesMap.put("CH", "സ്വിറ്റ്സർലാൻഡ്");
    namesMap.put("CI", "കോട്ട് ഡി വാർ");
    namesMap.put("CK", "കൂക്ക് ദ്വീപുകൾ");
    namesMap.put("CL", "ചിലി");
    namesMap.put("CM", "കാമറൂൺ");
    namesMap.put("CN", "ചൈന");
    namesMap.put("CO", "കൊളംബിയ");
    namesMap.put("CP", "ക്ലിപ്പെർട്ടൻ ദ്വീപ്");
    namesMap.put("CR", "കോസ്റ്ററിക്ക");
    namesMap.put("CU", "ക്യൂബ");
    namesMap.put("CV", "കേപ്പ് വെർഡെ");
    namesMap.put("CW", "കുറാകാവോ");
    namesMap.put("CX", "ക്രിസ്മസ് ദ്വീപ്");
    namesMap.put("CY", "സൈപ്രസ്സ്");
    namesMap.put("CZ", "ചെക്ക് റിപ്പബ്ലിക്");
    namesMap.put("DE", "ജർമനി");
    namesMap.put("DG", "ഡീഗോ ഗ്രാഷ്യ");
    namesMap.put("DJ", "ജിബൂട്ടി");
    namesMap.put("DK", "ഡെൻമാർക്ക്");
    namesMap.put("DM", "ഡൊമിനിക്ക");
    namesMap.put("DO", "ഡൊമിനിക്കൻ റിപ്പബ്ലിക്");
    namesMap.put("DZ", "അൾജീരിയ");
    namesMap.put("EA", "സെയൂത്ത ആൻഡ് മെലിയ");
    namesMap.put("EC", "ഇക്വഡോർ");
    namesMap.put("EE", "എസ്റ്റോണിയ‍");
    namesMap.put("EG", "ഈജിപ്ത്");
    namesMap.put("EH", "പശ്ചിമ സഹാറ");
    namesMap.put("ER", "എറിത്രിയ");
    namesMap.put("ES", "സ്‌പെയിൻ");
    namesMap.put("ET", "എത്യോപ്യ");
    namesMap.put("EU", "യൂറോപ്യൻ യൂണിയൻ");
    namesMap.put("FI", "ഫിൻലാൻഡ്");
    namesMap.put("FJ", "ഫിജി");
    namesMap.put("FK", "ഫാക്ക്‌ലാന്റ് ദ്വീപുകൾ");
    namesMap.put("FM", "മൈക്രോനേഷ്യ");
    namesMap.put("FO", "ഫറോയി ദ്വീപുകൾ");
    namesMap.put("FR", "ഫ്രാൻസ്");
    namesMap.put("GA", "ഗാബോൺ");
    namesMap.put("GB", "ബ്രിട്ടൻ");
    namesMap.put("GD", "ഗ്രനേഡ");
    namesMap.put("GE", "ജോർജിയ");
    namesMap.put("GF", "ഫ്രഞ്ച് ഗയാന");
    namesMap.put("GG", "ഗേൺസി");
    namesMap.put("GH", "ഘാന");
    namesMap.put("GI", "ജിബ്രാൾട്ടർ");
    namesMap.put("GL", "ഗ്രീൻലാൻറ്");
    namesMap.put("GM", "ഗാംബിയ");
    namesMap.put("GN", "ഗ്വിനിയ");
    namesMap.put("GP", "ഗുവാഡെലോപ്");
    namesMap.put("GQ", "ഇക്വിറ്റോറിയൽ ഗ്വിനിയ");
    namesMap.put("GR", "ഗ്രീസ്");
    namesMap.put("GS", "ദക്ഷിണ ജോർജ്ജിയയും ദക്ഷിണ സാൻഡ്‌വിച്ച് ദ്വീപുകളും");
    namesMap.put("GT", "ഗ്വാട്ടിമാലാ");
    namesMap.put("GU", "ഗ്വാം");
    namesMap.put("GW", "ഗിനി-ബിസോ");
    namesMap.put("GY", "ഗയാന");
    namesMap.put("HK", "ഹോങ് കോങ് എസ്.ഏ.ആർ. ചൈന");
    namesMap.put("HM", "ഹിയേർഡ് ദ്വീപും മക്ഡൊണാള്ഡ് ദ്വീപുകളും");
    namesMap.put("HN", "ഹോണ്ടുറാസ്");
    namesMap.put("HR", "ക്രൊയേഷ്യ");
    namesMap.put("HT", "ഹെയ്തി");
    namesMap.put("HU", "ഹംഗറി");
    namesMap.put("IC", "കാനറി ദ്വീപുകൾ");
    namesMap.put("ID", "ഇൻഡോനേഷ്യ");
    namesMap.put("IE", "അയർലാൻഡ്");
    namesMap.put("IL", "ഇസ്രായേൽ");
    namesMap.put("IM", "ഐൽ ഓഫ് മാൻ");
    namesMap.put("IN", "ഇന്ത്യ");
    namesMap.put("IO", "ബ്രിട്ടീഷ് ഇന്ത്യൻ മഹാസമുദ്ര പ്രദേശം");
    namesMap.put("IQ", "ഇറാക്ക്");
    namesMap.put("IR", "ഇറാൻ");
    namesMap.put("IS", "ഐസ്‌ലാന്റ്");
    namesMap.put("IT", "ഇറ്റലി");
    namesMap.put("JE", "ജേഴ്സി");
    namesMap.put("JM", "ജമൈക്ക");
    namesMap.put("JO", "ജോർദ്ദാൻ");
    namesMap.put("JP", "ജപ്പാൻ");
    namesMap.put("KE", "കെനിയ");
    namesMap.put("KG", "കിർഗിസ്ഥാൻ");
    namesMap.put("KH", "കംബോഡിയ");
    namesMap.put("KI", "കിരിബാത്തി");
    namesMap.put("KM", "കോമറോസ്");
    namesMap.put("KN", "സെയ്ൻറ് കിറ്റ്സും നെവിസും");
    namesMap.put("KP", "ഉത്തരകൊറിയ");
    namesMap.put("KR", "ദക്ഷിണകൊറിയ");
    namesMap.put("KW", "കുവൈറ്റ്");
    namesMap.put("KY", "കേമാൻ ദ്വീപുകൾ");
    namesMap.put("KZ", "കസാഖിസ്ഥാൻ");
    namesMap.put("LA", "ലാവോസ്");
    namesMap.put("LB", "ലബനോൺ");
    namesMap.put("LC", "സെൻറ് ലൂസിയ");
    namesMap.put("LI", "ലിച്ചൺസ്റ്റൈൻ");
    namesMap.put("LK", "ശ്രീലങ്ക");
    namesMap.put("LR", "ലൈബീരിയ");
    namesMap.put("LS", "ലെസോത്തോ");
    namesMap.put("LT", "ലിത്വാനിയ");
    namesMap.put("LU", "ലക്സംബർഗ്");
    namesMap.put("LV", "ലാത്വിയ");
    namesMap.put("LY", "ലിബിയ");
    namesMap.put("MA", "മൊറോക്കൊ");
    namesMap.put("MC", "മൊണോക്കൊ");
    namesMap.put("MD", "മൾഡോവ");
    namesMap.put("ME", "മോണ്ടേനേഗ്രോ");
    namesMap.put("MF", "സെൻറ് മാർട്ടിൻ");
    namesMap.put("MG", "മഡഗാസ്കർ");
    namesMap.put("MH", "മാർഷൽ‍‍ ദ്വീപുകൾ");
    namesMap.put("MK", "മാസിഡോണിയ");
    namesMap.put("ML", "മാലി");
    namesMap.put("MM", "മ്യാൻമാർ (ബർമ്മ)");
    namesMap.put("MN", "മംഗോളിയ");
    namesMap.put("MO", "മക്കാവോ SAR ചൈന");
    namesMap.put("MP", "ഉത്തര മറിയാനാ ദ്വീപുകൾ");
    namesMap.put("MQ", "മാർട്ടീനിക്");
    namesMap.put("MR", "മൗറിറ്റാനിയ");
    namesMap.put("MS", "മോണ്ട്സെറാറ്റ്");
    namesMap.put("MT", "മാൾട്ട");
    namesMap.put("MU", "മൗറീഷ്യസ്");
    namesMap.put("MV", "മാലിദ്വീപ്");
    namesMap.put("MW", "മലാവി");
    namesMap.put("MX", "മെക്സിക്കോ");
    namesMap.put("MY", "മലേഷ്യ");
    namesMap.put("MZ", "മൊസാംബിക്ക്");
    namesMap.put("NA", "നമീബിയ");
    namesMap.put("NC", "പുതിയ കാലിഡോണിയ");
    namesMap.put("NE", "നൈജർ");
    namesMap.put("NF", "നോർഫോക് ദ്വീപ്");
    namesMap.put("NG", "നൈജീരിയ");
    namesMap.put("NI", "നിക്കാരഗ്വ");
    namesMap.put("NL", "നെതർലൻഡ്സ്");
    namesMap.put("NO", "നോർവെ");
    namesMap.put("NP", "നേപ്പാൾ");
    namesMap.put("NR", "നൗറൂ");
    namesMap.put("NU", "ന്യൂവേ");
    namesMap.put("NZ", "ന്യൂസിലാൻറ്");
    namesMap.put("OM", "ഒമാൻ");
    namesMap.put("PA", "പനാമ");
    namesMap.put("PE", "പെറു");
    namesMap.put("PF", "ഫ്രഞ്ച് പോളിനേഷ്യ");
    namesMap.put("PG", "പപ്പുവ ന്യൂ ഗ്വിനി");
    namesMap.put("PH", "ഫിലിപ്പൈൻസ്");
    namesMap.put("PK", "പാക്കിസ്ഥാൻ");
    namesMap.put("PL", "പോളണ്ട്");
    namesMap.put("PM", "സെൻറ് പിയാറും മിക്വലണും");
    namesMap.put("PN", "പിറ്റ്കെയ്ൻ");
    namesMap.put("PR", "പോർട്ടോ റിക്കോ");
    namesMap.put("PS", "പാലസ്‌തീൻ പ്രദേശങ്ങൾ");
    namesMap.put("PT", "പോർച്ചുഗൽ");
    namesMap.put("PW", "പലാവു");
    namesMap.put("PY", "പരാഗ്വേ");
    namesMap.put("QA", "ഖത്തർ");
    namesMap.put("QO", "പുറംദ്വീപുകൾ");
    namesMap.put("RE", "റീയൂണിയൻ");
    namesMap.put("RO", "റുമേനിയ");
    namesMap.put("RS", "സെർബിയ");
    namesMap.put("RU", "റഷ്യ");
    namesMap.put("RW", "റുവാണ്ട");
    namesMap.put("SA", "സൗദി അറേബ്യ");
    namesMap.put("SB", "സോളമൻ‍ ദ്വീപുകൾ");
    namesMap.put("SC", "സെയ്‌ഷെൽസ്");
    namesMap.put("SD", "സുഡാൻ");
    namesMap.put("SE", "സ്വീഡൻ");
    namesMap.put("SG", "സിംഗപ്പുർ");
    namesMap.put("SH", "സെൻറ് ഹെലീന");
    namesMap.put("SI", "സ്ലോവേനിയ");
    namesMap.put("SJ", "സ്വാൽബാഡും ജാൻ മായേനും");
    namesMap.put("SK", "സ്ലോവാക്യ");
    namesMap.put("SL", "സിയേറാ ലിയോൺ");
    namesMap.put("SM", "സാൻ മറിനോ");
    namesMap.put("SN", "സെനഗൽ");
    namesMap.put("SO", "സോമാലിയ");
    namesMap.put("SR", "സുറിനാം");
    namesMap.put("SS", "ദക്ഷിണ സുഡാൻ");
    namesMap.put("ST", "സാവോ റ്റമെ ആൻഡ് പ്രിൻസിപ്പി");
    namesMap.put("SV", "എൽ സാൽവദോർ");
    namesMap.put("SX", "സിന്റ് മാർട്ടെൻ");
    namesMap.put("SY", "സിറിയ");
    namesMap.put("SZ", "സ്വാസിലാൻറ്");
    namesMap.put("TA", "ട്രസ്റ്റൻ ഡ കൂന");
    namesMap.put("TC", "ടർക്ക്സും കൈക്കോ ദ്വീപുകളും");
    namesMap.put("TD", "ചാഡ്");
    namesMap.put("TF", "ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം");
    namesMap.put("TG", "ടോഗോ");
    namesMap.put("TH", "തായ്‌ലാൻഡ്");
    namesMap.put("TJ", "താജിക്കിസ്ഥാൻ");
    namesMap.put("TK", "ടൊകെലാവു");
    namesMap.put("TL", "കിഴക്കൻ തിമൂർ");
    namesMap.put("TM", "തുർക്ക്മെനിസ്ഥാൻ");
    namesMap.put("TN", "ടുണീഷ്യ");
    namesMap.put("TO", "ടോംഗ");
    namesMap.put("TR", "തുർക്കി");
    namesMap.put("TT", "ട്രിനിഡാഡും റ്റൊബാഗോയും");
    namesMap.put("TV", "തുവാലു");
    namesMap.put("TW", "തായ്‌വാൻ");
    namesMap.put("TZ", "ടാൻസാനിയ");
    namesMap.put("UA", "ഉക്രൈൻ");
    namesMap.put("UG", "ഉഗാണ്ട");
    namesMap.put("UM", "യു.എസ് ചെറിയ പുറംദ്വീപുകളും");
    namesMap.put("US", "അമേരിക്കൻ ഐക്യനാടുകൾ");
    namesMap.put("UY", "ഉറുഗ്വേ");
    namesMap.put("UZ", "ഉസ്‌ബെക്കിസ്ഥാൻ");
    namesMap.put("VA", "വത്തിക്കാൻ");
    namesMap.put("VC", "സെൻറ് വിൻസൻറും ഗ്രനഡൈൻസും");
    namesMap.put("VE", "വെനിസ്വേല");
    namesMap.put("VG", "ബ്രിട്ടീഷ് വെർജിൻ ദ്വീപുകൾ");
    namesMap.put("VI", "യു.എസ്. വെർജിൻ ദ്വീപുകൾ");
    namesMap.put("VN", "വിയറ്റ്നാം");
    namesMap.put("VU", "വന്വാത്തു");
    namesMap.put("WF", "വാലിസ് ആൻഡ് ഫ്യുചൂന");
    namesMap.put("WS", "സാമോവ");
    namesMap.put("XK", "കൊസോവൊ");
    namesMap.put("YE", "യമൻ");
    namesMap.put("YT", "മയോട്ട്");
    namesMap.put("ZA", "ദക്ഷിണാഫ്രിക്ക");
    namesMap.put("ZM", "സാംബിയ");
    namesMap.put("ZW", "സിംബാബ്‌വേ");
    namesMap.put("ZZ", "അജ്ഞാത പ്രദേശം");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ലോകം",
        "002": "ആഫ്രിക്ക",
        "003": "വടക്കേ അമേരിക്കൻ ഭൂഖണ്ഡം",
        "005": "തെക്കേ അമേരിക്കൻ ഭൂഖണ്ഡം",
        "009": "ഓഷ്യാനിയ",
        "011": "പശ്ചിമ ആഫ്രിക്ക",
        "013": "മദ്ധ്യഅമേരിക്ക",
        "014": "കിഴക്കൻ ആഫ്രിക്ക",
        "015": "വടക്കേ ആഫ്രിക്ക",
        "017": "മദ്ധ്യആഫ്രിക്ക",
        "018": "തെക്കേ ആഫ്രിക്ക",
        "019": "അമേരിക്കൻ ഭൂഖണ്ഡം",
        "021": "വടക്കേ അമേരിക്ക",
        "029": "കരീബിയൻ",
        "030": "കിഴക്കൻ ഏഷ്യ",
        "034": "തെക്കേ ഏഷ്യ",
        "035": "തെക്ക്-കിഴക്കൻ ഏഷ്യ",
        "039": "തെക്കേ യൂറോപ്പ്",
        "053": "ഓസ്‌ട്രേലിയയും ന്യൂസിലാൻഡും",
        "054": "മെലനേഷ്യ",
        "057": "മൈക്രോനേഷ്യൻ പ്രദേശം",
        "061": "പോളിനേഷ്യ",
        "142": "ഏഷ്യ",
        "143": "മദ്ധ്യേഷ്യ",
        "145": "പശ്ചിമേഷ്യ",
        "150": "യൂറോപ്പ്",
        "151": "കിഴക്കൻ യൂറോപ്പ്",
        "154": "വടക്കേ യൂറോപ്പ്",
        "155": "പശ്ചിമ യൂറോപ്പ്",
        "419": "ലാറ്റിനമേരിക്ക",
        "AC": "അസൻഷൻ ദ്വീപ്",
        "AD": "അന്റോറ",
        "AE": "യുണൈറ്റഡ് അറബ് എമിറൈറ്റ്‌സ്",
        "AF": "അഫ്‌ഗാനിസ്ഥാൻ",
        "AG": "ആൻറിഗ്വയും ബർബുഡയും",
        "AI": "ആൻഗ്വില്ല",
        "AL": "അൽബേനിയ",
        "AM": "അർമേനിയ",
        "AN": "നെതർലൻഡ്സ് ആൻറിലിസ്",
        "AO": "അംഗോള",
        "AQ": "അൻറാർട്ടിക്ക",
        "AR": "അർജൻറീന",
        "AS": "അമേരിക്കൻ സാമോവ",
        "AT": "ഓസ്ട്രിയ",
        "AU": "ഓസ്‌ട്രേലിയ",
        "AW": "അറുബ",
        "AX": "അലൻഡ് ദ്വീപുകൾ",
        "AZ": "അസർബൈജാൻ",
        "BA": "ബോസ്നിയയും ഹെർസഗോവിനയും",
        "BB": "ബാർബഡോസ്",
        "BD": "ബംഗ്ലാദേശ്",
        "BE": "ബെൽജിയം",
        "BF": "ബുർക്കിനാ ഫാസോ",
        "BG": "ബൾഗേറിയ",
        "BH": "ബഹ്റൈൻ",
        "BI": "ബുറുണ്ടി",
        "BJ": "ബെനിൻ",
        "BL": "സെൻറ് ബാർത്തെൽമി",
        "BM": "ബർമുഡ",
        "BN": "ബ്രൂണൈ",
        "BO": "ബൊളീവിയ",
        "BQ": "ബൊണെയ്ർ, സിന്റ് യുസ്റ്റേഷ്യസ്, സാബ എന്നിവ",
        "BR": "ബ്രസീൽ",
        "BS": "ബഹാമാസ്",
        "BT": "ഭൂട്ടാൻ",
        "BV": "ബൗവെറ്റ് ദ്വീപ്",
        "BW": "ബോട്സ്വാന",
        "BY": "ബെലറൂസ്",
        "BZ": "ബെലീസ്",
        "CA": "കാനഡ",
        "CC": "കോക്കസ് ദ്വീപുകൾ",
        "CD": "കോംഗോ - കിൻഷാസ",
        "CF": "സെൻട്രൽ ആഫ്രിക്കൻ റിപ്പബ്ലിക്",
        "CG": "കോംഗോ - ബ്രാസാവിൽ",
        "CH": "സ്വിറ്റ്സർലാൻഡ്",
        "CI": "കോട്ട് ഡി വാർ",
        "CK": "കൂക്ക് ദ്വീപുകൾ",
        "CL": "ചിലി",
        "CM": "കാമറൂൺ",
        "CN": "ചൈന",
        "CO": "കൊളംബിയ",
        "CP": "ക്ലിപ്പെർട്ടൻ ദ്വീപ്",
        "CR": "കോസ്റ്ററിക്ക",
        "CU": "ക്യൂബ",
        "CV": "കേപ്പ് വെർഡെ",
        "CW": "കുറാകാവോ",
        "CX": "ക്രിസ്മസ് ദ്വീപ്",
        "CY": "സൈപ്രസ്സ്",
        "CZ": "ചെക്ക് റിപ്പബ്ലിക്",
        "DE": "ജർമനി",
        "DG": "ഡീഗോ ഗ്രാഷ്യ",
        "DJ": "ജിബൂട്ടി",
        "DK": "ഡെൻമാർക്ക്",
        "DM": "ഡൊമിനിക്ക",
        "DO": "ഡൊമിനിക്കൻ റിപ്പബ്ലിക്",
        "DZ": "അൾജീരിയ",
        "EA": "സെയൂത്ത ആൻഡ് മെലിയ",
        "EC": "ഇക്വഡോർ",
        "EE": "എസ്റ്റോണിയ‍",
        "EG": "ഈജിപ്ത്",
        "EH": "പശ്ചിമ സഹാറ",
        "ER": "എറിത്രിയ",
        "ES": "സ്‌പെയിൻ",
        "ET": "എത്യോപ്യ",
        "EU": "യൂറോപ്യൻ യൂണിയൻ",
        "FI": "ഫിൻലാൻഡ്",
        "FJ": "ഫിജി",
        "FK": "ഫാക്ക്‌ലാന്റ് ദ്വീപുകൾ",
        "FM": "മൈക്രോനേഷ്യ",
        "FO": "ഫറോയി ദ്വീപുകൾ",
        "FR": "ഫ്രാൻസ്",
        "GA": "ഗാബോൺ",
        "GB": "ബ്രിട്ടൻ",
        "GD": "ഗ്രനേഡ",
        "GE": "ജോർജിയ",
        "GF": "ഫ്രഞ്ച് ഗയാന",
        "GG": "ഗേൺസി",
        "GH": "ഘാന",
        "GI": "ജിബ്രാൾട്ടർ",
        "GL": "ഗ്രീൻലാൻറ്",
        "GM": "ഗാംബിയ",
        "GN": "ഗ്വിനിയ",
        "GP": "ഗുവാഡെലോപ്",
        "GQ": "ഇക്വിറ്റോറിയൽ ഗ്വിനിയ",
        "GR": "ഗ്രീസ്",
        "GS": "ദക്ഷിണ ജോർജ്ജിയയും ദക്ഷിണ സാൻഡ്‌വിച്ച് ദ്വീപുകളും",
        "GT": "ഗ്വാട്ടിമാലാ",
        "GU": "ഗ്വാം",
        "GW": "ഗിനി-ബിസോ",
        "GY": "ഗയാന",
        "HK": "ഹോങ് കോങ് എസ്.ഏ.ആർ. ചൈന",
        "HM": "ഹിയേർഡ് ദ്വീപും മക്ഡൊണാള്ഡ് ദ്വീപുകളും",
        "HN": "ഹോണ്ടുറാസ്",
        "HR": "ക്രൊയേഷ്യ",
        "HT": "ഹെയ്തി",
        "HU": "ഹംഗറി",
        "IC": "കാനറി ദ്വീപുകൾ",
        "ID": "ഇൻഡോനേഷ്യ",
        "IE": "അയർലാൻഡ്",
        "IL": "ഇസ്രായേൽ",
        "IM": "ഐൽ ഓഫ് മാൻ",
        "IN": "ഇന്ത്യ",
        "IO": "ബ്രിട്ടീഷ് ഇന്ത്യൻ മഹാസമുദ്ര പ്രദേശം",
        "IQ": "ഇറാക്ക്",
        "IR": "ഇറാൻ",
        "IS": "ഐസ്‌ലാന്റ്",
        "IT": "ഇറ്റലി",
        "JE": "ജേഴ്സി",
        "JM": "ജമൈക്ക",
        "JO": "ജോർദ്ദാൻ",
        "JP": "ജപ്പാൻ",
        "KE": "കെനിയ",
        "KG": "കിർഗിസ്ഥാൻ",
        "KH": "കംബോഡിയ",
        "KI": "കിരിബാത്തി",
        "KM": "കോമറോസ്",
        "KN": "സെയ്ൻറ് കിറ്റ്സും നെവിസും",
        "KP": "ഉത്തരകൊറിയ",
        "KR": "ദക്ഷിണകൊറിയ",
        "KW": "കുവൈറ്റ്",
        "KY": "കേമാൻ ദ്വീപുകൾ",
        "KZ": "കസാഖിസ്ഥാൻ",
        "LA": "ലാവോസ്",
        "LB": "ലബനോൺ",
        "LC": "സെൻറ് ലൂസിയ",
        "LI": "ലിച്ചൺസ്റ്റൈൻ",
        "LK": "ശ്രീലങ്ക",
        "LR": "ലൈബീരിയ",
        "LS": "ലെസോത്തോ",
        "LT": "ലിത്വാനിയ",
        "LU": "ലക്സംബർഗ്",
        "LV": "ലാത്വിയ",
        "LY": "ലിബിയ",
        "MA": "മൊറോക്കൊ",
        "MC": "മൊണോക്കൊ",
        "MD": "മൾഡോവ",
        "ME": "മോണ്ടേനേഗ്രോ",
        "MF": "സെൻറ് മാർട്ടിൻ",
        "MG": "മഡഗാസ്കർ",
        "MH": "മാർഷൽ‍‍ ദ്വീപുകൾ",
        "MK": "മാസിഡോണിയ",
        "ML": "മാലി",
        "MM": "മ്യാൻമാർ (ബർമ്മ)",
        "MN": "മംഗോളിയ",
        "MO": "മക്കാവോ SAR ചൈന",
        "MP": "ഉത്തര മറിയാനാ ദ്വീപുകൾ",
        "MQ": "മാർട്ടീനിക്",
        "MR": "മൗറിറ്റാനിയ",
        "MS": "മോണ്ട്സെറാറ്റ്",
        "MT": "മാൾട്ട",
        "MU": "മൗറീഷ്യസ്",
        "MV": "മാലിദ്വീപ്",
        "MW": "മലാവി",
        "MX": "മെക്സിക്കോ",
        "MY": "മലേഷ്യ",
        "MZ": "മൊസാംബിക്ക്",
        "NA": "നമീബിയ",
        "NC": "പുതിയ കാലിഡോണിയ",
        "NE": "നൈജർ",
        "NF": "നോർഫോക് ദ്വീപ്",
        "NG": "നൈജീരിയ",
        "NI": "നിക്കാരഗ്വ",
        "NL": "നെതർലൻഡ്സ്",
        "NO": "നോർവെ",
        "NP": "നേപ്പാൾ",
        "NR": "നൗറൂ",
        "NU": "ന്യൂവേ",
        "NZ": "ന്യൂസിലാൻറ്",
        "OM": "ഒമാൻ",
        "PA": "പനാമ",
        "PE": "പെറു",
        "PF": "ഫ്രഞ്ച് പോളിനേഷ്യ",
        "PG": "പപ്പുവ ന്യൂ ഗ്വിനി",
        "PH": "ഫിലിപ്പൈൻസ്",
        "PK": "പാക്കിസ്ഥാൻ",
        "PL": "പോളണ്ട്",
        "PM": "സെൻറ് പിയാറും മിക്വലണും",
        "PN": "പിറ്റ്കെയ്ൻ",
        "PR": "പോർട്ടോ റിക്കോ",
        "PS": "പാലസ്‌തീൻ പ്രദേശങ്ങൾ",
        "PT": "പോർച്ചുഗൽ",
        "PW": "പലാവു",
        "PY": "പരാഗ്വേ",
        "QA": "ഖത്തർ",
        "QO": "പുറംദ്വീപുകൾ",
        "RE": "റീയൂണിയൻ",
        "RO": "റുമേനിയ",
        "RS": "സെർബിയ",
        "RU": "റഷ്യ",
        "RW": "റുവാണ്ട",
        "SA": "സൗദി അറേബ്യ",
        "SB": "സോളമൻ‍ ദ്വീപുകൾ",
        "SC": "സെയ്‌ഷെൽസ്",
        "SD": "സുഡാൻ",
        "SE": "സ്വീഡൻ",
        "SG": "സിംഗപ്പുർ",
        "SH": "സെൻറ് ഹെലീന",
        "SI": "സ്ലോവേനിയ",
        "SJ": "സ്വാൽബാഡും ജാൻ മായേനും",
        "SK": "സ്ലോവാക്യ",
        "SL": "സിയേറാ ലിയോൺ",
        "SM": "സാൻ മറിനോ",
        "SN": "സെനഗൽ",
        "SO": "സോമാലിയ",
        "SR": "സുറിനാം",
        "SS": "ദക്ഷിണ സുഡാൻ",
        "ST": "സാവോ റ്റമെ ആൻഡ് പ്രിൻസിപ്പി",
        "SV": "എൽ സാൽവദോർ",
        "SX": "സിന്റ് മാർട്ടെൻ",
        "SY": "സിറിയ",
        "SZ": "സ്വാസിലാൻറ്",
        "TA": "ട്രസ്റ്റൻ ഡ കൂന",
        "TC": "ടർക്ക്സും കൈക്കോ ദ്വീപുകളും",
        "TD": "ചാഡ്",
        "TF": "ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം",
        "TG": "ടോഗോ",
        "TH": "തായ്‌ലാൻഡ്",
        "TJ": "താജിക്കിസ്ഥാൻ",
        "TK": "ടൊകെലാവു",
        "TL": "കിഴക്കൻ തിമൂർ",
        "TM": "തുർക്ക്മെനിസ്ഥാൻ",
        "TN": "ടുണീഷ്യ",
        "TO": "ടോംഗ",
        "TR": "തുർക്കി",
        "TT": "ട്രിനിഡാഡും റ്റൊബാഗോയും",
        "TV": "തുവാലു",
        "TW": "തായ്‌വാൻ",
        "TZ": "ടാൻസാനിയ",
        "UA": "ഉക്രൈൻ",
        "UG": "ഉഗാണ്ട",
        "UM": "യു.എസ് ചെറിയ പുറംദ്വീപുകളും",
        "US": "അമേരിക്കൻ ഐക്യനാടുകൾ",
        "UY": "ഉറുഗ്വേ",
        "UZ": "ഉസ്‌ബെക്കിസ്ഥാൻ",
        "VA": "വത്തിക്കാൻ",
        "VC": "സെൻറ് വിൻസൻറും ഗ്രനഡൈൻസും",
        "VE": "വെനിസ്വേല",
        "VG": "ബ്രിട്ടീഷ് വെർജിൻ ദ്വീപുകൾ",
        "VI": "യു.എസ്. വെർജിൻ ദ്വീപുകൾ",
        "VN": "വിയറ്റ്നാം",
        "VU": "വന്വാത്തു",
        "WF": "വാലിസ് ആൻഡ് ഫ്യുചൂന",
        "WS": "സാമോവ",
        "XK": "കൊസോവൊ",
        "YE": "യമൻ",
        "YT": "മയോട്ട്",
        "ZA": "ദക്ഷിണാഫ്രിക്ക",
        "ZM": "സാംബിയ",
        "ZW": "സിംബാബ്‌വേ",
        "ZZ": "അജ്ഞാത പ്രദേശം"
    };
  }-*/;
}
