/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.icon.ArrowIcon;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class SkinComboBoxUI
extends BasicComboBoxUI {
    private Skin skin = SkinLookAndFeel.getSkin();
    private boolean rollover = false;
    private MouseListener rolloverListener;

    public SkinComboBoxUI() {
        this.currentValuePane = new CellRendererPane(){

            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                JComponent jc = (JComponent)c;
                jc.setOpaque(false);
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                jc.setOpaque(true);
            }
        };
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension prefs = super.getMinimumSize(c);
        Dimension combo = this.skin.getPersonality().getComboBoxPreferredSize(this.comboBox);
        prefs.width = Math.max(prefs.width, combo.width);
        prefs.height = Math.max(prefs.height, combo.height);
        return prefs;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected void installListeners() {
        super.installListeners();
        this.rolloverListener = this.createRolloverListener();
        this.comboBox.addMouseListener(this.rolloverListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.rolloverListener);
        this.rolloverListener = null;
    }

    protected MouseListener createRolloverListener() {
        return new RolloverMouseListener();
    }

    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        Rectangle r = this.rectangleForCurrentValue();
        this.skin.getPersonality().paintComboBox(g, this.comboBox, r, this.hasFocus, this.rollover);
        if (!this.comboBox.isEditable() || this.editor == null || !this.editor.isVisible()) {
            this.paintCurrentValue(g, r, false);
        }
    }

    protected Insets getInsets() {
        return this.skin.getPersonality().getComboBoxInsets();
    }

    protected JButton createArrowButton() {
        JButton button = new JButton(new ArrowIcon(5));
        return button;
    }

    protected void installComponents() {
        super.installComponents();
        this.arrowButton.setVisible(false);
    }

    protected void configureEditor() {
        super.configureEditor();
        this.editor.addMouseListener(this.rolloverListener);
        if (this.comboBox.getEditor() != null && this.comboBox.getEditor() instanceof UIResource && this.editor instanceof JComponent) {
            ((JComponent)this.editor).setOpaque(false);
        }
    }

    protected void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeMouseListener(this.rolloverListener);
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
    }

    protected LayoutManager createLayoutManager() {
        return new SkinComboBoxLayoutManager();
    }

    protected JComboBox comboBox() {
        return this.comboBox;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener downAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SkinComboBoxUI.this.comboBox().isEnabled()) {
                    if (SkinComboBoxUI.this.isPopupVisible()) {
                        SkinComboBoxUI.this.selectNextPossibleValue();
                    } else {
                        SkinComboBoxUI.this.setPopupVisible(SkinComboBoxUI.this.comboBox(), true);
                    }
                }
            }
        };
        this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke(40, 0), 1);
        this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke("KP_DOWN"), 1);
        ActionListener altAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SkinComboBoxUI.this.comboBox().isEnabled() && SkinComboBoxUI.this.isPopupVisible()) {
                    SkinComboBoxUI.this.togglePopup();
                }
            }
        };
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(40, 8), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke("alt KP_DOWN"), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke(38, 8), 1);
        this.comboBox.registerKeyboardAction(altAction, KeyStroke.getKeyStroke("alt KP_UP"), 1);
        ActionListener upAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SkinComboBoxUI.this.comboBox().isEnabled() && SkinComboBoxUI.this.isPopupVisible()) {
                    SkinComboBoxUI.this.selectPreviousPossibleValue();
                }
            }
        };
        this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 1);
        this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke("KP_UP"), 1);
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_UP"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_UP"));
    }

    protected Component editor() {
        return this.editor;
    }

    boolean isPopupVisible() {
        return super.isPopupVisible(this.comboBox);
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SkinComboBoxUI();
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new SkinPropertyChangeListener();
    }

    public class SkinComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            if (SkinComboBoxUI.this.editor() != null) {
                Rectangle cvb = SkinComboBoxUI.this.rectangleForCurrentValue();
                SkinComboBoxUI.this.editor().setBounds(cvb);
            }
        }
    }

    public class SkinPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public SkinPropertyChangeListener() {
            super(SkinComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                SkinComboBoxUI.this.arrowButton.setBackground(color);
                SkinComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                SkinComboBoxUI.this.arrowButton.setForeground(color);
                SkinComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    public class RolloverMouseListener
    extends MouseAdapter {
        public void mouseEntered(MouseEvent event) {
            SkinComboBoxUI.this.rollover = true;
            SkinComboBoxUI.this.comboBox.repaint();
        }

        public void mouseExited(MouseEvent event) {
            SkinComboBoxUI.this.rollover = false;
            SkinComboBoxUI.this.comboBox.repaint();
        }
    }
}

