/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFCheckerState;
import com.adobe.epubcheck.ocf.encryption.AdobeFontManglingFilter;
import com.adobe.epubcheck.ocf.encryption.IDPFFontManglingFilter;
import com.adobe.epubcheck.ocf.encryption.UnsupportedEncryptionFilter;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.handlers.XMLHandler;
import com.adobe.epubcheck.xml.model.XMLElement;
import com.google.common.base.Strings;
import io.mola.galimatias.URL;

class OCFEncryptionFileHandler
extends XMLHandler {
    private static final String ALGORITHM = "algorithm";
    private final OCFCheckerState state;

    public OCFEncryptionFileHandler(ValidationContext context, OCFCheckerState state) {
        super(context, state.getContainer().getRootURL());
        this.state = state;
    }

    @Override
    public void startElement() {
        String comp;
        XMLElement parent;
        String algorithm;
        XMLElement e = this.currentElement();
        if (e.getName().equals("CipherReference")) {
            String urlString;
            URL url;
            String algorithm2 = null;
            XMLElement parent2 = e.getParent();
            if (parent2 != null && (parent2 = parent2.getParent()) != null && parent2.getName().equals("EncryptedData")) {
                algorithm2 = (String)parent2.getPrivateData(ALGORITHM);
            }
            if ((url = this.checkURL(urlString = e.getAttribute("URI"))) != null) {
                if (!this.state.getContainer().contains(url)) {
                    this.context.report.message(MessageId.RSC_007, this.location(), urlString);
                    return;
                }
                switch (Strings.nullToEmpty((String)algorithm2)) {
                    case "http://www.idpf.org/2008/embedding": {
                        this.state.addEncryptedResource(url, new IDPFFontManglingFilter(null));
                        this.state.addObfuscatedResource(url, this.location());
                        break;
                    }
                    case "http://ns.adobe.com/pdf/enc#RC": {
                        this.state.addEncryptedResource(url, new AdobeFontManglingFilter(null));
                        break;
                    }
                    default: {
                        this.state.addEncryptedResource(url, new UnsupportedEncryptionFilter());
                    }
                }
            }
        } else if (e.getName().equals("EncryptionMethod") && (algorithm = e.getAttribute("Algorithm")) != null && (parent = e.getParent()) != null && (comp = parent.getAttributeNS("http://ns.adobe.com/digitaleditions/enc", "compression")) == null) {
            parent.setPrivateData(ALGORITHM, algorithm);
        }
    }
}

