/*
 * Decompiled with CFR 0.152.
 */
package ints;

import ints.IntArray;
import ints.IntList;

public final class PackedIntArray
implements IntArray {
    private static final byte maxPackIndex = (byte)Integer.numberOfTrailingZeros(32);
    private final byte packIndex;
    private final int size;
    private final int[] ia;

    private PackedIntArray(int[] nArray, int n, byte by) {
        this.packIndex = by;
        this.size = n;
        this.ia = nArray;
    }

    public PackedIntArray(int[] nArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.packIndex = PackedIntArray.packIndex(n);
        byte by = (byte)(1 << this.packIndex);
        int n2 = (32 >> this.packIndex) - 1;
        this.size = nArray.length;
        this.ia = new int[(this.size + n2) / (n2 + 1)];
        for (int i = 0; i < this.size; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 >= n) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            int n4 = i >> maxPackIndex - this.packIndex;
            this.ia[n4] = this.ia[n4] | n3 << (i & n2) * by;
        }
    }

    public PackedIntArray(IntList intList, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.packIndex = PackedIntArray.packIndex(n);
        byte by = (byte)(1 << this.packIndex);
        int n2 = (32 >> this.packIndex) - 1;
        this.size = intList.size();
        this.ia = new int[(this.size + n2) / (n2 + 1)];
        for (int i = 0; i < this.size; ++i) {
            int n3 = intList.get(i);
            if (n3 < 0 || n3 >= n) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            int n4 = i >> maxPackIndex - this.packIndex;
            this.ia[n4] = this.ia[n4] | n3 << (i & n2) * by;
        }
    }

    public static PackedIntArray fromSignedByteArray(byte[] byArray, int n) {
        boolean bl = false;
        return PackedIntArray.fromByteArray(byArray, 0, byArray.length, n, bl);
    }

    public static PackedIntArray fromSignedByteArray(byte[] byArray, int n, int n2, int n3) {
        boolean bl = false;
        return PackedIntArray.fromByteArray(byArray, n, n2, n3, bl);
    }

    public static PackedIntArray fromUnsignedByteArray(byte[] byArray, int n) {
        boolean bl = true;
        return PackedIntArray.fromByteArray(byArray, 0, byArray.length, n, bl);
    }

    public static PackedIntArray fromUnsignedByteArray(byte[] byArray, int n, int n2, int n3) {
        boolean bl = true;
        return PackedIntArray.fromByteArray(byArray, n, n2, n3, bl);
    }

    private static PackedIntArray fromByteArray(byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (n3 < 1) {
            throw new IllegalArgumentException(String.valueOf(n3));
        }
        int n4 = bl ? 127 : 255;
        byte by = PackedIntArray.packIndex(n3);
        byte by2 = (byte)(1 << by);
        int n5 = (32 >> by) - 1;
        int n6 = n2 - n;
        int[] nArray = new int[(n6 + n5) / (n5 + 1)];
        for (int i = n; i < n2; ++i) {
            int n7 = i - n;
            int n8 = byArray[i] & n4;
            if (n8 < 0 || n8 >= n3) {
                throw new IllegalArgumentException(String.valueOf(n8));
            }
            int n9 = n7 >> maxPackIndex - by;
            nArray[n9] = nArray[n9] | n8 << (n7 & n5) * by2;
        }
        return new PackedIntArray(nArray, n6, by);
    }

    public static PackedIntArray fromUnsignedTwoByteArray(byte[] byArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if ((byArray.length & 1) != 0) {
            throw new IllegalArgumentException(String.valueOf(byArray.length));
        }
        byte by = PackedIntArray.packIndex(n);
        byte by2 = (byte)(1 << by);
        int n2 = (32 >> by) - 1;
        int n3 = byArray.length / 2;
        int[] nArray = new int[(n3 + n2) / (n2 + 1)];
        for (int i = 0; i < n3; ++i) {
            int n4 = 0xFFFF & ((byArray[2 * i] & 0xFF) << 8 | byArray[2 * i + 1] & 0xFF);
            if (n4 < 0 || n4 >= n) {
                throw new IllegalArgumentException(String.valueOf(n4));
            }
            int n5 = i >> maxPackIndex - by;
            nArray[n5] = nArray[n5] | n4 << (i & n2) * by2;
        }
        return new PackedIntArray(nArray, n3, by);
    }

    private static byte packIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 1) {
            return 0;
        }
        int n2 = PackedIntArray.roundUpToPowerOfTwo(n);
        int n3 = Integer.numberOfTrailingZeros(n2);
        n2 = PackedIntArray.roundUpToPowerOfTwo(n3);
        return (byte)Integer.numberOfTrailingZeros(n2);
    }

    private static int roundUpToPowerOfTwo(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return ++n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = 1 << this.packIndex;
        int n3 = (1 << n2) - 1;
        byte by = (byte)((32 >> this.packIndex) - 1);
        return this.ia[n >> maxPackIndex - this.packIndex] >>> (n & by) * n2 & n3;
    }
}

