/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.fusesource.scalate.util.IOUtil$;
import org.fusesource.scalate.util.SourceMap;
import org.fusesource.scalate.util.SourceMap$;
import org.fusesource.scalate.util.SourceMapInstaller;
import org.fusesource.scalate.util.SourceMapStratum;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SourceMapInstaller$
implements ScalaObject {
    public static final SourceMapInstaller$ MODULE$;
    private final int SOURCE_DEBUG_EXTENSION_MAX_SIZE;
    private final String nameSDE;

    static {
        new SourceMapInstaller$();
    }

    public int SOURCE_DEBUG_EXTENSION_MAX_SIZE() {
        return this.SOURCE_DEBUG_EXTENSION_MAX_SIZE;
    }

    public String nameSDE() {
        return this.nameSDE;
    }

    public String load(File classFile) {
        return this.load(this.read(classFile));
    }

    public String load(byte[] classFile) {
        return new SourceMapInstaller.Reader(classFile).load();
    }

    public void store(File classFile, File sourceDebug) {
        this.store(classFile, this.readText(sourceDebug));
    }

    public void store(File classFile, String sourceDebug) {
        File tmpFile = new File(new StringBuilder().append((Object)classFile.getPath()).append((Object)"tmp").toString());
        this.store(classFile, sourceDebug, tmpFile);
        if (classFile.delete()) {
            if (tmpFile.renameTo(classFile)) {
                return;
            }
            throw new IOException("temp file rename failed");
        }
        throw new IOException("temp file delete failed");
    }

    public void store(File input, String sourceDebug, File output) {
        this.store(this.read(input), sourceDebug, output);
    }

    public void store(File input, File sourceDebug, File output) {
        this.store(this.read(input), this.readText(sourceDebug), output);
    }

    public void store(byte[] input, String sourceDebug, File output) {
        IOUtil$.MODULE$.writeBinaryFile(output, this.store(input, sourceDebug));
    }

    public byte[] store(byte[] input, String sourceDebug) {
        byte[] bytes = sourceDebug.getBytes("UTF-8");
        return bytes.length <= this.SOURCE_DEBUG_EXTENSION_MAX_SIZE() ? new SourceMapInstaller.Writer(input, sourceDebug).store() : input;
    }

    private String readText(File input) {
        return new String(this.read(input), "UTF-8");
    }

    private byte[] read(File input) {
        if (input.exists()) {
            return IOUtil$.MODULE$.loadBinaryFile(input);
        }
        throw new FileNotFoundException(new StringBuilder().append((Object)"no such file: ").append((Object)input).toString());
    }

    public void main(String[] args) {
        SourceMap smap1 = new SourceMap();
        smap1.setOutputFileName("foo.scala");
        SourceMapStratum straturm = new SourceMapStratum("JSP");
        straturm.addFile("foo.scala", "path/to/foo.scala");
        straturm.addLine(1, 0, 1, 2, 1);
        straturm.addLine(2, 0, 1, 3, 1);
        straturm.addLine(4, 0, 1, 8, 1);
        straturm.addLine(5, 0, 1, 9, 1);
        smap1.addStratum(straturm, true);
        String text1 = smap1.toString();
        Predef$.MODULE$.println((Object)text1);
        SourceMap smap2 = SourceMap$.MODULE$.parse(text1);
        String text2 = smap2.toString();
        Predef$.MODULE$.println((Object)text2);
        String string = text2;
        String string2 = text1;
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0));
        Predef$.MODULE$.println(smap2.mapToStratum(3, smap2.mapToStratum$default$2()));
    }

    private SourceMapInstaller$() {
        MODULE$ = this;
        this.SOURCE_DEBUG_EXTENSION_MAX_SIZE = Integer.getInteger("SOURCE_DEBUG_EXTENSION_MAX_SIZE", 65535);
        this.nameSDE = "SourceDebugExtension";
    }
}

