require "color/rgb/jp/base/encode"

module Color::RGB::JP::Base

  class ColorName
    include Encode

    def self.encoded_attr_reader(internal_encoding, *attributes)
      attributes.each do |attr|
        class_eval %Q{
          def #{attr}(encoding = "#{internal_encoding}")
            encode_to(encoding, "#{internal_encoding}", @#{attr})
          end
        }
      end
    end

    encoded_attr_reader Encode::INTERNAL_ENCODING, :kanji, :hiragana, :katakana, :romaji
    attr_reader :const_name

    def initialize(const_name, kanji, hiragana, katakana = nil, romaji = nil)
      @const_name = const_name
      @kanji = kanji
      @hiragana = hiragana
      @katakana = katakana
      @romaji = romaji
    end

    def to_s
      romaji
    end

    def names(encoding = Encode::INTERNAL_ENCODING)
      %W(kanji hiragana katakana romaji).map{|e| self.__send__(e, encoding) }
    end
    alias to_a names
  end

end
