/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelPair
extends JPanel {
    public LabelPair(String title, JComponent widget, Group group) {
        if (group == null) {
            this.add("Before", new JLabel(title));
            this.add("Center", widget);
        } else {
            this.setLayout(group);
            group.list.add(this);
            JLabel label = new JLabel(title);
            this.add(label);
            label.setLabelFor(widget);
            this.add(widget);
        }
    }

    @Override
    public void invalidate() {
        LayoutManager lm = this.getLayout();
        if (lm instanceof Group) {
            ((Group)lm).invalidate();
        }
        super.invalidate();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        ((JComponent)this.getComponent(0)).setToolTipText(text);
        ((JComponent)this.getComponent(1)).setToolTipText(text);
    }

    public static class Group
    implements LayoutManager {
        private ArrayList<LabelPair> list = new ArrayList();
        private int prefLabelW;
        private int prefWidgetW;
        private int minLabelW;
        private int minWidgetW;
        private boolean valid = false;

        @Override
        public void addLayoutComponent(String desc, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            throw new RuntimeException();
        }

        @Override
        public Dimension preferredLayoutSize(Container cont) {
            int h1;
            int h2;
            if (!this.valid) {
                this.computeSizes();
            }
            if ((h2 = cont.getComponent((int)1).getPreferredSize().height) > (h1 = cont.getComponent((int)0).getPreferredSize().height)) {
                h1 = h2;
            }
            return new Dimension(this.prefLabelW + this.prefWidgetW, h1);
        }

        @Override
        public Dimension minimumLayoutSize(Container cont) {
            int h1;
            int h2;
            if (!this.valid) {
                this.computeSizes();
            }
            if ((h2 = cont.getComponent((int)1).getMinimumSize().height) > (h1 = cont.getComponent((int)0).getMinimumSize().height)) {
                h1 = h2;
            }
            return new Dimension(this.minLabelW + this.minWidgetW, h1);
        }

        public void computeSizes() {
            this.minLabelW = 0;
            this.minWidgetW = 0;
            this.prefLabelW = 0;
            this.prefWidgetW = 0;
            for (LabelPair lp : this.list) {
                int w = lp.getComponent((int)0).getMinimumSize().width;
                if (w > this.minLabelW) {
                    this.minLabelW = w;
                }
                if ((w = lp.getComponent((int)1).getMinimumSize().width) > this.minWidgetW) {
                    this.minWidgetW = w;
                }
                if ((w = lp.getComponent((int)0).getPreferredSize().width) > this.prefLabelW) {
                    this.prefLabelW = w;
                }
                if ((w = lp.getComponent((int)1).getPreferredSize().width) <= this.prefWidgetW) continue;
                this.prefWidgetW = w;
            }
            this.valid = true;
        }

        @Override
        public void layoutContainer(Container cont) {
            int labW;
            if (!this.valid) {
                this.computeSizes();
            }
            Dimension size = cont.getSize();
            if (size.width >= this.prefLabelW + this.prefWidgetW) {
                labW = this.prefLabelW;
            } else {
                labW = this.minLabelW;
                int extra = size.width - (this.minLabelW + this.minWidgetW);
                int extraNeed = this.prefLabelW + this.prefWidgetW - (this.minLabelW + this.minWidgetW);
                if (extraNeed > 0) {
                    labW += extra * (this.prefLabelW - this.minLabelW) / extraNeed;
                }
            }
            int xor = cont.getComponentOrientation().isLeftToRight() ? 0 : 1;
            cont.getComponent(xor).setBounds(0, 0, labW, size.height);
            cont.getComponent(1 - xor).setBounds(labW, 0, size.width - labW, size.height);
        }

        public final void invalidate() {
            this.valid = false;
        }
    }
}

