# See if the resume1 test case locks up the kernel
# Requires 2017.12.04.12.53.46-9999.99.99.99.99.99-re-enable-test.patch

import os
import anita
import pexpect
from bracket import *

name = 'resume1'

# based on kgdb_remote.py

def test_func(ts):
    dist = anita.URL(anita_dist_url(ts))

    # Note that we need to increase memory from the default of 32M, or gdb will
    # take ages reading the symbols from /netbsd.
    a = anita.Anita(dist, memory_size = '256M', vmm_args = [], workdir = anita_workdir(ts))
    a.boot()
    a.login()
    a.child.send('cd /usr/tests/lib/libc/sys/ && atf-run ./t_ptrace_wait\r')
    a.child.send('ls\r')
    a.child.send('expr 1524209675 + 1\r')
    try:
        a.child.expect('1524209676')
    except pexpect.TIMEOUT:
        return False
    return True

def op():
    return TestOp(test_func, [install_op], name = name)
