package TDS::Calendar;
# $Id: Calendar.pm,v 1.19 2000/12/25 05:46:51 tom Exp $
################################################################

=head1 NAME

TDS::Calendar

=head1 SYNOPSIS

=cut

use strict qw(vars);
use ObjectTemplate;
use vars qw(@ISA);
@ISA = qw(ObjectTemplate);

use DateTime::Date;
use Template;

use TDS::System;
use TDS::Collection;
use TDS::Navigator::Monthly;

################################################################

=head1 STATIC VARIABLES

 $TableBorder     table border
 @WeekString      week string array
 $NextTemplate    template to next month
 $PrevTemplate    template to previous month
 $ThisTemplate    template to this month

=cut

use vars qw($TableBorder @WeekString
	    $NextTemplate $PrevTemplate $ThisTemplate
	    $HrefTemplateShowed
	    $HrefTemplateUnshowedDynamic $HrefTemplateUnshowedStatic
	    );
#	    @NoTableBrowsers $UseTable);


$TableBorder = 0 unless defined $TableBorder;
@WeekString = ('<span style="color: red">Sun</span>', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat') unless defined @WeekString;
$NextTemplate = "Next" unless defined $NextTemplate;
$PrevTemplate = "Prev" unless defined $PrevTemplate;
$ThisTemplate = "%year/%month" unless defined $ThisTemplate;
$HrefTemplateShowed = "#%anchor" unless defined $HrefTemplateShowed;
$HrefTemplateUnshowedDynamic = "./?%y%0m%part#%anchor" unless defined $HrefTemplateUnshowedDynamic;
$HrefTemplateUnshowedStatic = "d%y%0m%part.%suffix#%anchor" unless defined $HrefTemplateUnshowedStatic;

attributes qw(suffix);

################################################################
sub initialize($)
{
    my $self = shift;

    if (TDS::Mode::IsStatic()){
	require TDS::Static;
	$self->suffix($TDS::Static::HtmlSuffix);
    }
    $self->SUPER::initialize;
}


=head2 $t->AsHTML($year, $month, $col);

return HTML of $year/$month calendar.
$col is TDS::Collection object.

=cut

sub AsHTML($$$$)
{
    my ($self, $year, $month, $col) = @_;
    ($year, $month) = (sprintf("%04d", $year), sprintf("%02d", $month));

    unless ($TDS::Status->no_table){
	$self->AsTableHTML($year, $month, $col);
    } else {
	$self->AsNoTableHTML($year, $month, $col);
    }
}
sub AsTableHTML ($$$$)
{
    my ($self, $year, $month, $col) = @_;
    my $html;

    # table start
    $html .= qq(<table border="$TableBorder" summary="calendar">\n);
    ################
    # monthly template
    my $nav = new TDS::Navigator::Monthly(year=>$year, month=>$month, day=>1);
    $html .= "<tr>\n";

    $html .= qq(<th colspan="2" align="left" abbr="prev">);
    $html .= $nav->AsPrev($PrevTemplate);
    $html .= "</th>\n";
    $html .= qq(<th colspan="3" align="center" abbr="this">);
    $html .= $nav->AsThis($ThisTemplate);
    $html .= "</th>\n";
    $html .= qq(<th colspan="2" align="right" abbr="next">);
    $html .= $nav->AsNext($NextTemplate);
    $html .= "</th>\n";
    $html .= "</tr>\n";

    my $date = $nav;
    # weekly string label
    $html .= "<tr>\n";
    for (0..6){
	$html .= qq(<th align="center">) .
	    $WeekString[$_] .
		"</th>\n";
    }
    $html .= "</tr>\n";
    ################
    # date
    # spaces
    my $start_week = $date->week;
    if ($start_week){
        $html .= "\n<tr>";
	for my $i (1..$start_week){
	    $html .= "<td></td>";
	}
    }
    # 1..31
    my @table;
    # check exist or not
    for ($col->pickup_files($year, $month, 1, 31)){
	my ($file, $y, $m, $d) = @$_;
	$table[$d] = 'EXIST'
	    if $year == $y && $month == $m;
    }
    # check displayed just now
    for (@{$col->files}){
	my ($file, $y, $m, $d) = @$_;
	$table[$d] = 'SHOWED'
	    if $year == $y && $month == $m;
    }
    for (1..$date->DaysMonth){
	my $day = $_;
	if (($day+$start_week)%7-1 == 0){
	    $html .= "</tr>\n"

		if $start_week || $day >= 7;
	    $html .= qq(<tr>\n);
	}
	$html .= qq(<td align="right">);
	if ($_ = $table[$day]){
	    my $href;
	    $date->Set($year, $month, $day);
	    my $params = $date->GetParams;
	    require TDS::Tdf::Command::DIARY;
	    $params->{anchor} = Expand($TDS::Tdf::Command::DIARY::Anchor, $params);

	    $params->{suffix} = $self->suffix;
	    
	    if ($_ eq 'SHOWED'){                # showed
		$href = Expand($HrefTemplateShowed, $params);
	    } elsif ($_ eq 'EXIST'){            # unshowed but exist
		my $href_template =
		    sprintf("HrefTemplateUnshowed%s",
			    (TDS::Mode::IsDynamic())? 'Dynamic' : 'Static');
		$href = Expand($$href_template, $params);
	    } else {
		die 'BUG in Calendar';
	    }
	    $html .= qq(<a href="$href">$day</a>);
	} else {
	    $html .= qq($day);
	}
	$html .= qq(</td>\n);
    }
    $html .= "</tr>\n";
    $html .= qq(</table>);
    return $html;
}

sub AsNoTableHTML($$$$)
{
    my ($self, $year, $month, $col) = @_;
    my $html;
    
    # month
    my $date = new DateTime::Date(year=>$year, month=>$month, day=>1);
    # day
    my $start_week = $date->week;
    # 1..31
    my @table;
    # check exist or not
    for ($col->pickup_files($year, $month, 1, 31)){
	my ($file, $y, $m, $d) = @$_;
	$table[$d] = 'EXIST'
	    if $year == $y && $month == $m &&
		(! -z $file);

    }
    # check showed or not
    for (@{$col->files}){
	my ($file, $y, $m, $d) = @$_;
	$table[$d] = 'SHOWED';
    }
    for (1..$date->DaysMonth){
	my $day = $_;
	my $w = ($day+$start_week-1)%7;
	
	if ($w == 0){
	    $html .= " | \n";
	}
	if ($_ = $table[$day]){
	    my $href;
	    if ($_ eq 'SHOWED'){
		$href = sprintf("#%02d", $day);
	    } elsif ($_ eq 'EXIST'){
		if (TDS::Mode::IsStatic()){
		    $href = sprintf("d%04d%02d%s.%s#%02d",
				    $year, $month, ('a','b','c','c')[int($day/10)],
				    $self->suffix, $day);
		} else {
		    $href = sprintf("?%04d%02d%02d#%02d",
				    $year, $month, $day, $day);
		}
	    } else {
		die 'BUG in Calendar';
	    }
	    $html .= qq( <a href="$href">$day</a>);
	} else {
	    $html .= " $day ";
	}
		
    }
    $html .= " | \n";

    my $nav = new TDS::Navigator::Monthly(year=>$year, month=>$month, day=>1);
    $html = ($nav->AsThis($ThisTemplate)) . "|\n" . $html;
    $html .= $nav->AsPrev($PrevTemplate);
    $html .= $nav->AsNext($NextTemplate);
    $html .= "<br>";
    return $html;
}
    
1;

