/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import net.claribole.zvtm.lens.TLens;

public class TWaveLens
extends TLens {
    float N = 5.0f;
    protected double aT = 0.0;
    protected double bT = 0.0;

    public TWaveLens() {
        this.MM = 2.0f;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
    }

    public TWaveLens(float mm, float n) {
        this.MM = mm;
        this.N = n;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
    }

    public TWaveLens(float mm, float tc, float tf, int outerRadius, int innerRadius, float n) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.N = n;
        this.MMTc = tc;
        this.MMTf = tf;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
    }

    public TWaveLens(float mm, float tc, float tf, int outerRadius, int innerRadius, float n, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.N = n;
        this.MMTc = tc;
        this.MMTf = tf;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
        this.lx = x;
        this.ly = y;
    }

    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.bT = (float)this.LR2 / this.N;
    }

    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.bT = (float)this.LR2 / this.N;
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
        this.bT = (float)this.LR2 / this.N;
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.bT = (float)this.LR2 / this.N;
    }

    void computeDropoffFactors() {
        this.aT = this.MMTf - this.MMTc;
        this.bT = (float)this.LR2 / this.N;
    }

    public void setN(float n) {
        this.N = n;
        this.bT = (float)this.LR2 / this.N;
    }

    public float getN() {
        return this.N;
    }

    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        if (this.d <= (double)this.LR2) {
            g[0] = this.MMTf;
        } else if (this.d <= (double)this.LR1) {
            g[0] = (float)(this.aT * Math.sin(this.d / (double)this.N - this.bT) / (this.d / (double)this.N - this.bT) + (double)this.MMTc);
            if (g[0] < this.MMTc) {
                g[0] = this.MMTc;
            }
        } else {
            g[0] = 0.0f;
        }
    }
}

