/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AudioFormat {
    protected boolean bigEndian;
    protected int channels;
    protected Encoding encoding;
    protected float frameRate;
    protected int frameSize;
    protected float sampleRate;
    protected int sampleSizeInBits;
    private Map properties;

    public int getChannels() {
        return this.channels;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean matches(AudioFormat audioFormat) {
        if (!this.encoding.equals(audioFormat.encoding) || this.channels != audioFormat.channels || this.sampleSizeInBits != audioFormat.sampleSizeInBits || this.frameSize != audioFormat.frameSize) {
            return false;
        }
        if (this.sampleRate != -1.0f && audioFormat.sampleRate != -1.0f && this.sampleRate != audioFormat.sampleRate) {
            return false;
        }
        if (this.frameRate != -1.0f && audioFormat.frameRate != -1.0f && this.frameRate != audioFormat.frameRate) {
            return false;
        }
        if (this.sampleSizeInBits > 8) {
            return this.bigEndian ^ audioFormat.bigEndian ^ true;
        }
        return true;
    }

    public Map properties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.encoding);
        stringBuffer.append(" ");
        stringBuffer.append(this.sampleRate);
        stringBuffer.append(" Hz ");
        stringBuffer.append(this.sampleSizeInBits);
        stringBuffer.append(" bits ");
        stringBuffer.append(this.channels);
        stringBuffer.append(" channels");
        if (this.sampleSizeInBits > 8) {
            stringBuffer.append(this.bigEndian ? " big endian" : " little endian");
        }
        return stringBuffer.toString();
    }

    public AudioFormat(Encoding encoding, float f, int n, int n2, int n3, float f2, boolean bl) {
        this.encoding = encoding;
        this.sampleRate = f;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.frameSize = n3;
        this.frameRate = f2;
        this.bigEndian = bl;
        this.properties = Collections.EMPTY_MAP;
    }

    public AudioFormat(Encoding encoding, float f, int n, int n2, int n3, float f2, boolean bl, Map map) {
        this.encoding = encoding;
        this.sampleRate = f;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.frameSize = n3;
        this.frameRate = f2;
        this.bigEndian = bl;
        this.properties = Collections.unmodifiableMap(new HashMap(map));
    }

    public AudioFormat(float f, int n, int n2, boolean bl, boolean bl2) {
        this.encoding = bl ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED;
        this.sampleRate = f;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.frameSize = n == -1 || n2 == -1 ? -1 : (n + 7) / 8 * n2;
        this.frameRate = f;
        this.bigEndian = bl2;
        this.properties = Collections.EMPTY_MAP;
    }

    public static class Encoding {
        public static final Encoding ALAW = new Encoding("alaw");
        public static final Encoding PCM_SIGNED = new Encoding("pcm_signed");
        public static final Encoding PCM_UNSIGNED = new Encoding("pcm_unsigned");
        public static final Encoding ULAW = new Encoding("ulaw");
        private String name;

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }

        public Encoding(String string) {
            this.name = string;
        }
    }
}

